-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Feb 09, 2026 at 08:27 AM
-- Server version: 8.0.30
-- PHP Version: 8.3.29

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `inventory_acf`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `generate_kode_aset` (IN `p_id_kantor` INT, IN `p_id_kategori` INT, IN `p_id_jenis_asset` INT, IN `p_id_sumber_dana` INT, OUT `p_kode_aset` VARCHAR(25), OUT `p_nomor_urut` INT)   BEGIN
    DECLARE v_kode_kantor VARCHAR(10);
    DECLARE v_nomor_kategori VARCHAR(2);
    DECLARE v_nomor_sumber VARCHAR(2);
    DECLARE v_prefix CHAR(1);

    SELECT kode_kantor
    INTO v_kode_kantor
    FROM ref_kantor
    WHERE id = p_id_kantor
    LIMIT 1;

    SELECT nomor_kategori
    INTO v_nomor_kategori
    FROM ref_kategori
    WHERE id = p_id_kategori
    LIMIT 1;

    SELECT nomor_sumber
    INTO v_nomor_sumber
    FROM ref_sumber_dana
    WHERE id = p_id_sumber_dana
    LIMIT 1;

    SELECT prefix_huruf
    INTO v_prefix
    FROM ref_jenis_asset
    WHERE id = p_id_jenis_asset
    LIMIT 1;

    SELECT COALESCE(MAX(nomor_urut), 0) + 1
    INTO p_nomor_urut
    FROM inventory
    WHERE id_kantor = p_id_kantor
      AND id_kategori = p_id_kategori
      AND prefix_huruf = v_prefix;

    SET p_kode_aset = CONCAT(
        v_kode_kantor, '-',
        v_nomor_kategori, '-',
        v_prefix, '-',
        LPAD(p_nomor_urut, 4, '0'), '-',
        v_nomor_sumber
    );
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_get_dashboard_summary` (IN `p_tahun_ajaran` VARCHAR(20), IN `p_kategori_siswa` VARCHAR(20), IN `p_jenis_pembayaran` VARCHAR(20))   BEGIN
    SELECT 
        s.nama_sekolah,
        pt.target_tahunan,
        pt.capaian_tahunan,
        pt.piutang_tahunan,
        pt.persentase_capaian,
        pt.kategori_kepatuhan
    FROM pembayaran_tahunan pt
    JOIN sekolah s ON pt.sekolah_id = s.id
    JOIN tahun_ajaran ta ON pt.tahun_ajaran_id = ta.id
    JOIN jenis_pembayaran jp ON pt.jenis_pembayaran_id = jp.id
    JOIN kategori_siswa ks ON pt.kategori_siswa_id = ks.id
    WHERE ta.tahun_ajaran = p_tahun_ajaran
    AND (p_kategori_siswa = 'SEMUA' OR ks.kode_kategori = p_kategori_siswa)
    AND jp.kode_pembayaran = p_jenis_pembayaran
    AND s.status = 'AKTIF'
    ORDER BY s.nama_sekolah;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_get_inventory_summary` ()   BEGIN
    SELECT 
        (SELECT COUNT(*) FROM inventory) as total_inventory,
        (SELECT SUM(harga_perolehan) FROM inventory) as total_value,
        (SELECT COUNT(DISTINCT kantor) FROM inventory) as total_offices,
        (SELECT COUNT(DISTINCT jenis_barang) FROM inventory) as total_types,
        (SELECT COUNT(*) FROM inventory WHERE YEAR(tanggal_perolehan) = YEAR(CURDATE())) as items_this_year;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_get_monthly_details` (IN `p_sekolah_kode` VARCHAR(20), IN `p_tahun_ajaran` VARCHAR(20), IN `p_jenis_pembayaran` VARCHAR(20), IN `p_kategori_siswa` VARCHAR(20))   BEGIN
    SELECT 
        pb.nama_bulan,
        pb.target_bulanan,
        pb.capaian_bulanan,
        pb.piutang_bulanan,
        pb.persentase_capaian,
        pb.kategori_kepatuhan
    FROM pembayaran_bulanan pb
    JOIN pembayaran_tahunan pt ON pb.pembayaran_tahunan_id = pt.id
    JOIN sekolah s ON pt.sekolah_id = s.id
    JOIN tahun_ajaran ta ON pt.tahun_ajaran_id = ta.id
    JOIN jenis_pembayaran jp ON pt.jenis_pembayaran_id = jp.id
    JOIN kategori_siswa ks ON pt.kategori_siswa_id = ks.id
    WHERE s.kode_sekolah = p_sekolah_kode
    AND ta.tahun_ajaran = p_tahun_ajaran
    AND jp.kode_pembayaran = p_jenis_pembayaran
    AND ks.kode_kategori = p_kategori_siswa
    ORDER BY pb.bulan;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `activity_log`
--

CREATE TABLE `activity_log` (
  `id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `record_id` int DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `activity_log`
--

INSERT INTO `activity_log` (`id`, `user_id`, `action`, `table_name`, `record_id`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(1, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 04:06:10'),
(2, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-05 04:07:31'),
(3, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 04:07:35'),
(4, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-05 04:11:02'),
(5, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 04:11:34'),
(6, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-05 04:20:59'),
(7, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 04:21:02'),
(8, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-05 04:25:13'),
(9, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 04:25:18'),
(10, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-05 05:18:39'),
(11, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 05:18:42'),
(12, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-05 05:19:33'),
(13, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 05:19:38'),
(14, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-05 06:56:09'),
(15, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 06:56:12'),
(16, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-05 08:06:46'),
(17, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 08:06:49'),
(18, NULL, 'Login', 'users', 7, 'User Manager Inventory logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-05 10:49:21'),
(19, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-06 04:50:19'),
(20, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 04:50:23'),
(21, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 05:46:12'),
(22, NULL, 'Login', 'users', 8, 'User Staff Gudang logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 05:46:15'),
(23, NULL, 'Logout', 'users', 8, 'User Staff Gudang logged out', '127.0.0.1', NULL, '2026-02-06 05:56:39'),
(24, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 05:57:06'),
(25, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 05:58:01'),
(26, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 05:58:10'),
(27, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 05:58:14'),
(28, 14, 'Login', 'users', 14, 'User kyla nazwa logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 05:58:25'),
(29, 14, 'Logout', 'users', 14, 'User kyla nazwa logged out', '127.0.0.1', NULL, '2026-02-06 05:59:37'),
(30, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 05:59:41'),
(31, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 06:09:31'),
(32, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:09:39'),
(33, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-06 06:11:13'),
(34, 1, 'Login', 'users', 1, 'User Administrator ACF logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:11:16'),
(35, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 06:16:43'),
(36, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:16:47'),
(37, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:40:05'),
(38, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:40:06'),
(39, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 06:46:38'),
(40, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:02:59'),
(41, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-06 09:41:59'),
(42, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:42:02'),
(43, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-06 09:42:45'),
(44, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:42:49'),
(45, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:42:52'),
(46, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:42:54'),
(47, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:43:02'),
(48, NULL, 'Login', 'users', 8, 'User Staff Gudang (Role: staff) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 09:43:43'),
(49, NULL, 'Logout', 'users', 8, 'User Staff Gudang logged out', '127.0.0.1', NULL, '2026-02-06 10:00:04'),
(50, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:07'),
(51, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:10'),
(52, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:11'),
(53, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:14'),
(54, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:16'),
(55, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:17'),
(56, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:20'),
(57, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:00:22'),
(58, NULL, 'Login', 'users', 8, 'User Staff Gudang (Role: staff) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:02:10'),
(59, NULL, 'Logout', 'users', 8, 'User Staff Gudang logged out', '127.0.0.1', NULL, '2026-02-06 10:02:20'),
(60, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-06 10:02:23'),
(61, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 01:24:47'),
(62, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 01:26:27'),
(63, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 01:27:26'),
(64, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 01:27:28'),
(65, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 01:37:44'),
(66, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 02:14:21'),
(67, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 02:14:25'),
(68, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-09 02:19:23'),
(69, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 02:19:27'),
(70, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 03:13:28'),
(71, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:13:32'),
(72, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-09 03:13:48'),
(73, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:14:06'),
(74, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:14:11'),
(75, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:14:14'),
(76, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:14:15'),
(77, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:14:51'),
(78, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-09 03:28:18'),
(79, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:28:22'),
(80, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 03:33:04'),
(81, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:33:09'),
(82, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-09 03:35:21'),
(83, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:35:25'),
(84, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 03:36:24'),
(85, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 03:36:27'),
(86, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-09 04:14:16'),
(87, 14, 'Login', 'users', 14, 'User kyla nazwa (Role: staff) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 04:14:21'),
(88, 14, 'Logout', 'users', 14, 'User kyla nazwa logged out', '127.0.0.1', NULL, '2026-02-09 04:29:47'),
(89, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 04:29:52'),
(90, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-09 05:10:25'),
(91, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:10:39'),
(92, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 05:20:07'),
(93, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:20:12'),
(94, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 05:20:38'),
(95, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:21:02'),
(96, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 05:23:47'),
(97, 15, 'Login', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd (Role: director) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:23:53'),
(98, 15, 'Logout', 'users', 15, 'User ivan Supangat, S.Pd.I, M.Pd logged out', '127.0.0.1', NULL, '2026-02-09 05:24:41'),
(99, 14, 'Login', 'users', 14, 'User kyla nazwa (Role: staff) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:25:00'),
(100, 14, 'Logout', 'users', 14, 'User kyla nazwa logged out', '127.0.0.1', NULL, '2026-02-09 05:26:26'),
(101, NULL, 'Login', 'users', 7, 'User Manager Inventory (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:26:31'),
(102, NULL, 'Logout', 'users', 7, 'User Manager Inventory logged out', '127.0.0.1', NULL, '2026-02-09 05:27:54'),
(103, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 05:28:01'),
(104, 1, 'Logout', 'users', 1, 'User Administrator ACF logged out', '127.0.0.1', NULL, '2026-02-09 08:09:39'),
(105, 16, 'Login', 'users', 16, 'User Silka Shafanisa, S.Psi (Role: dept_head) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 08:09:56'),
(106, 16, 'Logout', 'users', 16, 'User Silka Shafanisa, S.Psi logged out', '127.0.0.1', NULL, '2026-02-09 08:10:36'),
(107, 17, 'Login', 'users', 17, 'User Andri Herdiana, S.E (Role: staff) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 08:10:43'),
(108, 17, 'Logout', 'users', 17, 'User Andri Herdiana, S.E logged out', '127.0.0.1', NULL, '2026-02-09 08:11:08'),
(109, 1, 'Login', 'users', 1, 'User Administrator ACF (Role: admin) logged in successfully. Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', NULL, '2026-02-09 08:11:17');

-- --------------------------------------------------------

--
-- Table structure for table `inventory`
--

CREATE TABLE `inventory` (
  `id` int NOT NULL,
  `no` int NOT NULL,
  `kode_aset` varchar(50) DEFAULT NULL,
  `tanggal_perolehan` date NOT NULL,
  `kategori` varchar(50) NOT NULL,
  `sumber_dana` varchar(100) NOT NULL,
  `kantor` varchar(100) NOT NULL,
  `jenis_barang` varchar(100) NOT NULL,
  `spesifikasi` text COMMENT 'Spesifikasi detail barang (merk, model, ukuran, dll)',
  `status` enum('aktif','lelang','rusak','hilang','dihapus') DEFAULT 'aktif',
  `tanggal_keluar` date DEFAULT NULL,
  `tujuan` varchar(200) DEFAULT NULL,
  `keterangan_keluar` text,
  `harga_lelang` decimal(15,2) DEFAULT NULL,
  `pembeli` varchar(200) DEFAULT NULL,
  `jenis_inventory` text NOT NULL,
  `harga_perolehan` decimal(15,2) NOT NULL DEFAULT '0.00',
  `umur_ekonomis` int DEFAULT '5' COMMENT 'Umur ekonomis barang dalam tahun (default 5 tahun)',
  `nilai_residu` decimal(15,2) DEFAULT '0.00' COMMENT 'Nilai residu/sisa di akhir umur ekonomis',
  `metode_penyusutan` enum('garis_lurus','saldo_menurun','unit_produksi') DEFAULT 'garis_lurus' COMMENT 'Metode perhitungan penyusutan',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_kantor` int DEFAULT NULL,
  `id_kategori` int DEFAULT NULL,
  `id_jenis_asset` int DEFAULT NULL,
  `id_sumber_dana` int DEFAULT NULL,
  `prefix_huruf` char(1) DEFAULT NULL,
  `nomor_urut` int DEFAULT NULL,
  `kode_aset_auto` varchar(25) DEFAULT NULL,
  `foto` varchar(255) DEFAULT NULL,
  `merk` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `inventory`
--

INSERT INTO `inventory` (`id`, `no`, `kode_aset`, `tanggal_perolehan`, `kategori`, `sumber_dana`, `kantor`, `jenis_barang`, `spesifikasi`, `status`, `tanggal_keluar`, `tujuan`, `keterangan_keluar`, `harga_lelang`, `pembeli`, `jenis_inventory`, `harga_perolehan`, `umur_ekonomis`, `nilai_residu`, `metode_penyusutan`, `created_at`, `updated_at`, `id_kantor`, `id_kategori`, `id_jenis_asset`, `id_sumber_dana`, `prefix_huruf`, `nomor_urut`, `kode_aset_auto`, `foto`, `merk`) VALUES
(1, 1, NULL, '2023-11-30', 'Peralatan', 'Operasional', 'Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : Pembelian Laptop', '6850000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.002.OPE', NULL, 'Lenovo\r'),
(2, 2, NULL, '2023-11-30', 'Peralatan', 'SE', 'SDJ Medan', 'Printer', '\nModel: L3210\r\nTipe: Ink Tank\r\nFungsi: Print, Scan, Copy\r\nResolusi: 5760 x 1440 dpi\r\nKoneksi: USB\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran Cab SD Juara Medan : Bantuan Operasional Sekolah : Printer', '6880000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'SMX.PER.002.SE', NULL, 'Epson\r'),
(3, 3, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 : ) Leptop i3 : 1 buah', '6880000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Lenovo\r'),
(4, 4, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS reguler 2023 : Tahap 2 : laptop acer i3: 1 buah', '9000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Lenovo\r'),
(5, 5, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Sound System', '\nModel: PAS 8\r\nDaya Output: 200 Watt\r\nChannel: 2 Channel\r\nInput: Mic, AUX, USB, Bluetooth\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS reguler 2023 : Tahap 2 : siplah : saund system : 1 unit', '2951000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Polytron\r'),
(6, 6, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Printer', '\nModel: L3210\r\nTipe: Ink Tank\r\nFungsi: Print, Scan, Copy\r\nResolusi: 5760 x 1440 dpi\r\nKoneksi: USB\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 :siplah :printer epson L 3210: 1 buah', '6880000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Epson\r'),
(7, 7, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 :siplah : leptop acer : 13 : 1 buah', '2600000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Lenovo\r'),
(8, 8, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Lemari', 'Jenis: Lemari Arsip\r\nBahan: Besi Plat\r\nUkuran: 180 x 90 x 40 cm\r\nPintu: 2 Pintu\r\nKunci: Ada\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 :siplah : lemari full plat pintu sleding : 1 buah', '3900000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:07', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, NULL),
(10, 10, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'CCTV', '\nResolusi: 2 MP (1080p)\r\nTipe: Indoor\r\nNight Vision: Ya\r\nPenyimpanan: DVR 1 TB\r\nJumlah Kamera: 4 Unit\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 :siplah : cctv : 1 unit', '18000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Hikvision\r'),
(11, 11, NULL, '2023-12-22', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Proyektor/Infokus', '\nModel: EB-X500\r\nResolusi: XGA (1024x768)\r\nBrightness: 3600 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS kinerja 2023 :siplah : proyektor epson EB -X500 : 2 buah', '0.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.009.SE', NULL, 'Epson\r'),
(12, 12, NULL, '2023-12-22', 'Kendaraan', 'Operasional', 'Pusat', 'Motor', '\nTipe: Beat\r\nTahun: 2021\r\nWarna: Biru\r\nNo Rangka: -\r\nNo Mesin: -\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Motor Honda Beat warna bIru, Tahun 2021 (second)', '6203748.00', 8, '1240749.60', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.KDN.002.OPE', NULL, 'Honda\r'),
(13, 13, NULL, '2023-12-04', 'Peralatan', 'BOS', 'SDJ - Jakarta Utara', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : BOS : Operasional Sekolah : AC 2PK Ruang Manajemen', '7400000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.002.BOS', NULL, 'Panasonic\r'),
(14, 14, NULL, '2023-12-20', 'Peralatan', 'BOS', 'SDJ - Semarang', 'Infokus', '\nModel: EB-X500\r\nResolusi: XGA (1024x768)\r\nBrightness: 3600 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran: Terikat: BOS: Ops Sekjur: Pembelian LCD Proyektor', '8000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.003.BOS', NULL, 'Epson\r'),
(15, 15, NULL, '2023-12-20', 'Peralatan', 'BOS', 'SDJ - Semarang', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran: Terikat: BOS: Ops Sekjur: Pembelian Laptop', '9999999.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.003.BOS', NULL, 'Lenovo\r'),
(16, 16, NULL, '2024-01-29', 'Peralatan', 'Program', 'Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Tidak Terikat : Ops : Pembelian laptop Quality Assurance', '6850000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.004.PRO', NULL, 'Lenovo\r'),
(17, 17, NULL, '2024-02-28', 'Peralatan', 'Program', 'Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Tidak Terikat : Ops : Pembelian laptop Monev Project', '6783000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.004.PRO', NULL, 'Lenovo\r'),
(18, 18, NULL, '2024-03-28', 'Peralatan', 'Operasional', 'Pusat', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : Air Conditioner 1.5 pk (Sharp Inverter)', '4739000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.004.OPE', NULL, 'Panasonic\r'),
(19, 19, NULL, '2024-06-04', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Pintu Alumunium', 'Jenis: Pintu Alumunium\r\nBahan: Alumunium & Kaca\r\nUkuran: 90 x 210 cm\r\nFinishing: Powder Coating\r\nAksesori: Handle & Kunci\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS tahap 1 : 2024 : pintu alumuniun : 1 buah ( sudah pajak )', '2900000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:08', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.005.SE', NULL, NULL),
(20, 20, NULL, '2024-06-04', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS tahap 1 : 2024 : leptop lenovo hitam V14 G3 CBID ( sudah dengan pajak )', '6880000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.005.SE', NULL, 'Lenovo\r'),
(21, 21, NULL, '2024-06-04', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'BOS tahap 1 : 2024 : leptop lenovo hitam V14 G3 CBID ( sudah dengan pajak ) 1 buah', '6880000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.005.SE', NULL, 'Lenovo\r'),
(22, 22, NULL, '2024-06-04', 'Peralatan', 'SE', 'SDJ - Jakarta Selatan', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyelenggaraan Program Bantuan Operasional Sekolah - Operasional: Pembelian 1 Buah Laptop', '12000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.003.SE', NULL, 'Lenovo\r'),
(23, 23, NULL, '2024-08-21', 'Peralatan', 'SE', 'SDJ - Jakarta Selatan', 'Proyektor/Infokus', '\nModel: EB-X500\r\nResolusi: XGA (1024x768)\r\nBrightness: 3600 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Peralatan:Pembelian LCD Proyektor EB X 500', '5699000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.003.SE', NULL, 'Epson\r'),
(24, 24, NULL, '2024-08-28', 'Peralatan', 'Terikat', 'SDJ - Jakarta Timur', 'Web Cam', '\nResolusi: Full HD 1080p\r\nMicrophone: Built-in\r\nKoneksi: USB\r\nMount: Clip Monitor\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : SD Juara Jakarta Timur : Terikat : PT Paragon Technology and Innovation : : Bantuan Bebas Sekolah Juara : Pembelian Webcam ANBK', '2563500.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.002.TER', NULL, 'Logitech\r'),
(25, 25, NULL, '2024-10-30', 'Peralatan', 'SE', 'SDJ - Yogyakarta', 'Proyektor/Infokus', '\nModel: EB-X500\r\nResolusi: XGA (1024x768)\r\nBrightness: 3600 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : BOSNAS : Biaya HPP Sekolah Juara : Projector View Sonic', '6449235.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-Y.PER.002.SE', NULL, 'Epson\r'),
(26, 26, NULL, '2024-11-06', 'Peralatan', 'SE', 'SDJ - Semarang', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran: Terikat: BOS: Pembelian Laptop', '10707600.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.003.SE', NULL, 'Lenovo\r'),
(27, 27, NULL, '2024-11-07', 'Peralatan', 'SE', 'SDJ - Semarang', 'Almari', 'Jenis: Lemari Arsip\r\nBahan: Besi Plat\r\nUkuran: 180 x 90 x 40 cm\r\nPintu: 2 Pintu\r\nKunci: Ada\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran: Terikat: PBOS: Pembelian Almari', '2760000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:08', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.003.SE', NULL, NULL),
(28, 28, NULL, '2024-11-30', 'Peralatan', 'SE', 'SDJ - Surabaya', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP 30 Oktober 2024 : SDJ Surabaya : BOS Kinerja 2024 : laptop setara core i3 ; lenovo : 2 buah', '13760000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.005.SE', NULL, 'Lenovo\r'),
(29, 29, NULL, '2025-01-31', 'Peralatan', 'Operasional', 'Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : Laptop NFE Head', '6599000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.005.OPE', NULL, 'Lenovo\r'),
(30, 30, NULL, '2025-01-31', 'Peralatan', 'Operasional', 'Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : laptop QA', '7379000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.005.OPE', NULL, 'Lenovo\r'),
(31, 31, NULL, '2025-01-31', 'Peralatan', 'Operasional', 'Pusat', 'HP', '\nModel: Galaxy A Series\r\nLayar: 6.5 inch\r\nRAM: 6 GB\r\nStorage: 128 GB\r\nKamera: 48 MP\r\nBaterai: 5000 mAh\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : HP Marketing', '5500000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.005.OPE', NULL, 'Samsung\r'),
(32, 32, NULL, '2025-01-31', 'Peralatan', 'Operasional', 'Pusat', 'HP', '\nModel: Galaxy A Series\r\nLayar: 6.5 inch\r\nRAM: 6 GB\r\nStorage: 128 GB\r\nKamera: 48 MP\r\nBaterai: 5000 mAh\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : Kekurangan HP Marketing', '9492120.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.PER.005.OPE', NULL, 'Samsung\r'),
(33, 33, NULL, '2025-02-24', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Utara', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : BOS : Operasional Sekolah : Laptop Kepala Sekolah', '7000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.006.DAN', NULL, 'Lenovo\r'),
(34, 34, NULL, '2025-02-27', 'Peralatan', 'DP', 'PAC - Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'laptop smd head : Asus VivoBook Corei5 SSD512', '8549050.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'P-P.PER.004.DP', NULL, 'Lenovo\r'),
(35, 35, NULL, '2025-02-27', 'Peralatan', 'DP', 'PAC - Pusat', 'Meja Kursi', 'Jenis: Set Meja dan Kursi\r\nBahan: Kayu & Besi\r\nJumlah: 1 Set (1 Meja + 1 Kursi)\r\nUkuran Meja: 120 x 60 cm\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Pusat : Tidak Terikat : Operasional : : Kursi meja kantor', '4504000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:08', NULL, NULL, NULL, NULL, NULL, NULL, 'P-P.PER.004.DP', NULL, NULL),
(36, 36, NULL, '2025-02-28', 'Peralatan', 'Dana Terikat - RZ', 'SDJ - Jakarta Timur', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP 22 Januari 2025 : SD Juara Jakarta Timur : Terikat : PT Paragon Technology and Innovation : Pengadaan AC', '4500000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.002.DAN', NULL, 'Panasonic\r'),
(37, 37, NULL, '2025-03-04', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Yogyakarta', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : BOS : Operasional Sekolah : Laptop Sekolah', '9350000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-Y.PER.003.DAN', NULL, 'Lenovo\r'),
(38, 38, NULL, '2025-04-25', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Utara', 'Meja Kursi', 'Jenis: Set Meja dan Kursi\r\nBahan: Kayu & Besi\r\nJumlah: 1 Set (1 Meja + 1 Kursi)\r\nUkuran Meja: 120 x 60 cm\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Peralatan : Donatur Meja Kursi second: 80 Meja Kursi Second', '20000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:08', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.006.DAN', NULL, NULL),
(39, 39, NULL, '2025-04-28', 'Peralatan', 'DP', 'PAC - Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Tidak Terikat : Operasional : Laptop Ops Head (ASUS Vivobook Corei7 Gen 13)', '11206310.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'P-P.PER.004.DP', NULL, 'Lenovo\r'),
(40, 40, NULL, '2025-04-28', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Tangerang', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : SD Juara Tangerang : Terikat : DKT : : Operasional & HPP Bulan April : Pembelian AC ruang guru', '4050000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-T.PER.004.DAN', NULL, 'Panasonic\r'),
(41, 41, NULL, '2025-04-28', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Tangerang', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : SD Juara Tangerang : BOS : Penyaluran : SD Juara Tangerang : BOS : Laptop Asus Vivobook 14 A1404VA i5', '12690000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-T.PER.004.DAN', NULL, 'Lenovo\r'),
(42, 42, NULL, '2025-05-27', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Utara', 'Loker', 'Jenis: Loker Besi\r\nJumlah Pintu: 6 Pintu\r\nBahan: Besi\r\nSistem Kunci: Manual\r\nFinishing: Cat Oven\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : DSP : Peralatan : 2 Pcs Loker Siswa', '7100000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:09', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.006.DAN', NULL, NULL),
(43, 43, NULL, '2025-05-27', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Utara', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : DSP : Peralatan : 1 AC dan Tukar AC', '9000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.006.DAN', NULL, 'Panasonic\r'),
(44, 44, NULL, '2025-05-27', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Utara', 'Meja Kursi', 'Jenis: Set Meja dan Kursi\r\nBahan: Kayu & Besi\r\nJumlah: 1 Set (1 Meja + 1 Kursi)\r\nUkuran Meja: 120 x 60 cm\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : DSP : 2 Pcs Meja Kursi Guru', '5500000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 07:02:09', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.006.DAN', NULL, NULL),
(45, 45, NULL, '2025-07-31', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Medan', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP Penyaluran : SD Juara Medan : Terikat : DSP : : Pengadaan 4 Buah AC : AC 2 PK Untuk Kelas 1- 4', '16000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-M.PER.002.DAN', NULL, 'Panasonic\r'),
(46, 46, NULL, '2025-09-30', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Selatan', 'AC', '\nKapasitas: 2 PK\r\nTipe: Split Wall\r\nFreon: R32\r\nDaya Listrik: 1600 Watt\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP Coa 14 Agustus 2025 : SDJ Jaksel : Penyaluran : Terikat : BOS Juni 2025 : Operasional sekolah : AC Panasonic', '4600000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.003.DAN', NULL, 'Panasonic\r'),
(47, 47, NULL, '2025-09-30', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Jakarta Selatan', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP COA 14 Agustus 2025 : SDJ Jaksel : Penyaluran : Terikat : BOS April 2025: Operasional sekolah : Laptop', '6459100.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-J.PER.003.DAN', NULL, 'Lenovo\r'),
(48, 48, NULL, '2025-10-30', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Yogyakarta', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : Terikat : BOSN : Biaya HPP Sekolah Juara : Laptop HP', '7388600.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-Y.PER.003.DAN', NULL, 'Lenovo\r'),
(49, 49, NULL, '2025-11-25', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Tangerang', 'Proyektor/Infokus', '\nModel: EB-X500\r\nResolusi: XGA (1024x768)\r\nBrightness: 3600 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran : SD Juara Tangerang : BOS : Pengadaan Proyektor', '6000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-T.PER.004.DAN', NULL, 'Epson\r'),
(50, 50, NULL, '2025-11-28', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Semarang', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Penyaluran: Terikat: BOS: Pembelian Laptop', '10161000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-S.PER.002.DAN', NULL, 'Lenovo\r'),
(51, 51, NULL, '2025-11-30', 'Peralatan', 'Dana Terikat - SE', 'SDJ - Batam', 'Proyektor LCD', '\nResolusi: XGA (1024x768)\r\nBrightness: 3300 Lumens\r\nPort: HDMI, VGA\r\nLamp Life: Hingga 10.000 jam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'AJP 25 Oktober 2025 : SDJ Batam : sekolah mandiri 2025 2026: Bantuan Operasional Sekolah penyaluran Transaksi Oktober 2025: pembelian proyector LCD', '5000000.00', 5, '0.00', 'garis_lurus', '2025-12-16 02:53:43', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'S-B.PER.002.DAN', NULL, 'Epson\r'),
(52, 1, NULL, '2023-11-30', 'Elektronik', 'APBN', 'Kantor Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', '2025-12-18', NULL, 'di alokasikan', NULL, NULL, 'Pembelian Laptop', '6850000.00', 5, '685000.00', 'garis_lurus', '2025-12-17 02:44:29', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.ELK.002.ABN', NULL, 'Lenovo\r'),
(54, 52, NULL, '2025-12-18', 'Elektronik', 'BOS', 'Kantor Pusat', 'Laptop', '\nModel: V14 G3\r\nProcessor: Intel Core i3 Gen 11\r\nRAM: 8 GB DDR4\r\nStorage: SSD 256 GB\r\nLayar: 14 inch Full HD\r\nOS: Windows 11 Pro\r\nWarna: Hitam\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Laptop thinkpad 1', '5000000.00', 5, '500000.00', 'garis_lurus', '2025-12-18 03:45:06', '2026-01-30 08:21:52', NULL, NULL, NULL, NULL, NULL, NULL, 'PST.ELK.002.BOS', NULL, 'Lenovo\r'),
(55, 0, NULL, '2025-12-19', 'furnitur', 'Operasional', 'PAC - Pusat', 'Lemari', 'Jenis: Lemari Arsip\r\nBahan: Besi Plat\r\nUkuran: 180 x 90 x 40 cm\r\nPintu: 2 Pintu\r\nKunci: Ada\r\nKondisi: Baik', 'aktif', NULL, NULL, NULL, NULL, NULL, 'Lemari buku', '3000000.00', 5, '0.00', 'garis_lurus', '2025-12-18 04:01:00', '2026-01-30 07:02:09', NULL, NULL, NULL, NULL, NULL, NULL, 'P-P.FUR.002.OPE', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `jenis_asset`
--

CREATE TABLE `jenis_asset` (
  `id_jenis` int NOT NULL,
  `nama_jenis` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `keterangan` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `jenis_asset`
--

INSERT INTO `jenis_asset` (`id_jenis`, `nama_jenis`, `keterangan`, `created_at`, `updated_at`) VALUES
(1, 'Laptop', 'Komputer portable untuk kerja', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(2, 'Printer', 'Alat cetak dokumen', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(3, 'Meja Kantor', 'Furniture meja kerja', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(4, 'Kursi Kantor', 'Furniture kursi kerja', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(5, 'AC', 'Pendingin ruangan', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(6, 'Proyektor', 'Alat presentasi', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(7, 'Monitor', 'Layar komputer', '2025-12-19 09:11:06', '2025-12-19 09:11:06'),
(8, 'Mouse & Keyboard', 'Perangkat input komputer', '2025-12-19 09:11:06', '2025-12-19 09:11:06');

-- --------------------------------------------------------

--
-- Table structure for table `jenis_barang`
--

CREATE TABLE `jenis_barang` (
  `id` int NOT NULL,
  `nama_jenis` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `kategori_id` int DEFAULT NULL,
  `deskripsi` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `jenis_barang`
--

INSERT INTO `jenis_barang` (`id`, `nama_jenis`, `kategori_id`, `deskripsi`, `created_at`) VALUES
(1, 'Laptop', 1, 'Komputer jinjing', '2025-12-17 02:43:13'),
(2, 'Printer', 1, 'Alat cetak', '2025-12-17 02:43:13'),
(3, 'Sound System', 1, 'Audio', '2025-12-17 02:43:13'),
(8, 'Motor', 2, 'Sepeda motor', '2025-12-17 02:43:13'),
(9, 'AC', 4, 'Air Conditioner', '2025-12-17 02:43:13');

-- --------------------------------------------------------

--
-- Table structure for table `jenis_pembayaran`
--

CREATE TABLE `jenis_pembayaran` (
  `id` int NOT NULL,
  `kode_pembayaran` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_pembayaran` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_unicode_ci,
  `is_bulanan` tinyint(1) DEFAULT '1' COMMENT 'TRUE for monthly, FALSE for one-time',
  `status` enum('AKTIF','NONAKTIF') COLLATE utf8mb4_unicode_ci DEFAULT 'AKTIF',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `jenis_pembayaran`
--

INSERT INTO `jenis_pembayaran` (`id`, `kode_pembayaran`, `nama_pembayaran`, `deskripsi`, `is_bulanan`, `status`, `created_at`, `updated_at`) VALUES
(1, 'SPP', 'Sumbangan Pembinaan Pendidikan', 'Pembayaran bulanan untuk biaya operasional sekolah', 1, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(2, 'DKT', 'Dana Komite dan Tahunan', 'Pembayaran tahunan untuk dana komite sekolah', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(3, 'DSP', 'Dana Sumbangan Pendidikan', 'Sumbangan pendidikan dari orang tua siswa', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(4, 'SERAGAM', 'Seragam Sekolah', 'Pembayaran seragam sekolah', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(5, 'PENDAFTARAN', 'Biaya Pendaftaran', 'Biaya pendaftaran siswa baru', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(6, 'UANG_BUKU', 'Uang Buku', 'Pembelian buku pelajaran', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(7, 'KEGIATAN', 'Uang Kegiatan', 'Biaya kegiatan ekstrakurikuler dan lainnya', 0, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59');

-- --------------------------------------------------------

--
-- Table structure for table `kantor`
--

CREATE TABLE `kantor` (
  `id` int NOT NULL,
  `kode_kantor` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_kantor` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci,
  `telepon` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kantor`
--

INSERT INTO `kantor` (`id`, `kode_kantor`, `nama_kantor`, `alamat`, `telepon`, `status`, `created_at`, `updated_at`) VALUES
(1, 'PUSAT', 'Pusat', 'Jakarta Pusat', NULL, 'active', '2025-12-17 02:43:04', '2026-01-31 15:41:49'),
(2, 'SDJ-MDN', 'SDJ Medan', 'Medan', NULL, 'active', '2025-12-17 02:43:04', '2025-12-17 02:43:04'),
(3, 'SDJ-SBY', 'SDJ Surabaya', 'Surabaya', NULL, 'active', '2025-12-17 02:43:04', '2025-12-17 02:43:04'),
(4, 'SDJ-JKU', 'SDJ Jakarta Utara', 'Jakarta Utara', NULL, 'active', '2025-12-17 02:43:04', '2025-12-17 02:43:04');

-- --------------------------------------------------------

--
-- Table structure for table `kategori`
--

CREATE TABLE `kategori` (
  `id` int NOT NULL,
  `nama_kategori` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `kategori`
--

INSERT INTO `kategori` (`id`, `nama_kategori`, `deskripsi`) VALUES
(1, 'Peralatan', 'Peralatan kantor dan operasional'),
(2, 'Kendaraan', 'Kendaraan operasional'),
(3, 'Furniture', 'Mebel dan perlengkapan kantor'),
(4, 'Elektronik', 'Peralatan elektronik');

-- --------------------------------------------------------

--
-- Table structure for table `kategori_pembayaran`
--

CREATE TABLE `kategori_pembayaran` (
  `id` int NOT NULL,
  `kode` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `tampil_default` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `kategori_pembayaran`
--

INSERT INTO `kategori_pembayaran` (`id`, `kode`, `nama`, `tampil_default`) VALUES
(1, 'SPP', 'SPP', 1),
(2, 'DKT', 'DKT', 1),
(3, 'DSP', 'DSP', 1),
(4, 'SERAGAM', 'Seragam', 1),
(5, 'BIAYA_KHUSUS', 'Biaya Khusus', 0);

-- --------------------------------------------------------

--
-- Table structure for table `kategori_siswa`
--

CREATE TABLE `kategori_siswa` (
  `id` int NOT NULL,
  `kode_kategori` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_kategori` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kategori_siswa`
--

INSERT INTO `kategori_siswa` (`id`, `kode_kategori`, `nama_kategori`, `deskripsi`, `created_at`, `updated_at`) VALUES
(1, 'SEMUA', 'Semua Siswa', 'Gabungan siswa B&U dan Umum', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(2, 'BU', 'Siswa B&U', 'Siswa dengan beasiswa Bimbingan dan Usaha', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(3, 'UMUM', 'Siswa Umum', 'Siswa reguler non-beasiswa', '2026-01-28 03:44:59', '2026-01-28 03:44:59');

-- --------------------------------------------------------

--
-- Table structure for table `kepatuhan_pembayaran`
--

CREATE TABLE `kepatuhan_pembayaran` (
  `id` int NOT NULL,
  `sekolah_id` int DEFAULT NULL,
  `ta` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Unit / Sekolah (SDJ BATAM, dll)',
  `period` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tahun ajaran (2022-2023)',
  `category` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'SPP, DKT, DSP, SERAGAM, BIAYA KHUSUS',
  `month` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TOTAL' COMMENT 'TOTAL / JANUARI / FEBRUARI / dst',
  `target` decimal(15,2) NOT NULL DEFAULT '0.00',
  `capaian` decimal(15,2) NOT NULL DEFAULT '0.00',
  `piutang` decimal(15,2) NOT NULL DEFAULT '0.00',
  `persen` decimal(5,2) NOT NULL DEFAULT '0.00',
  `kategori` enum('EXCELLENT','GOOD','AVERAGE','POOR') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'POOR',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kepatuhan_pembayaran`
--

INSERT INTO `kepatuhan_pembayaran` (`id`, `sekolah_id`, `ta`, `period`, `category`, `month`, `target`, `capaian`, `piutang`, `persen`, `kategori`, `created_at`, `updated_at`) VALUES
(14, 1, 'SDJ BATAM', '2023-2024', 'SPP', 'TOTAL', '237175000.00', '237425000.00', '-250000.00', '100.00', 'EXCELLENT', '2026-01-29 08:28:54', '2026-02-03 04:50:20'),
(15, 2, 'SDJ CILEGON', '2023-2024', 'SPP', 'TOTAL', '285750000.00', '285800000.00', '-50000.00', '100.00', 'EXCELLENT', '2026-01-29 08:28:54', '2026-02-03 04:50:20'),
(16, 3, 'SDJ JAKBAR', '2023-2024', 'SPP', 'TOTAL', '289800000.00', '276550000.00', '13250000.00', '95.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(17, 4, 'SDJ JAKSEL', '2023-2024', 'SPP', 'TOTAL', '247725000.00', '240680000.00', '7045000.00', '97.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(18, 5, 'SDJ JAKTIM', '2023-2024', 'SPP', 'TOTAL', '276360000.00', '276300303.00', '59697.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(19, 6, 'SDJ JAKUT', '2023-2024', 'SPP', 'TOTAL', '185500000.00', '182025000.00', '3475000.00', '98.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(20, 7, 'SDJ JAYAPURA', '2023-2024', 'SPP', 'TOTAL', '134400000.00', '131175000.00', '3225000.00', '98.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(21, 8, 'SDJ MEDAN', '2023-2024', 'SPP', 'TOTAL', '366278000.00', '366705000.00', '-427000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(22, 9, 'SDJ SEMARANG', '2023-2024', 'SPP', 'TOTAL', '142800000.00', '143400000.00', '-600000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(23, 10, 'SDJ SURABAYA', '2023-2024', 'SPP', 'TOTAL', '297000000.00', '278545500.00', '18454500.00', '94.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(24, 11, 'SDJ TANGERANG', '2023-2024', 'SPP', 'TOTAL', '253950000.00', '251620500.00', '2329500.00', '99.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(25, 12, 'SDJ YOGYAKARTA', '2023-2024', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(26, 13, 'TKIT TANGERANG', '2023-2024', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(29, 1, 'SDJ BATAM', '2023-2024', 'DKT', 'TOTAL', '116850000.00', '105600000.00', '11250000.00', '90.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(30, 2, 'SDJ CILEGON', '2023-2024', 'DKT', 'TOTAL', '112050000.00', '112050000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(31, 3, 'SDJ JAKBAR', '2023-2024', 'DKT', 'TOTAL', '103300000.00', '79450000.00', '23850000.00', '77.00', 'AVERAGE', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(32, 4, 'SDJ JAKSEL', '2023-2024', 'DKT', 'TOTAL', '87870000.00', '84315000.00', '3555000.00', '96.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(33, 5, 'SDJ JAKTIM', '2023-2024', 'DKT', 'TOTAL', '185500000.00', '190007002.00', '-4507002.00', '102.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(34, 6, 'SDJ JAKUT', '2023-2024', 'DKT', 'TOTAL', '123800000.00', '120175000.00', '3625000.00', '97.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(35, 7, 'SDJ JAYAPURA', '2023-2024', 'DKT', 'TOTAL', '60600000.00', '53500000.00', '7100000.00', '88.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(36, 8, 'SDJ MEDAN', '2023-2024', 'DKT', 'TOTAL', '150293500.00', '150290500.00', '3000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(37, 9, 'SDJ SEMARANG', '2023-2024', 'DKT', 'TOTAL', '60575000.00', '60575000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(38, 10, 'SDJ SURABAYA', '2023-2024', 'DKT', 'TOTAL', '136400000.00', '132205000.00', '4195000.00', '97.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(39, 11, 'SDJ TANGERANG', '2023-2024', 'DKT', 'TOTAL', '149175000.00', '145738000.00', '3437000.00', '98.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(40, 12, 'SDJ YOGYAKARTA', '2023-2024', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(41, 13, 'TKIT TANGERANG', '2023-2024', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(42, 1, 'SDJ BATAM', '2022-2023', 'SPP', 'TOTAL', '158600000.00', '158600000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(43, 2, 'SDJ CILEGON', '2022-2023', 'SPP', 'TOTAL', '209400000.00', '209764000.00', '-364000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(44, 3, 'SDJ JAKBAR', '2022-2023', 'SPP', 'TOTAL', '249360000.00', '245510000.00', '3850000.00', '98.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(45, 4, 'SDJ JAKSEL', '2022-2023', 'SPP', 'TOTAL', '229580000.00', '225542000.00', '4038000.00', '98.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(46, 5, 'SDJ JAKTIM', '2022-2023', 'SPP', 'TOTAL', '206208000.00', '207377522.00', '-1169522.00', '101.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(47, 6, 'SDJ JAKUT', '2022-2023', 'SPP', 'TOTAL', '129600000.00', '129960000.00', '-360000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(48, 7, 'SDJ JAYAPURA', '2022-2023', 'SPP', 'TOTAL', '99000000.00', '94100000.00', '4900000.00', '95.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(49, 8, 'SDJ MEDAN', '2022-2023', 'SPP', 'TOTAL', '316120000.00', '316444500.00', '-324500.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(50, 9, 'SDJ SEMARANG', '2022-2023', 'SPP', 'TOTAL', '107400000.00', '107510000.00', '-110000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(51, 10, 'SDJ SURABAYA', '2022-2023', 'SPP', 'TOTAL', '199950000.00', '194227000.00', '5723000.00', '97.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(52, 11, 'SDJ TANGERANG', '2022-2023', 'SPP', 'TOTAL', '197550000.00', '197602000.00', '-52000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(53, 12, 'SDJ YOGYAKARTA', '2022-2023', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(54, 13, 'TKIT TANGERANG', '2022-2023', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(55, 1, 'SDJ BATAM', '2022-2023', 'DKT', 'TOTAL', '81200000.00', '76350000.00', '4850000.00', '94.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(56, 2, 'SDJ CILEGON', '2022-2023', 'DKT', 'TOTAL', '82900000.00', '82900000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(57, 3, 'SDJ JAKBAR', '2022-2023', 'DKT', 'TOTAL', '88200000.00', '76900000.00', '11300000.00', '87.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(58, 4, 'SDJ JAKSEL', '2022-2023', 'DKT', 'TOTAL', '80300000.00', '78793000.00', '1507000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(59, 5, 'SDJ JAKTIM', '2022-2023', 'DKT', 'TOTAL', '143600000.00', '139238700.00', '4361300.00', '97.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(60, 6, 'SDJ JAKUT', '2022-2023', 'DKT', 'TOTAL', '92800000.00', '91999000.00', '801000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(61, 7, 'SDJ JAYAPURA', '2022-2023', 'DKT', 'TOTAL', '45225000.00', '40225000.00', '5000000.00', '89.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(62, 8, 'SDJ MEDAN', '2022-2023', 'DKT', 'TOTAL', '125348700.00', '125348700.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(63, 9, 'SDJ SEMARANG', '2022-2023', 'DKT', 'TOTAL', '41615000.00', '42015000.00', '-400000.00', '101.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(64, 10, 'SDJ SURABAYA', '2022-2023', 'DKT', 'TOTAL', '97000000.00', '95475000.00', '1525000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(65, 11, 'SDJ TANGERANG', '2022-2023', 'DKT', 'TOTAL', '82250000.00', '80796000.00', '1454000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(66, 12, 'SDJ YOGYAKARTA', '2022-2023', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(67, 13, 'TKIT TANGERANG', '2022-2023', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(68, 1, 'SDJ BATAM', '2022-2023', 'DSP', 'TOTAL', '107000000.00', '95899500.00', '11100500.00', '90.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(69, 2, 'SDJ CILEGON', '2022-2023', 'DSP', 'TOTAL', '57000000.00', '57000000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(70, 3, 'SDJ JAKBAR', '2022-2023', 'DSP', 'TOTAL', '64375000.00', '53690000.00', '10685000.00', '83.00', 'AVERAGE', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(71, 4, 'SDJ JAKSEL', '2022-2023', 'DSP', 'TOTAL', '61500000.00', '61048000.00', '452000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(72, 5, 'SDJ JAKTIM', '2022-2023', 'DSP', 'TOTAL', '102000000.00', '102088000.00', '-88000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(73, 6, 'SDJ JAKUT', '2022-2023', 'DSP', 'TOTAL', '73250000.00', '72695000.00', '555000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(74, 7, 'SDJ JAYAPURA', '2022-2023', 'DSP', 'TOTAL', '25583333.00', '11950000.00', '13633333.00', '47.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(75, 8, 'SDJ MEDAN', '2022-2023', 'DSP', 'TOTAL', '79750000.00', '77350000.00', '2400000.00', '97.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(76, 9, 'SDJ SEMARANG', '2022-2023', 'DSP', 'TOTAL', '69800000.00', '69800000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(77, 10, 'SDJ SURABAYA', '2022-2023', 'DSP', 'TOTAL', '70650000.00', '70641000.00', '9000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(78, 11, 'SDJ TANGERANG', '2022-2023', 'DSP', 'TOTAL', '60500000.00', '55150000.00', '5350000.00', '91.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(79, 12, 'SDJ YOGYAKARTA', '2022-2023', 'DSP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(80, 13, 'TKIT TANGERANG', '2022-2023', 'DSP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(81, 1, 'SDJ BATAM', '2022-2023', 'SERAGAM', 'TOTAL', '28800000.00', '28800000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(82, 2, 'SDJ CILEGON', '2022-2023', 'SERAGAM', 'TOTAL', '14000000.00', '14000000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(83, 3, 'SDJ JAKBAR', '2022-2023', 'SERAGAM', 'TOTAL', '15200000.00', '15200000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(84, 4, 'SDJ JAKSEL', '2022-2023', 'SERAGAM', 'TOTAL', '15756000.00', '15756000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(85, 5, 'SDJ JAKTIM', '2022-2023', 'SERAGAM', 'TOTAL', '24165000.00', '23450000.00', '715000.00', '97.00', 'GOOD', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(86, 6, 'SDJ JAKUT', '2022-2023', 'SERAGAM', 'TOTAL', '16700000.00', '16700000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(87, 7, 'SDJ JAYAPURA', '2022-2023', 'SERAGAM', 'TOTAL', '6500000.00', '5000000.00', '1500000.00', '77.00', 'AVERAGE', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(88, 8, 'SDJ MEDAN', '2022-2023', 'SERAGAM', 'TOTAL', '26845000.00', '26845000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(89, 9, 'SDJ SEMARANG', '2022-2023', 'SERAGAM', 'TOTAL', '17740000.00', '17740000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(90, 10, 'SDJ SURABAYA', '2022-2023', 'SERAGAM', 'TOTAL', '19582000.00', '19580000.00', '2000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(91, 11, 'SDJ TANGERANG', '2022-2023', 'SERAGAM', 'TOTAL', '13300000.00', '13300000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(92, 12, 'SDJ YOGYAKARTA', '2022-2023', 'SERAGAM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(93, 13, 'TKIT TANGERANG', '2022-2023', 'SERAGAM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(94, 1, 'SDJ BATAM', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(95, 2, 'SDJ CILEGON', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(96, 3, 'SDJ JAKBAR', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(97, 4, 'SDJ JAKSEL', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(98, 5, 'SDJ JAKTIM', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(99, 6, 'SDJ JAKUT', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(100, 7, 'SDJ JAYAPURA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(101, 8, 'SDJ MEDAN', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(102, 9, 'SDJ SEMARANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(103, 10, 'SDJ SURABAYA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(104, 11, 'SDJ TANGERANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(105, 12, 'SDJ YOGYAKARTA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(106, 13, 'TKIT TANGERANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(107, 1, 'SDJ BATAM', '2024-2025', 'UMUM', 'TOTAL', '129350000.00', '104325000.00', '25025000.00', '80.65', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(108, 2, 'SDJ CILEGON', '2024-2025', 'UMUM', 'TOTAL', '130150000.00', '130150000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(109, 3, 'SDJ JAKBAR', '2024-2025', 'UMUM', 'TOTAL', '124950000.00', '90377000.00', '34573000.00', '72.33', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(110, 4, 'SDJ JAKSEL', '2024-2025', 'UMUM', 'TOTAL', '94000000.00', '87985000.00', '6015000.00', '93.60', 'AVERAGE', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(111, 5, 'SDJ JAKTIM', '2024-2025', 'UMUM', 'TOTAL', '222500000.00', '224401000.00', '0.00', '100.85', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(112, 6, 'SDJ JAKUT', '2024-2025', 'UMUM', 'TOTAL', '163050000.00', '160280000.00', '2770000.00', '98.30', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(113, 7, 'SDJ JAYAPURA', '2024-2025', 'UMUM', 'TOTAL', '75850000.00', '61000000.00', '14850000.00', '80.42', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(114, 8, 'SDJ MEDAN', '2024-2025', 'UMUM', 'TOTAL', '193650000.00', '192627000.00', '1023000.00', '99.47', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(115, 9, 'SDJ SEMARANG', '2024-2025', 'UMUM', 'TOTAL', '111450000.00', '111450000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(116, 10, 'SDJ SURABAYA', '2024-2025', 'UMUM', 'TOTAL', '150620000.00', '142942000.00', '7678000.00', '94.90', 'AVERAGE', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(117, 11, 'SDJ TANGERANG', '2024-2025', 'UMUM', 'TOTAL', '197100000.00', '191979000.00', '5121000.00', '97.40', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(118, 12, 'SDJ YOGYAKARTA', '2024-2025', 'UMUM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(119, 13, 'TKIT TANGERANG', '2024-2025', 'UMUM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(145, NULL, 'TEST', '2024', 'SPP', 'TOTAL', '1000.00', '900.00', '0.00', '0.00', 'POOR', '2026-02-03 09:38:56', '2026-02-03 09:38:56'),
(146, NULL, 'SDJ BATAM', '2024-2025', 'DSP', 'TOTAL', '59860000.00', '44360000.00', '15500000.00', '74.11', 'AVERAGE', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(147, NULL, 'SDJ CILEGON', '2024-2025', 'DSP', 'TOTAL', '75850000.00', '76000000.00', '-150000.00', '100.20', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(148, NULL, 'SDJ JAKBAR', '2024-2025', 'DSP', 'TOTAL', '62500000.00', '36175000.00', '26325000.00', '57.88', 'POOR', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(149, NULL, 'SDJ JAKSEL', '2024-2025', 'DSP', 'TOTAL', '17680000.00', '15600500.00', '2079500.00', '88.24', 'GOOD', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(150, NULL, 'SDJ JAKTIM', '2024-2025', 'DSP', 'TOTAL', '153510000.00', '153756000.00', '-246000.00', '100.16', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(151, NULL, 'SDJ JAKUT', '2024-2025', 'DSP', 'TOTAL', '158875000.00', '158900000.00', '-25000.00', '100.02', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(152, NULL, 'SDJ JAYAPURA', '2024-2025', 'DSP', 'TOTAL', '81700000.00', '64175000.00', '17525000.00', '78.55', 'AVERAGE', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(153, NULL, 'SDJ MEDAN', '2024-2025', 'DSP', 'TOTAL', '119100000.00', '119100000.00', '0.00', '100.00', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(154, NULL, 'SDJ SEMARANG', '2024-2025', 'DSP', 'TOTAL', '112950000.00', '112950000.00', '0.00', '100.00', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(155, NULL, 'SDJ SURABAYA', '2024-2025', 'DSP', 'TOTAL', '40700000.00', '40696000.00', '4000.00', '99.99', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(156, NULL, 'SDJ TANGERANG', '2024-2025', 'DSP', 'TOTAL', '121077500.00', '116808000.00', '4269500.00', '96.47', 'EXCELLENT', '2026-02-04 02:53:51', '2026-02-04 02:53:51'),
(157, NULL, 'SDJ BATAM', '2024-2025', 'DKT', 'TOTAL', '129350000.00', '104325000.00', '25025000.00', '80.65', 'AVERAGE', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(158, NULL, 'SDJ CILEGON', '2024-2025', 'DKT', 'TOTAL', '130150000.00', '130150000.00', '0.00', '100.00', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(159, NULL, 'SDJ JAKBAR', '2024-2025', 'DKT', 'TOTAL', '124950000.00', '90377000.00', '34573000.00', '72.33', 'AVERAGE', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(160, NULL, 'SDJ JAKSEL', '2024-2025', 'DKT', 'TOTAL', '94000000.00', '87985000.00', '6015000.00', '93.60', 'GOOD', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(161, NULL, 'SDJ JAKTIM', '2024-2025', 'DKT', 'TOTAL', '222500000.00', '224401000.00', '-1901000.00', '100.85', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(162, NULL, 'SDJ JAKUT', '2024-2025', 'DKT', 'TOTAL', '163050000.00', '160280000.00', '2770000.00', '98.30', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(163, NULL, 'SDJ JAYAPURA', '2024-2025', 'DKT', 'TOTAL', '75850000.00', '61000000.00', '14850000.00', '80.42', 'AVERAGE', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(164, NULL, 'SDJ MEDAN', '2024-2025', 'DKT', 'TOTAL', '193650000.00', '192627000.00', '1023000.00', '99.47', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(165, NULL, 'SDJ SEMARANG', '2024-2025', 'DKT', 'TOTAL', '111450000.00', '111450000.00', '0.00', '100.00', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(166, NULL, 'SDJ SURABAYA', '2024-2025', 'DKT', 'TOTAL', '150620000.00', '142942000.00', '7678000.00', '94.90', 'GOOD', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(167, NULL, 'SDJ TANGERANG', '2024-2025', 'DKT', 'TOTAL', '197100000.00', '191979000.00', '5121000.00', '97.40', 'EXCELLENT', '2026-02-04 02:54:48', '2026-02-04 02:54:48'),
(168, NULL, 'SDJ JAKBAR', '2024-2025', 'SERAGAM', 'TOTAL', '0.00', '150000.00', '-150000.00', '0.00', 'POOR', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(169, NULL, 'SDJ JAKSEL', '2024-2025', 'SERAGAM', 'TOTAL', '2400000.00', '4864000.00', '-2464000.00', '202.67', 'EXCELLENT', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(170, NULL, 'SDJ JAKUT', '2024-2025', 'SERAGAM', 'TOTAL', '0.00', '3525000.00', '-3525000.00', '0.00', 'POOR', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(171, NULL, 'SDJ MEDAN', '2024-2025', 'SERAGAM', 'TOTAL', '165000.00', '355000.00', '-190000.00', '215.15', 'EXCELLENT', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(172, NULL, 'SDJ SEMARANG', '2024-2025', 'SERAGAM', 'TOTAL', '0.00', '3200000.00', '-3200000.00', '0.00', 'POOR', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(173, NULL, 'SDJ SURABAYA', '2024-2025', 'SERAGAM', 'TOTAL', '4064000.00', '6812000.00', '-2748000.00', '167.62', 'EXCELLENT', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(174, NULL, 'SDJ TANGERANG', '2024-2025', 'SERAGAM', 'TOTAL', '0.00', '4269000.00', '-4269000.00', '0.00', 'POOR', '2026-02-04 02:57:47', '2026-02-04 02:57:47'),
(175, NULL, 'SDJ BATAM', '2024-2025', 'SPP', 'TOTAL', '267175000.00', '263012500.00', '4162500.00', '98.44', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(176, NULL, 'SDJ CILEGON', '2024-2025', 'SPP', 'TOTAL', '342750000.00', '343425000.00', '-675000.00', '100.20', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(177, NULL, 'SDJ JAKBAR', '2024-2025', 'SPP', 'TOTAL', '349860000.00', '323005000.00', '26855000.00', '92.32', 'GOOD', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(178, NULL, 'SDJ JAKSEL', '2024-2025', 'SPP', 'TOTAL', '267450000.00', '249194000.00', '18256000.00', '93.17', 'GOOD', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(179, NULL, 'SDJ JAKTIM', '2024-2025', 'SPP', 'TOTAL', '339385000.00', '341166000.00', '-1781000.00', '100.52', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(180, NULL, 'SDJ JAKUT', '2024-2025', 'SPP', 'TOTAL', '250800000.00', '247585001.00', '3214999.00', '98.72', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(181, NULL, 'SDJ JAYAPURA', '2024-2025', 'SPP', 'TOTAL', '185600000.00', '180150000.00', '5450000.00', '97.06', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(182, NULL, 'SDJ MEDAN', '2024-2025', 'SPP', 'TOTAL', '461290000.00', '461290500.00', '-500.00', '100.00', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(183, NULL, 'SDJ SEMARANG', '2024-2025', 'SPP', 'TOTAL', '93750000.00', '93825000.00', '-75000.00', '100.08', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(184, NULL, 'SDJ SURABAYA', '2024-2025', 'SPP', 'TOTAL', '331800000.00', '314849500.00', '16950500.00', '94.89', 'GOOD', '2026-02-04 02:59:38', '2026-02-04 02:59:38'),
(185, NULL, 'SDJ TANGERANG', '2024-2025', 'SPP', 'TOTAL', '340700000.00', '340612500.00', '87500.00', '99.97', 'EXCELLENT', '2026-02-04 02:59:38', '2026-02-04 02:59:38');

--
-- Triggers `kepatuhan_pembayaran`
--
DELIMITER $$
CREATE TRIGGER `trg_no_total_category_insert` BEFORE INSERT ON `kepatuhan_pembayaran` FOR EACH ROW BEGIN
    IF UPPER(TRIM(NEW.category)) NOT IN ('DSP','DKT','SPP','SERAGAM') THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Kategori tidak valid (hanya DSP, DKT, SPP, SERAGAM)';
    END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `trg_no_total_category_update` BEFORE UPDATE ON `kepatuhan_pembayaran` FOR EACH ROW BEGIN
    IF UPPER(TRIM(NEW.category)) NOT IN ('DSP','DKT','SPP','SERAGAM') THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Kategori tidak valid (hanya DSP, DKT, SPP, SERAGAM)';
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `kepatuhan_pembayaran_backup`
--

CREATE TABLE `kepatuhan_pembayaran_backup` (
  `id` int NOT NULL DEFAULT '0',
  `sekolah_id` int DEFAULT NULL,
  `ta` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Unit / Sekolah (SDJ BATAM, dll)',
  `period` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tahun ajaran (2022-2023)',
  `category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'SPP, DKT, DSP, SERAGAM, BIAYA KHUSUS',
  `month` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TOTAL' COMMENT 'TOTAL / JANUARI / FEBRUARI / dst',
  `target` decimal(15,2) NOT NULL DEFAULT '0.00',
  `capaian` decimal(15,2) NOT NULL DEFAULT '0.00',
  `piutang` decimal(15,2) NOT NULL DEFAULT '0.00',
  `persen` decimal(5,2) NOT NULL DEFAULT '0.00',
  `kategori` enum('EXCELLENT','GOOD','AVERAGE','POOR') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'POOR',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `kepatuhan_pembayaran_backup`
--

INSERT INTO `kepatuhan_pembayaran_backup` (`id`, `sekolah_id`, `ta`, `period`, `category`, `month`, `target`, `capaian`, `piutang`, `persen`, `kategori`, `created_at`, `updated_at`) VALUES
(1, 1, 'SDJ BATAM', '2022-2023', 'TOTAL', 'TOTAL', '375600000.00', '359649500.00', '15950500.00', '96.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(2, 2, 'SDJ CILEGON', '2022-2023', 'TOTAL', 'TOTAL', '363300000.00', '363664000.00', '-364000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(3, 3, 'SDJ JAKBAR', '2022-2023', 'TOTAL', 'TOTAL', '417135000.00', '391300000.00', '25835000.00', '94.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(4, 4, 'SDJ JAKSEL', '2022-2023', 'TOTAL', 'TOTAL', '387136000.00', '381139000.00', '5997000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(5, 5, 'SDJ JAKTIM', '2022-2023', 'TOTAL', 'TOTAL', '475973000.00', '472154222.00', '3818778.00', '99.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(6, 6, 'SDJ JAKUT', '2022-2023', 'TOTAL', 'TOTAL', '312350000.00', '311354000.00', '996000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(7, 7, 'SDJ JAYAPURA', '2022-2023', 'TOTAL', 'TOTAL', '176308333.00', '151275000.00', '25033333.00', '86.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(8, 8, 'SDJ MEDAN', '2022-2023', 'TOTAL', 'TOTAL', '548063700.00', '545988200.00', '2075500.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(9, 9, 'SDJ SEMARANG', '2022-2023', 'TOTAL', 'TOTAL', '236555000.00', '237065000.00', '-510000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(10, 10, 'SDJ SURABAYA', '2022-2023', 'TOTAL', 'TOTAL', '387182000.00', '379923000.00', '7259000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(11, 11, 'SDJ TANGERANG', '2022-2023', 'TOTAL', 'TOTAL', '353600000.00', '346848000.00', '6752000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(12, 12, 'SDJ YOGYAKARTA', '2022-2023', 'TOTAL', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(13, 13, 'TKIT TANGERANG', '2022-2023', 'TOTAL', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(14, 1, 'SDJ BATAM', '2023-2024', 'SPP', 'TOTAL', '237175000.00', '237425000.00', '-250000.00', '100.00', 'EXCELLENT', '2026-01-29 08:28:54', '2026-02-03 04:50:20'),
(15, 2, 'SDJ CILEGON', '2023-2024', 'SPP', 'TOTAL', '285750000.00', '285800000.00', '-50000.00', '100.00', 'EXCELLENT', '2026-01-29 08:28:54', '2026-02-03 04:50:20'),
(16, 3, 'SDJ JAKBAR', '2023-2024', 'SPP', 'TOTAL', '289800000.00', '276550000.00', '13250000.00', '95.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(17, 4, 'SDJ JAKSEL', '2023-2024', 'SPP', 'TOTAL', '247725000.00', '240680000.00', '7045000.00', '97.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(18, 5, 'SDJ JAKTIM', '2023-2024', 'SPP', 'TOTAL', '276360000.00', '276300303.00', '59697.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(19, 6, 'SDJ JAKUT', '2023-2024', 'SPP', 'TOTAL', '185500000.00', '182025000.00', '3475000.00', '98.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(20, 7, 'SDJ JAYAPURA', '2023-2024', 'SPP', 'TOTAL', '134400000.00', '131175000.00', '3225000.00', '98.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(21, 8, 'SDJ MEDAN', '2023-2024', 'SPP', 'TOTAL', '366278000.00', '366705000.00', '-427000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(22, 9, 'SDJ SEMARANG', '2023-2024', 'SPP', 'TOTAL', '142800000.00', '143400000.00', '-600000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(23, 10, 'SDJ SURABAYA', '2023-2024', 'SPP', 'TOTAL', '297000000.00', '278545500.00', '18454500.00', '94.00', 'GOOD', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(24, 11, 'SDJ TANGERANG', '2023-2024', 'SPP', 'TOTAL', '253950000.00', '251620500.00', '2329500.00', '99.00', 'EXCELLENT', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(25, 12, 'SDJ YOGYAKARTA', '2023-2024', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(26, 13, 'TKIT TANGERANG', '2023-2024', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:09', '2026-02-03 04:50:20'),
(29, 1, 'SDJ BATAM', '2023-2024', 'DKT', 'TOTAL', '116850000.00', '105600000.00', '11250000.00', '90.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(30, 2, 'SDJ CILEGON', '2023-2024', 'DKT', 'TOTAL', '112050000.00', '112050000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(31, 3, 'SDJ JAKBAR', '2023-2024', 'DKT', 'TOTAL', '103300000.00', '79450000.00', '23850000.00', '77.00', 'AVERAGE', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(32, 4, 'SDJ JAKSEL', '2023-2024', 'DKT', 'TOTAL', '87870000.00', '84315000.00', '3555000.00', '96.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(33, 5, 'SDJ JAKTIM', '2023-2024', 'DKT', 'TOTAL', '185500000.00', '190007002.00', '-4507002.00', '102.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(34, 6, 'SDJ JAKUT', '2023-2024', 'DKT', 'TOTAL', '123800000.00', '120175000.00', '3625000.00', '97.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(35, 7, 'SDJ JAYAPURA', '2023-2024', 'DKT', 'TOTAL', '60600000.00', '53500000.00', '7100000.00', '88.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(36, 8, 'SDJ MEDAN', '2023-2024', 'DKT', 'TOTAL', '150293500.00', '150290500.00', '3000.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(37, 9, 'SDJ SEMARANG', '2023-2024', 'DKT', 'TOTAL', '60575000.00', '60575000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(38, 10, 'SDJ SURABAYA', '2023-2024', 'DKT', 'TOTAL', '136400000.00', '132205000.00', '4195000.00', '97.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(39, 11, 'SDJ TANGERANG', '2023-2024', 'DKT', 'TOTAL', '149175000.00', '145738000.00', '3437000.00', '98.00', 'GOOD', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(40, 12, 'SDJ YOGYAKARTA', '2023-2024', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(41, 13, 'TKIT TANGERANG', '2023-2024', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:30:32', '2026-02-03 04:50:20'),
(42, 1, 'SDJ BATAM', '2022-2023', 'SPP', 'TOTAL', '158600000.00', '158600000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(43, 2, 'SDJ CILEGON', '2022-2023', 'SPP', 'TOTAL', '209400000.00', '209764000.00', '-364000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(44, 3, 'SDJ JAKBAR', '2022-2023', 'SPP', 'TOTAL', '249360000.00', '245510000.00', '3850000.00', '98.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(45, 4, 'SDJ JAKSEL', '2022-2023', 'SPP', 'TOTAL', '229580000.00', '225542000.00', '4038000.00', '98.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(46, 5, 'SDJ JAKTIM', '2022-2023', 'SPP', 'TOTAL', '206208000.00', '207377522.00', '-1169522.00', '101.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(47, 6, 'SDJ JAKUT', '2022-2023', 'SPP', 'TOTAL', '129600000.00', '129960000.00', '-360000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(48, 7, 'SDJ JAYAPURA', '2022-2023', 'SPP', 'TOTAL', '99000000.00', '94100000.00', '4900000.00', '95.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(49, 8, 'SDJ MEDAN', '2022-2023', 'SPP', 'TOTAL', '316120000.00', '316444500.00', '-324500.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(50, 9, 'SDJ SEMARANG', '2022-2023', 'SPP', 'TOTAL', '107400000.00', '107510000.00', '-110000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(51, 10, 'SDJ SURABAYA', '2022-2023', 'SPP', 'TOTAL', '199950000.00', '194227000.00', '5723000.00', '97.00', 'GOOD', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(52, 11, 'SDJ TANGERANG', '2022-2023', 'SPP', 'TOTAL', '197550000.00', '197602000.00', '-52000.00', '100.00', 'EXCELLENT', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(53, 12, 'SDJ YOGYAKARTA', '2022-2023', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(54, 13, 'TKIT TANGERANG', '2022-2023', 'SPP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:03:31', '2026-02-03 04:50:20'),
(55, 1, 'SDJ BATAM', '2022-2023', 'DKT', 'TOTAL', '81200000.00', '76350000.00', '4850000.00', '94.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(56, 2, 'SDJ CILEGON', '2022-2023', 'DKT', 'TOTAL', '82900000.00', '82900000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(57, 3, 'SDJ JAKBAR', '2022-2023', 'DKT', 'TOTAL', '88200000.00', '76900000.00', '11300000.00', '87.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(58, 4, 'SDJ JAKSEL', '2022-2023', 'DKT', 'TOTAL', '80300000.00', '78793000.00', '1507000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(59, 5, 'SDJ JAKTIM', '2022-2023', 'DKT', 'TOTAL', '143600000.00', '139238700.00', '4361300.00', '97.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(60, 6, 'SDJ JAKUT', '2022-2023', 'DKT', 'TOTAL', '92800000.00', '91999000.00', '801000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(61, 7, 'SDJ JAYAPURA', '2022-2023', 'DKT', 'TOTAL', '45225000.00', '40225000.00', '5000000.00', '89.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(62, 8, 'SDJ MEDAN', '2022-2023', 'DKT', 'TOTAL', '125348700.00', '125348700.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(63, 9, 'SDJ SEMARANG', '2022-2023', 'DKT', 'TOTAL', '41615000.00', '42015000.00', '-400000.00', '101.00', 'EXCELLENT', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(64, 10, 'SDJ SURABAYA', '2022-2023', 'DKT', 'TOTAL', '97000000.00', '95475000.00', '1525000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(65, 11, 'SDJ TANGERANG', '2022-2023', 'DKT', 'TOTAL', '82250000.00', '80796000.00', '1454000.00', '98.00', 'GOOD', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(66, 12, 'SDJ YOGYAKARTA', '2022-2023', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(67, 13, 'TKIT TANGERANG', '2022-2023', 'DKT', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:14', '2026-02-03 04:50:20'),
(68, 1, 'SDJ BATAM', '2022-2023', 'DSP', 'TOTAL', '107000000.00', '95899500.00', '11100500.00', '90.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(69, 2, 'SDJ CILEGON', '2022-2023', 'DSP', 'TOTAL', '57000000.00', '57000000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(70, 3, 'SDJ JAKBAR', '2022-2023', 'DSP', 'TOTAL', '64375000.00', '53690000.00', '10685000.00', '83.00', 'AVERAGE', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(71, 4, 'SDJ JAKSEL', '2022-2023', 'DSP', 'TOTAL', '61500000.00', '61048000.00', '452000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(72, 5, 'SDJ JAKTIM', '2022-2023', 'DSP', 'TOTAL', '102000000.00', '102088000.00', '-88000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(73, 6, 'SDJ JAKUT', '2022-2023', 'DSP', 'TOTAL', '73250000.00', '72695000.00', '555000.00', '99.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(74, 7, 'SDJ JAYAPURA', '2022-2023', 'DSP', 'TOTAL', '25583333.00', '11950000.00', '13633333.00', '47.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(75, 8, 'SDJ MEDAN', '2022-2023', 'DSP', 'TOTAL', '79750000.00', '77350000.00', '2400000.00', '97.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(76, 9, 'SDJ SEMARANG', '2022-2023', 'DSP', 'TOTAL', '69800000.00', '69800000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(77, 10, 'SDJ SURABAYA', '2022-2023', 'DSP', 'TOTAL', '70650000.00', '70641000.00', '9000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(78, 11, 'SDJ TANGERANG', '2022-2023', 'DSP', 'TOTAL', '60500000.00', '55150000.00', '5350000.00', '91.00', 'GOOD', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(79, 12, 'SDJ YOGYAKARTA', '2022-2023', 'DSP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(80, 13, 'TKIT TANGERANG', '2022-2023', 'DSP', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:23', '2026-02-03 04:50:20'),
(81, 1, 'SDJ BATAM', '2022-2023', 'SERAGAM', 'TOTAL', '28800000.00', '28800000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(82, 2, 'SDJ CILEGON', '2022-2023', 'SERAGAM', 'TOTAL', '14000000.00', '14000000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(83, 3, 'SDJ JAKBAR', '2022-2023', 'SERAGAM', 'TOTAL', '15200000.00', '15200000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(84, 4, 'SDJ JAKSEL', '2022-2023', 'SERAGAM', 'TOTAL', '15756000.00', '15756000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(85, 5, 'SDJ JAKTIM', '2022-2023', 'SERAGAM', 'TOTAL', '24165000.00', '23450000.00', '715000.00', '97.00', 'GOOD', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(86, 6, 'SDJ JAKUT', '2022-2023', 'SERAGAM', 'TOTAL', '16700000.00', '16700000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(87, 7, 'SDJ JAYAPURA', '2022-2023', 'SERAGAM', 'TOTAL', '6500000.00', '5000000.00', '1500000.00', '77.00', 'AVERAGE', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(88, 8, 'SDJ MEDAN', '2022-2023', 'SERAGAM', 'TOTAL', '26845000.00', '26845000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(89, 9, 'SDJ SEMARANG', '2022-2023', 'SERAGAM', 'TOTAL', '17740000.00', '17740000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(90, 10, 'SDJ SURABAYA', '2022-2023', 'SERAGAM', 'TOTAL', '19582000.00', '19580000.00', '2000.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(91, 11, 'SDJ TANGERANG', '2022-2023', 'SERAGAM', 'TOTAL', '13300000.00', '13300000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(92, 12, 'SDJ YOGYAKARTA', '2022-2023', 'SERAGAM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(93, 13, 'TKIT TANGERANG', '2022-2023', 'SERAGAM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:32', '2026-02-03 04:50:20'),
(94, 1, 'SDJ BATAM', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(95, 2, 'SDJ CILEGON', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(96, 3, 'SDJ JAKBAR', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(97, 4, 'SDJ JAKSEL', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(98, 5, 'SDJ JAKTIM', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(99, 6, 'SDJ JAKUT', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(100, 7, 'SDJ JAYAPURA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(101, 8, 'SDJ MEDAN', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(102, 9, 'SDJ SEMARANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(103, 10, 'SDJ SURABAYA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(104, 11, 'SDJ TANGERANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(105, 12, 'SDJ YOGYAKARTA', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(106, 13, 'TKIT TANGERANG', '2022-2023', 'BIAYA KHUSUS', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 09:05:41', '2026-02-03 04:50:20'),
(107, 1, 'SDJ BATAM', '2024-2025', 'UMUM', 'TOTAL', '129350000.00', '104325000.00', '25025000.00', '80.65', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(108, 2, 'SDJ CILEGON', '2024-2025', 'UMUM', 'TOTAL', '130150000.00', '130150000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(109, 3, 'SDJ JAKBAR', '2024-2025', 'UMUM', 'TOTAL', '124950000.00', '90377000.00', '34573000.00', '72.33', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(110, 4, 'SDJ JAKSEL', '2024-2025', 'UMUM', 'TOTAL', '94000000.00', '87985000.00', '6015000.00', '93.60', 'AVERAGE', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(111, 5, 'SDJ JAKTIM', '2024-2025', 'UMUM', 'TOTAL', '222500000.00', '224401000.00', '0.00', '100.85', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(112, 6, 'SDJ JAKUT', '2024-2025', 'UMUM', 'TOTAL', '163050000.00', '160280000.00', '2770000.00', '98.30', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(113, 7, 'SDJ JAYAPURA', '2024-2025', 'UMUM', 'TOTAL', '75850000.00', '61000000.00', '14850000.00', '80.42', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(114, 8, 'SDJ MEDAN', '2024-2025', 'UMUM', 'TOTAL', '193650000.00', '192627000.00', '1023000.00', '99.47', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(115, 9, 'SDJ SEMARANG', '2024-2025', 'UMUM', 'TOTAL', '111450000.00', '111450000.00', '0.00', '100.00', 'EXCELLENT', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(116, 10, 'SDJ SURABAYA', '2024-2025', 'UMUM', 'TOTAL', '150620000.00', '142942000.00', '7678000.00', '94.90', 'AVERAGE', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(117, 11, 'SDJ TANGERANG', '2024-2025', 'UMUM', 'TOTAL', '197100000.00', '191979000.00', '5121000.00', '97.40', 'GOOD', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(118, 12, 'SDJ YOGYAKARTA', '2024-2025', 'UMUM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(119, 13, 'TKIT TANGERANG', '2024-2025', 'UMUM', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-30 03:46:14', '2026-02-03 04:50:20'),
(134, NULL, 'SDJ BATAM', '2024-2025', 'TOTAL', 'Total', '456385000.00', '411697500.00', '44687500.00', '90.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(135, NULL, 'SDJ CILEGON', '2024-2025', 'TOTAL', 'Total', '548750000.00', '549575000.00', '825000.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(136, NULL, 'SDJ JAKBAR', '2024-2025', 'TOTAL', 'Total', '537310000.00', '449707000.00', '87603000.00', '84.00', 'AVERAGE', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(137, NULL, 'SDJ JAKSEL', '2024-2025', 'TOTAL', 'Total', '381530000.00', '357643500.00', '23886500.00', '94.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(138, NULL, 'SDJ JAKTIM', '2024-2025', 'TOTAL', 'Total', '715395000.00', '719323000.00', '3928000.00', '101.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(139, NULL, 'SDJ JAKUT', '2024-2025', 'TOTAL', 'Total', '572725000.00', '570290001.00', '2434999.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(140, NULL, 'SDJ JAYAPURA', '2024-2025', 'TOTAL', 'Total', '343150000.00', '305325000.00', '37825000.00', '89.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(141, NULL, 'SDJ MEDAN', '2024-2025', 'TOTAL', 'Total', '774205000.00', '773372500.00', '832500.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(142, NULL, 'SDJ SEMARANG', '2024-2025', 'TOTAL', 'Total', '318150000.00', '321425000.00', '3275000.00', '101.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(143, NULL, 'SDJ SURABAYA', '2024-2025', 'TOTAL', 'Total', '527184000.00', '505299500.00', '21884500.00', '96.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 07:42:53'),
(144, NULL, 'SDJ TANGERANG', '2024-2025', 'TOTAL', 'Total', '658877500.00', '653668500.00', '5209000.00', '99.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 07:42:53');

-- --------------------------------------------------------

--
-- Table structure for table `kepatuhan_pembayaran_backup_total`
--

CREATE TABLE `kepatuhan_pembayaran_backup_total` (
  `id` int NOT NULL DEFAULT '0',
  `sekolah_id` int DEFAULT NULL,
  `ta` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Unit / Sekolah (SDJ BATAM, dll)',
  `period` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tahun ajaran (2022-2023)',
  `category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'SPP, DKT, DSP, SERAGAM, BIAYA KHUSUS',
  `month` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TOTAL' COMMENT 'TOTAL / JANUARI / FEBRUARI / dst',
  `target` decimal(15,2) NOT NULL DEFAULT '0.00',
  `capaian` decimal(15,2) NOT NULL DEFAULT '0.00',
  `piutang` decimal(15,2) NOT NULL DEFAULT '0.00',
  `persen` decimal(5,2) NOT NULL DEFAULT '0.00',
  `kategori` enum('EXCELLENT','GOOD','AVERAGE','POOR') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'POOR',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `kepatuhan_pembayaran_backup_total`
--

INSERT INTO `kepatuhan_pembayaran_backup_total` (`id`, `sekolah_id`, `ta`, `period`, `category`, `month`, `target`, `capaian`, `piutang`, `persen`, `kategori`, `created_at`, `updated_at`) VALUES
(1, 1, 'SDJ BATAM', '2022-2023', 'TOTAL', 'TOTAL', '375600000.00', '359649500.00', '15950500.00', '96.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(2, 2, 'SDJ CILEGON', '2022-2023', 'TOTAL', 'TOTAL', '363300000.00', '363664000.00', '-364000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(3, 3, 'SDJ JAKBAR', '2022-2023', 'TOTAL', 'TOTAL', '417135000.00', '391300000.00', '25835000.00', '94.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(4, 4, 'SDJ JAKSEL', '2022-2023', 'TOTAL', 'TOTAL', '387136000.00', '381139000.00', '5997000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(5, 5, 'SDJ JAKTIM', '2022-2023', 'TOTAL', 'TOTAL', '475973000.00', '472154222.00', '3818778.00', '99.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(6, 6, 'SDJ JAKUT', '2022-2023', 'TOTAL', 'TOTAL', '312350000.00', '311354000.00', '996000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(7, 7, 'SDJ JAYAPURA', '2022-2023', 'TOTAL', 'TOTAL', '176308333.00', '151275000.00', '25033333.00', '86.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(8, 8, 'SDJ MEDAN', '2022-2023', 'TOTAL', 'TOTAL', '548063700.00', '545988200.00', '2075500.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(9, 9, 'SDJ SEMARANG', '2022-2023', 'TOTAL', 'TOTAL', '236555000.00', '237065000.00', '-510000.00', '100.00', 'EXCELLENT', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(10, 10, 'SDJ SURABAYA', '2022-2023', 'TOTAL', 'TOTAL', '387182000.00', '379923000.00', '7259000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(11, 11, 'SDJ TANGERANG', '2022-2023', 'TOTAL', 'TOTAL', '353600000.00', '346848000.00', '6752000.00', '98.00', 'GOOD', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(12, 12, 'SDJ YOGYAKARTA', '2022-2023', 'TOTAL', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(13, 13, 'TKIT TANGERANG', '2022-2023', 'TOTAL', 'TOTAL', '0.00', '0.00', '0.00', '0.00', 'POOR', '2026-01-29 08:23:33', '2026-02-03 04:50:20'),
(134, NULL, 'SDJ BATAM', '2024-2025', 'TOTAL', 'TOTAL', '456385000.00', '411697500.00', '44687500.00', '90.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(135, NULL, 'SDJ CILEGON', '2024-2025', 'TOTAL', 'TOTAL', '548750000.00', '549575000.00', '825000.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(136, NULL, 'SDJ JAKBAR', '2024-2025', 'TOTAL', 'TOTAL', '537310000.00', '449707000.00', '87603000.00', '84.00', 'AVERAGE', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(137, NULL, 'SDJ JAKSEL', '2024-2025', 'TOTAL', 'TOTAL', '381530000.00', '357643500.00', '23886500.00', '94.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(138, NULL, 'SDJ JAKTIM', '2024-2025', 'TOTAL', 'TOTAL', '715395000.00', '719323000.00', '3928000.00', '101.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(139, NULL, 'SDJ JAKUT', '2024-2025', 'TOTAL', 'TOTAL', '572725000.00', '570290001.00', '2434999.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(140, NULL, 'SDJ JAYAPURA', '2024-2025', 'TOTAL', 'TOTAL', '343150000.00', '305325000.00', '37825000.00', '89.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(141, NULL, 'SDJ MEDAN', '2024-2025', 'TOTAL', 'TOTAL', '774205000.00', '773372500.00', '832500.00', '100.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(142, NULL, 'SDJ SEMARANG', '2024-2025', 'TOTAL', 'TOTAL', '318150000.00', '321425000.00', '3275000.00', '101.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(143, NULL, 'SDJ SURABAYA', '2024-2025', 'TOTAL', 'TOTAL', '527184000.00', '505299500.00', '21884500.00', '96.00', 'GOOD', '2026-02-03 07:42:53', '2026-02-03 08:00:15'),
(144, NULL, 'SDJ TANGERANG', '2024-2025', 'TOTAL', 'TOTAL', '658877500.00', '653668500.00', '5209000.00', '99.00', 'EXCELLENT', '2026-02-03 07:42:53', '2026-02-03 08:00:15');

-- --------------------------------------------------------

--
-- Table structure for table `log_aktivitas`
--

CREATE TABLE `log_aktivitas` (
  `id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `aktivitas` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `tabel` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `record_id` int DEFAULT NULL,
  `detail` text COLLATE utf8mb4_general_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `log_aktivitas`
--

INSERT INTO `log_aktivitas` (`id`, `user_id`, `aktivitas`, `tabel`, `record_id`, `detail`, `ip_address`, `created_at`) VALUES
(1, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 03:18:39'),
(2, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 03:32:01'),
(3, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 03:32:12'),
(4, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 04:31:17'),
(5, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 04:35:41'),
(6, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 04:59:04'),
(7, 14, 'Login ke sistem', 'users', 14, NULL, '::1', '2025-12-17 05:12:17'),
(8, 1, 'Login ke sistem', 'users', 1, NULL, '::1', '2025-12-17 06:22:38'),
(9, 1, 'Logout dari sistem', 'users', 1, 'User: admin', '::1', '2025-12-17 07:58:45'),
(10, 14, 'Login ke sistem', 'users', 14, NULL, '::1', '2025-12-17 07:58:47'),
(11, 14, 'Logout dari sistem', 'users', 14, 'User: kai', '::1', '2025-12-17 07:58:52'),
(12, 14, 'Login ke sistem', 'users', 14, NULL, '::1', '2025-12-17 07:58:54'),
(13, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=21', '::1', '2025-12-17 07:59:43'),
(14, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=49', '::1', '2025-12-17 08:05:20'),
(15, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=48', '::1', '2025-12-17 08:06:12'),
(16, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=51', '::1', '2025-12-17 08:14:15'),
(17, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=51', '::1', '2025-12-17 08:14:27'),
(18, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=51', '::1', '2025-12-17 08:14:46'),
(19, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/edit_barang.php?id=51', '::1', '2025-12-17 08:28:27'),
(20, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-18 02:33:06'),
(21, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-18 02:36:12'),
(22, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-18 02:36:14'),
(23, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-18 02:43:42'),
(24, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-18 02:43:47'),
(25, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-18 02:46:09'),
(26, 14, 'Akses ditolak - Role: S - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/laporan.php', '::1', '2025-12-18 02:47:11'),
(27, 14, 'Logout', 'users', 14, 'Logout dari IP: ::1', '::1', '2025-12-18 03:44:11'),
(28, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-18 03:44:17'),
(29, 1, 'Menambah barang inventory: Laptop', 'inventory', 54, NULL, '::1', '2025-12-18 03:45:06'),
(30, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-18 03:51:37'),
(31, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-18 03:51:44'),
(32, 14, 'Logout', 'users', 14, 'Logout dari IP: ::1', '::1', '2025-12-18 03:52:16'),
(33, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-18 03:52:22'),
(34, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-18 03:54:26'),
(35, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-18 03:54:31'),
(36, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-18 09:26:13'),
(37, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 01:47:18'),
(38, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 02:32:07'),
(39, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 03:03:27'),
(40, 14, 'Logout', 'users', 14, 'Logout dari IP: ::1', '::1', '2025-12-19 03:09:18'),
(41, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-19 03:09:23'),
(42, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-19 03:24:45'),
(43, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-19 03:24:47'),
(44, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-19 04:42:08'),
(45, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 04:42:12'),
(46, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-19 04:48:41'),
(47, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-19 06:25:16'),
(48, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 06:25:20'),
(49, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-19 07:30:07'),
(50, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-19 07:33:30'),
(51, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 07:33:35'),
(52, 14, 'Logout', 'users', 14, 'Logout dari IP: ::1', '::1', '2025-12-19 08:02:47'),
(53, 14, 'Login berhasil', 'users', 14, 'Login dari IP: ::1', '::1', '2025-12-19 08:02:49'),
(54, 14, 'Logout', 'users', 14, 'Logout dari IP: ::1', '::1', '2025-12-19 08:05:01'),
(55, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: ::1', '::1', '2025-12-19 08:05:08'),
(56, NULL, 'Logout', 'users', 8, 'Logout dari IP: ::1', '::1', '2025-12-19 08:05:19'),
(57, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: ::1', '::1', '2025-12-19 08:05:26'),
(58, NULL, 'Akses ditolak - Role: M - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/laporan.php', '::1', '2025-12-19 08:05:41'),
(59, NULL, 'Akses ditolak - Role: M - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/laporan.php', '::1', '2025-12-19 08:06:03'),
(60, NULL, 'Akses ditolak - Role: M - Required: A', 'access_denied', NULL, '/inventoryACF/pages/admin/laporan.php', '::1', '2025-12-19 08:13:21'),
(61, NULL, 'Logout', 'users', 7, 'Logout dari IP: ::1', '::1', '2025-12-19 08:27:59'),
(62, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-19 08:28:07'),
(63, 1, 'Edit sumber dana', 'sumber_dana', 3, 'BOS', '::1', '2025-12-19 09:20:19'),
(64, 1, 'Edit sumber dana', 'sumber_dana', 3, 'BOS', '::1', '2025-12-19 09:20:24'),
(65, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-22 01:42:25'),
(66, 1, 'Logout', 'users', 1, 'Logout dari IP: ::1', '::1', '2025-12-22 02:18:31'),
(67, 1, 'Login berhasil', 'users', 1, 'Login dari IP: ::1', '::1', '2025-12-22 02:18:46'),
(68, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-27 02:57:41'),
(69, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-01-27 03:02:07'),
(70, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-27 03:02:16'),
(71, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-01-27 08:21:05'),
(72, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-27 08:21:09'),
(73, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-28 01:06:46'),
(74, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-28 04:42:51'),
(75, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-28 08:12:06'),
(76, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-29 01:32:12'),
(77, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-29 06:56:13'),
(78, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 02:03:31'),
(79, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 05:36:19'),
(80, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 05:36:30'),
(81, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 05:38:01'),
(82, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 05:38:08'),
(83, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-30 07:33:12'),
(84, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-31 12:13:25'),
(85, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-01-31 15:01:44'),
(86, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-01-31 16:31:55'),
(87, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-01 08:31:43'),
(88, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-02 01:59:11'),
(89, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-02 03:59:04'),
(90, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-02 03:59:13'),
(91, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-02 04:00:06'),
(92, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-02 04:00:10'),
(93, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-03 04:24:34'),
(94, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-03 06:55:00'),
(95, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-03 09:55:26'),
(96, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 01:03:31'),
(97, 1, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-04 01:24:33'),
(98, 1, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: ALL', '127.0.0.1', '2026-02-04 01:24:40'),
(99, 1, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-04 01:24:47'),
(100, 1, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024, Category: ALL', '127.0.0.1', '2026-02-04 01:24:50'),
(101, 1, 'Akses Admin Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-04 01:52:07'),
(102, 1, 'Akses Admin Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: ALL', '127.0.0.1', '2026-02-04 01:52:58'),
(103, 1, 'Akses Admin Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-04 01:56:22'),
(104, 1, 'Akses Admin Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-04 01:56:46'),
(105, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:20:26'),
(106, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:20:31'),
(107, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:51:28'),
(108, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:51:32'),
(109, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:56:31'),
(110, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:56:44'),
(111, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:57:07'),
(112, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-04 09:57:10'),
(113, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 01:51:17'),
(114, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 03:05:13'),
(115, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 03:05:16'),
(116, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 03:15:17'),
(117, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 03:15:19'),
(118, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 03:53:06'),
(119, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 04:06:10'),
(120, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-05 04:06:23'),
(121, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: ALL', '127.0.0.1', '2026-02-05 04:06:30'),
(122, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024, Category: ALL', '127.0.0.1', '2026-02-05 04:06:31'),
(123, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-05 04:06:32'),
(124, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 04:07:31'),
(125, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 04:07:35'),
(126, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 04:11:02'),
(127, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 04:11:34'),
(128, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL', '127.0.0.1', '2026-02-05 04:14:03'),
(129, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:41'),
(130, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:51'),
(131, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:51'),
(132, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:52'),
(133, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:53'),
(134, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:54'),
(135, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:55'),
(136, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: N/A', '127.0.0.1', '2026-02-05 04:20:56'),
(137, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 04:20:59'),
(138, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 04:21:02'),
(139, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 04:25:13'),
(140, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 04:25:18'),
(141, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 04:25:20'),
(142, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:45'),
(143, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:49'),
(144, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:51'),
(145, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:52'),
(146, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:53'),
(147, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:31:53'),
(148, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:04'),
(149, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:06'),
(150, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:07'),
(151, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:08'),
(152, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:15'),
(153, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:17'),
(154, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:33'),
(155, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:35'),
(156, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:32:37'),
(157, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:10'),
(158, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:13'),
(159, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:18'),
(160, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: SPP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:24'),
(161, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: DKT, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:25'),
(162, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:26'),
(163, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2023-2024, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:33:28'),
(164, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 04:34:27'),
(165, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:40:34'),
(166, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SPP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:40:55'),
(167, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DKT, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:40:56'),
(168, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:40:57'),
(169, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:40:57'),
(170, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:46:46'),
(171, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: SERAGAM, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:46:51'),
(172, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: DSP, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 04:46:57'),
(173, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 04:49:30'),
(174, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 04:57:28'),
(175, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:05:30'),
(176, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:05:30'),
(177, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:10:23'),
(178, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:15:15'),
(179, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:18:25'),
(180, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 05:18:39'),
(181, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 05:18:42'),
(182, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 05:19:33'),
(183, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 05:19:38'),
(184, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:30:59'),
(185, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:39:58'),
(186, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:42:07'),
(187, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:42:47'),
(188, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:42:56'),
(189, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:43:00'),
(190, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:47:18'),
(191, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:47:21'),
(192, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:47:23'),
(193, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:49:54'),
(194, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:54:01'),
(195, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:54:43'),
(196, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:54:49'),
(197, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:54:51'),
(198, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:56:12'),
(199, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:56:25'),
(200, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:56:27'),
(201, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:58:46'),
(202, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 05:58:48'),
(203, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:01:43'),
(204, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:01:50'),
(205, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:11:46'),
(206, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:11:52'),
(207, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:11:55'),
(208, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:11:57'),
(209, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:12:05'),
(210, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:17:24'),
(211, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:17:32'),
(212, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:18:00'),
(213, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:18:19'),
(214, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:22:42'),
(215, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:34:52'),
(216, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:37:51'),
(217, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:40:25'),
(218, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:40:53'),
(219, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:41:05'),
(220, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:47:59'),
(221, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:48:02'),
(222, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:49:31'),
(223, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:55:43'),
(224, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:55:45'),
(225, NULL, 'Akses Rencana Kerja Manager', 'rencana_kerja', NULL, 'Department: Operational, Role: Dept Operasional (dept_head)', '127.0.0.1', '2026-02-05 06:56:01'),
(226, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 06:56:09'),
(227, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 06:56:12'),
(228, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-05 08:06:45'),
(229, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 08:06:49'),
(230, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 08:53:38'),
(231, NULL, 'Akses Dashboard Kepatuhan Pembayaran', 'kepatuhan_pembayaran', NULL, 'Period: 2024-2025, Category: ALL, Role: Dept Operasional (dept_head), Dept: Operational', '127.0.0.1', '2026-02-05 08:53:41'),
(232, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-05 10:49:22'),
(233, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 04:50:17'),
(234, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 04:50:23'),
(235, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 05:46:12'),
(236, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 05:46:15'),
(237, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 05:56:39'),
(238, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 05:57:06'),
(239, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 05:58:01'),
(240, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 05:58:10'),
(241, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 05:58:14'),
(242, 14, 'Login berhasil', 'users', 14, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 05:58:25'),
(243, 14, 'Logout', 'users', 14, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 05:59:37'),
(244, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 05:59:41'),
(245, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 06:09:31'),
(246, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 06:09:39'),
(247, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 06:11:13'),
(248, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 06:11:16'),
(249, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 06:16:43'),
(250, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 06:16:47'),
(251, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 06:40:05'),
(252, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1', '127.0.0.1', '2026-02-06 06:40:07'),
(253, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-06 06:46:38'),
(254, 15, 'Akses ditolak - Role: DIRECTOR - Required: D', 'access_denied', NULL, '/inventoryACF/pages/director/home_director.php', '127.0.0.1', '2026-02-06 08:26:56'),
(255, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-06 09:02:59'),
(256, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 09:41:59'),
(257, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-06 09:42:03'),
(258, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 09:42:45'),
(259, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 09:42:49'),
(260, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 09:42:52'),
(261, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 09:42:54'),
(262, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 09:43:02'),
(263, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1, Role: staff', '127.0.0.1', '2026-02-06 09:43:43'),
(264, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 10:00:03'),
(265, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:08'),
(266, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:10'),
(267, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:11'),
(268, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:14'),
(269, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:16'),
(270, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:17'),
(271, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:20'),
(272, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-06 10:00:22'),
(273, NULL, 'Login berhasil', 'users', 8, 'Login dari IP: 127.0.0.1, Role: staff', '127.0.0.1', '2026-02-06 10:02:10'),
(274, NULL, 'Logout', 'users', 8, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-06 10:02:20'),
(275, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-06 10:02:23'),
(276, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 01:24:47'),
(277, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 01:26:27'),
(278, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 01:27:27'),
(279, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 01:27:28'),
(280, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 01:37:44'),
(281, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 02:14:21'),
(282, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-09 02:14:25'),
(283, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 02:19:23'),
(284, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 02:19:27'),
(285, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:13:28'),
(286, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-09 03:13:33'),
(287, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:13:48'),
(288, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:14:06'),
(289, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:14:11'),
(290, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:14:14'),
(291, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:14:15'),
(292, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:14:51'),
(293, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:28:18'),
(294, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 03:28:22'),
(295, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:33:04'),
(296, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:33:09'),
(297, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:35:21'),
(298, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 03:35:25'),
(299, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 03:36:24'),
(300, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 03:36:28'),
(301, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 04:14:16'),
(302, 14, 'Login berhasil', 'users', 14, 'Login dari IP: 127.0.0.1, Role: staff', '127.0.0.1', '2026-02-09 04:14:21'),
(303, 14, 'Logout', 'users', 14, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 04:29:47'),
(304, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-09 04:29:52'),
(305, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:10:25'),
(306, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 05:10:39'),
(307, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:20:07'),
(308, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 05:20:12'),
(309, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:20:38'),
(310, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 05:21:02'),
(311, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:23:47'),
(312, 15, 'Login berhasil', 'users', 15, 'Login dari IP: 127.0.0.1, Role: director', '127.0.0.1', '2026-02-09 05:23:53'),
(313, 15, 'Logout', 'users', 15, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:24:41'),
(314, 14, 'Login berhasil', 'users', 14, 'Login dari IP: 127.0.0.1, Role: staff', '127.0.0.1', '2026-02-09 05:25:00'),
(315, 14, 'Logout', 'users', 14, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:26:26'),
(316, NULL, 'Login berhasil', 'users', 7, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 05:26:31'),
(317, NULL, 'Logout', 'users', 7, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 05:27:54'),
(318, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 05:28:01'),
(319, 1, 'Logout', 'users', 1, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 08:09:39'),
(320, 16, 'Login berhasil', 'users', 16, 'Login dari IP: 127.0.0.1, Role: dept_head', '127.0.0.1', '2026-02-09 08:09:56'),
(321, 16, 'Logout', 'users', 16, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 08:10:36'),
(322, 17, 'Login berhasil', 'users', 17, 'Login dari IP: 127.0.0.1, Role: staff', '127.0.0.1', '2026-02-09 08:10:43'),
(323, 17, 'Logout', 'users', 17, 'Logout dari IP: 127.0.0.1, Browser: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Sa', '127.0.0.1', '2026-02-09 08:11:08'),
(324, 1, 'Login berhasil', 'users', 1, 'Login dari IP: 127.0.0.1, Role: admin', '127.0.0.1', '2026-02-09 08:11:18');

-- --------------------------------------------------------

--
-- Table structure for table `lokasi`
--

CREATE TABLE `lokasi` (
  `id` int NOT NULL,
  `nama_lokasi` varchar(100) NOT NULL,
  `deskripsi` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `lokasi`
--

INSERT INTO `lokasi` (`id`, `nama_lokasi`, `deskripsi`, `created_at`) VALUES
(1, 'Ruang Kelas A', 'Ruang kelas lantai 1', '2026-01-31 16:30:53'),
(2, 'Ruang Kelas B', 'Ruang kelas lantai 2', '2026-01-31 16:30:53'),
(3, 'Lab Komputer', 'Laboratorium komputer', '2026-01-31 16:30:53'),
(4, 'Perpustakaan', 'Ruang perpustakaan', '2026-01-31 16:30:53'),
(5, 'Ruang Guru', 'Ruang guru dan staf', '2026-01-31 16:30:53'),
(6, 'Gudang', 'Gudang penyimpanan', '2026-01-31 16:30:53');

-- --------------------------------------------------------

--
-- Table structure for table `pembayaran_bulanan`
--

CREATE TABLE `pembayaran_bulanan` (
  `id` int NOT NULL,
  `pembayaran_tahunan_id` int NOT NULL,
  `bulan` tinyint NOT NULL COMMENT '1=Juli, 2=Agustus, ..., 12=Juni',
  `nama_bulan` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_bulanan` decimal(15,2) NOT NULL DEFAULT '0.00',
  `capaian_bulanan` decimal(15,2) NOT NULL DEFAULT '0.00',
  `piutang_bulanan` decimal(15,2) GENERATED ALWAYS AS ((`target_bulanan` - `capaian_bulanan`)) STORED,
  `persentase_capaian` decimal(5,2) GENERATED ALWAYS AS ((case when (`target_bulanan` > 0) then ((`capaian_bulanan` / `target_bulanan`) * 100) else 0 end)) STORED,
  `kategori_kepatuhan` varchar(20) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS ((case when (`target_bulanan` = 0) then _utf8mb4'NO DATA' when (((`capaian_bulanan` / `target_bulanan`) * 100) >= 95) then _utf8mb4'EXCELLENT' when (((`capaian_bulanan` / `target_bulanan`) * 100) >= 80) then _utf8mb4'GOOD' when (((`capaian_bulanan` / `target_bulanan`) * 100) >= 65) then _utf8mb4'AVERAGE' else _utf8mb4'POOR' end)) STORED,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pembayaran_tahunan`
--

CREATE TABLE `pembayaran_tahunan` (
  `id` int NOT NULL,
  `sekolah_id` int NOT NULL,
  `tahun_ajaran_id` int NOT NULL,
  `jenis_pembayaran_id` int NOT NULL,
  `kategori_siswa_id` int NOT NULL,
  `target_tahunan` decimal(15,2) NOT NULL DEFAULT '0.00',
  `capaian_tahunan` decimal(15,2) NOT NULL DEFAULT '0.00',
  `piutang_tahunan` decimal(15,2) GENERATED ALWAYS AS ((`target_tahunan` - `capaian_tahunan`)) STORED,
  `persentase_capaian` decimal(5,2) GENERATED ALWAYS AS ((case when (`target_tahunan` > 0) then ((`capaian_tahunan` / `target_tahunan`) * 100) else 0 end)) STORED,
  `kategori_kepatuhan` varchar(20) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS ((case when (`target_tahunan` = 0) then _utf8mb4'NO DATA' when (((`capaian_tahunan` / `target_tahunan`) * 100) >= 95) then _utf8mb4'EXCELLENT' when (((`capaian_tahunan` / `target_tahunan`) * 100) >= 80) then _utf8mb4'GOOD' when (((`capaian_tahunan` / `target_tahunan`) * 100) >= 65) then _utf8mb4'AVERAGE' else _utf8mb4'POOR' end)) STORED,
  `bulan_data` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Data up to which month (e.g., JUNI, DESEMBER)',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `periode`
--

CREATE TABLE `periode` (
  `id` int NOT NULL,
  `nama` varchar(20) NOT NULL,
  `aktif` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ref_jenis_asset`
--

CREATE TABLE `ref_jenis_asset` (
  `id` int NOT NULL,
  `kode_jenis` varchar(5) NOT NULL,
  `nama_jenis` varchar(100) NOT NULL,
  `id_kategori` int NOT NULL,
  `prefix_huruf` char(1) NOT NULL,
  `deskripsi` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `ref_jenis_asset`
--

INSERT INTO `ref_jenis_asset` (`id`, `kode_jenis`, `nama_jenis`, `id_kategori`, `prefix_huruf`, `deskripsi`, `created_at`) VALUES
(1, 'LPT', 'Laptop', 1, 'A', 'Laptop/Notebook untuk kerja', '2025-12-19 02:44:18'),
(2, 'KPT', 'Komputer', 1, 'B', 'PC Desktop', '2025-12-19 02:44:18'),
(3, 'PRT', 'Printer', 1, 'C', 'Printer dan Scanner', '2025-12-19 02:44:18'),
(4, 'PYK', 'Proyektor', 1, 'D', 'Proyektor LCD/LED', '2025-12-19 02:44:18'),
(5, 'KMR', 'Kamera', 1, 'E', 'Kamera Digital', '2025-12-19 02:44:18'),
(6, 'MJK', 'Meja Kerja', 2, 'A', 'Meja kerja karyawan', '2025-12-19 02:44:18'),
(7, 'KRS', 'Kursi', 2, 'B', 'Kursi kantor', '2025-12-19 02:44:18'),
(8, 'LMR', 'Lemari', 2, 'C', 'Lemari arsip dan penyimpanan', '2025-12-19 02:44:18'),
(9, 'RAK', 'Rak', 2, 'D', 'Rak buku dan display', '2025-12-19 02:44:18'),
(10, 'MTR', 'Motor', 3, 'A', 'Sepeda motor', '2025-12-19 02:44:18'),
(11, 'MBL', 'Mobil', 3, 'B', 'Mobil operasional', '2025-12-19 02:44:18');

-- --------------------------------------------------------

--
-- Table structure for table `ref_kantor`
--

CREATE TABLE `ref_kantor` (
  `id` int NOT NULL,
  `kode_kantor` varchar(10) NOT NULL,
  `nama_kantor` varchar(100) NOT NULL,
  `keterangan` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `ref_kantor`
--

INSERT INTO `ref_kantor` (`id`, `kode_kantor`, `nama_kantor`, `keterangan`, `created_at`) VALUES
(1, 'PST', 'Pusat', 'Kantor Pusat ACF', '2025-12-19 02:44:17'),
(2, 'SDJ', 'Jakarta Timur', 'Kantor Cabang Jakarta Timur', '2025-12-19 02:44:17'),
(3, 'BDG', 'Bandung', 'Kantor Cabang Bandung', '2025-12-19 02:44:17'),
(4, 'SBY', 'Surabaya', 'Kantor Cabang Surabaya', '2025-12-19 02:44:17'),
(5, 'MDN', 'Medan', 'Kantor Cabang Medan', '2025-12-19 02:44:17');

-- --------------------------------------------------------

--
-- Table structure for table `ref_kategori`
--

CREATE TABLE `ref_kategori` (
  `id` int NOT NULL,
  `kode_kategori` varchar(5) NOT NULL,
  `nomor_kategori` varchar(2) NOT NULL,
  `nama_kategori` varchar(50) NOT NULL,
  `deskripsi` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `ref_kategori`
--

INSERT INTO `ref_kategori` (`id`, `kode_kategori`, `nomor_kategori`, `nama_kategori`, `deskripsi`, `created_at`) VALUES
(1, 'ETK', '01', 'Elektronik', 'Perangkat elektronik seperti laptop, komputer, printer', '2025-12-19 02:44:17'),
(2, 'FNE', '02', 'Furniture', 'Meja, kursi, lemari, dan peralatan kantor', '2025-12-19 02:44:17'),
(3, 'KDN', '03', 'Kendaraan', 'Motor, mobil, dan kendaraan operasional', '2025-12-19 02:44:17'),
(4, 'ATK', '04', 'ATK', 'Peralatan tulis dan administrasi', '2025-12-19 02:44:17'),
(5, 'BNG', '05', 'Bangunan', 'Gedung dan properti', '2025-12-19 02:44:17'),
(6, 'PKA', '06', 'Peralatan Kebersihan', 'Alat kebersihan dan sanitasi', '2025-12-19 02:44:17');

-- --------------------------------------------------------

--
-- Table structure for table `ref_sumber_dana`
--

CREATE TABLE `ref_sumber_dana` (
  `id` int NOT NULL,
  `kode_sumber` varchar(5) NOT NULL,
  `nomor_sumber` varchar(2) NOT NULL,
  `nama_sumber` varchar(50) NOT NULL,
  `deskripsi` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `ref_sumber_dana`
--

INSERT INTO `ref_sumber_dana` (`id`, `kode_sumber`, `nomor_sumber`, `nama_sumber`, `deskripsi`, `created_at`) VALUES
(1, 'HBH', '01', 'Hibah', 'Dana hibah dari donatur', '2025-12-19 02:44:18'),
(2, 'BOS', '02', 'BOS', 'Bantuan Operasional Sekolah', '2025-12-19 02:44:18'),
(3, 'OPS', '03', 'Operasional', 'Dana operasional internal', '2025-12-19 02:44:18'),
(4, 'CSR', '04', 'CSR', 'Corporate Social Responsibility', '2025-12-19 02:44:18'),
(5, 'PBD', '05', 'Pembelian Dinas', 'Pembelian dari dana dinas', '2025-12-19 02:44:18');

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja`
--

CREATE TABLE `rencana_kerja` (
  `id` int NOT NULL,
  `judul_tugas` varchar(255) NOT NULL,
  `deskripsi` text,
  `created_by` int NOT NULL COMMENT 'User ID yang membuat tugas',
  `assigned_to` int NOT NULL COMMENT 'User ID yang ditugaskan',
  `prioritas` enum('penting_genting','penting','penting_tidak_genting') DEFAULT NULL,
  `status` enum('pending','progress','stuck','done') DEFAULT 'pending',
  `progress` int DEFAULT '0' COMMENT 'Progress percentage 0-100',
  `priority` varchar(30) NOT NULL DEFAULT 'penting_tidak_genting',
  `tenggat_waktu` date NOT NULL,
  `approval_status` enum('none','pending_approval','approved','rejected') DEFAULT 'none',
  `approval_by` int DEFAULT NULL COMMENT 'Admin yang approve/reject',
  `approval_notes` text COMMENT 'Catatan approval/rejection',
  `approval_date` datetime DEFAULT NULL,
  `request_type` enum('create','edit','delete') DEFAULT NULL,
  `original_task_id` int DEFAULT NULL COMMENT 'ID tugas original jika request edit',
  `progress_percentage` int DEFAULT '0' COMMENT 'Progress 0-100%',
  `is_active` tinyint(1) DEFAULT '1',
  `is_deleted` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `completed_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted_by` int DEFAULT NULL,
  `department` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `rencana_kerja`
--

INSERT INTO `rencana_kerja` (`id`, `judul_tugas`, `deskripsi`, `created_by`, `assigned_to`, `prioritas`, `status`, `progress`, `priority`, `tenggat_waktu`, `approval_status`, `approval_by`, `approval_notes`, `approval_date`, `request_type`, `original_task_id`, `progress_percentage`, `is_active`, `is_deleted`, `created_at`, `updated_at`, `completed_at`, `deleted_at`, `deleted_by`, `department`) VALUES
(7, 'Update Dashboard Operasional', 'Perbarui tampilan dashboard dengan data terbaru Q1 2025', 1, 1, 'penting_genting', 'progress', 0, 'penting_tidak_genting', '2025-02-05', 'none', NULL, NULL, NULL, NULL, NULL, 60, 1, 1, '2026-02-02 04:56:07', '2026-02-04 08:49:10', NULL, '2026-02-04 15:49:10', NULL, NULL),
(12, 'dashboard operational', 'manager (asset, kebersihan dan sapras)', 1, 14, 'penting', 'done', 0, 'penting_tidak_genting', '2026-03-19', 'approved', NULL, NULL, '2026-02-02 13:36:16', NULL, NULL, 80, 1, 0, '2026-02-02 06:36:16', '2026-02-04 04:08:50', '2026-02-02 13:53:02', NULL, NULL, NULL),
(14, 'Evaluasi Kinerja Tim', 'Melakukan evaluasi kinerja staff bulanan', 20, 14, 'penting_genting', 'progress', 0, 'penting_tidak_genting', '2026-02-18', 'none', NULL, NULL, NULL, NULL, NULL, 20, 1, 1, '2026-02-04 06:42:34', '2026-02-09 04:10:59', NULL, '2026-02-09 11:10:59', NULL, 'Operational'),
(15, 'Evaluasi Kinerja Tim', 'Melakukan evaluasi kinerja staff bulanan', 20, 14, 'penting_genting', 'progress', 43, 'penting_tidak_genting', '2026-02-18', 'none', NULL, NULL, NULL, NULL, NULL, 20, 1, 1, '2026-02-04 06:42:47', '2026-02-09 05:27:12', NULL, '2026-02-09 12:27:12', NULL, 'Operational'),
(17, 'Tugas Awal - kyla nazwa', 'Tugas awal onboarding karyawan', 14, 14, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 1, '2026-02-04 06:43:00', '2026-02-09 04:12:46', NULL, '2026-02-09 11:12:46', NULL, 'Operational'),
(18, 'Tugas Awal - Andi Hardiana, S.T', 'Tugas awal onboarding karyawan', 17, 17, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 1, '2026-02-04 06:43:00', '2026-02-09 05:23:38', NULL, '2026-02-09 12:23:38', 1, 'Formal Education'),
(19, 'Tugas Awal - Aida Rahmawati', 'Tugas awal onboarding karyawan', 18, 18, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Formal Education'),
(20, 'Tugas Awal - Helena Anggeladelania', 'Tugas awal onboarding karyawan', 19, 19, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Formal Education'),
(21, 'Tugas Awal - Desi Eka Mulyati, S.E', 'Tugas awal onboarding karyawan', 21, 21, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Operational'),
(22, 'Tugas Awal - Risda Sari', 'Tugas awal onboarding karyawan', 22, 22, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Operational'),
(23, 'Tugas Awal - Freddy Yulianto', 'Tugas awal onboarding karyawan', 23, 23, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Operational'),
(24, 'Tugas Awal - Dian Rodiian Juhara', 'Tugas awal onboarding karyawan', 24, 24, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Operational'),
(25, 'Tugas Awal - Sulamun', 'Tugas awal onboarding karyawan', 25, 25, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Operational'),
(26, 'Tugas Awal - Intan Lestari, S.T', 'Tugas awal onboarding karyawan', 27, 27, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Non Formal Education'),
(27, 'Tugas Awal - Febriani Nur Sireek, S.Pd', 'Tugas awal onboarding karyawan', 28, 28, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Non Formal Education'),
(28, 'Tugas Awal - Vasan', 'Tugas awal onboarding karyawan', 29, 29, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Non Formal Education'),
(29, 'Tugas Awal - Adhitya Kamil', 'Tugas awal onboarding karyawan', 31, 31, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Marketing Communication'),
(30, 'Tugas Awal - Shaqina', 'Tugas awal onboarding karyawan', 32, 32, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Marketing Communication'),
(31, 'Tugas Awal - Ichwani Almoridz, S.Ds', 'Tugas awal onboarding karyawan', 33, 33, 'penting', 'pending', 0, 'penting_tidak_genting', '2026-02-14', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-04 06:43:00', '2026-02-04 06:43:00', NULL, NULL, NULL, 'Marketing Communication'),
(47, 'dashboard operational', '', 1, 26, NULL, 'pending', 0, 'penting_genting', '2026-02-18', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-09 05:22:04', '2026-02-09 05:22:04', NULL, NULL, NULL, 'Non Formal Education'),
(48, 'dbiabdb', 'gwgw', 14, 14, NULL, 'pending', 0, 'penting_tidak_genting', '2026-02-21', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-09 05:25:55', '2026-02-09 05:27:26', NULL, NULL, NULL, 'Operational'),
(49, 'test test', '', 17, 17, NULL, 'pending', 0, 'penting_tidak_genting', '2026-02-18', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-09 08:11:05', '2026-02-09 08:11:05', NULL, NULL, NULL, 'Formal Education');

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja_anggota`
--

CREATE TABLE `rencana_kerja_anggota` (
  `id` int NOT NULL,
  `task_id` int NOT NULL,
  `user_id` int NOT NULL,
  `role_in_task` enum('owner','member','viewer') DEFAULT 'member',
  `added_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja_attachment`
--

CREATE TABLE `rencana_kerja_attachment` (
  `id` int NOT NULL,
  `task_id` int NOT NULL,
  `uploaded_by` int NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` int NOT NULL COMMENT 'in bytes',
  `file_type` varchar(50) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja_backup`
--

CREATE TABLE `rencana_kerja_backup` (
  `id` int NOT NULL DEFAULT '0',
  `judul_tugas` varchar(255) NOT NULL,
  `deskripsi` text,
  `created_by` int NOT NULL COMMENT 'User ID yang membuat tugas',
  `assigned_to` int NOT NULL COMMENT 'User ID yang ditugaskan',
  `prioritas` enum('penting_genting','penting','penting_tidak_genting') DEFAULT NULL,
  `status` enum('pending','progress','stuck','done') DEFAULT 'pending',
  `tenggat_waktu` date NOT NULL,
  `approval_status` enum('none','pending_approval','approved','rejected') DEFAULT 'none',
  `approval_by` int DEFAULT NULL COMMENT 'Admin yang approve/reject',
  `approval_notes` text COMMENT 'Catatan approval/rejection',
  `approval_date` datetime DEFAULT NULL,
  `request_type` enum('create','edit','delete') DEFAULT NULL,
  `original_task_id` int DEFAULT NULL COMMENT 'ID tugas original jika request edit',
  `progress_percentage` int DEFAULT '0' COMMENT 'Progress 0-100%',
  `is_active` tinyint(1) DEFAULT '1',
  `is_deleted` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `completed_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `department` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `rencana_kerja_backup`
--

INSERT INTO `rencana_kerja_backup` (`id`, `judul_tugas`, `deskripsi`, `created_by`, `assigned_to`, `prioritas`, `status`, `tenggat_waktu`, `approval_status`, `approval_by`, `approval_notes`, `approval_date`, `request_type`, `original_task_id`, `progress_percentage`, `is_active`, `is_deleted`, `created_at`, `updated_at`, `completed_at`, `deleted_at`, `department`) VALUES
(7, 'Update Dashboard Operasional', 'Perbarui tampilan dashboard dengan data terbaru Q1 2025', 1, 1, 'penting_genting', 'progress', '2025-02-05', 'none', NULL, NULL, NULL, NULL, NULL, 60, 1, 0, '2026-02-02 04:56:07', '2026-02-02 07:10:43', NULL, NULL, NULL),
(8, 'Review Laporan Inventory Q4', 'Review dan validasi laporan inventory kuartal 4', 1, 7, 'penting', 'done', '2025-02-01', 'none', NULL, NULL, NULL, NULL, NULL, 100, 1, 0, '2026-02-02 04:56:07', '2026-02-02 07:10:43', NULL, NULL, NULL),
(9, 'Generate Kode Aset Baru', 'Generate kode untuk aset yang baru masuk bulan Januari', 1, 8, 'penting_tidak_genting', 'pending', '2025-02-08', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-02 04:56:07', '2026-02-02 07:10:43', NULL, NULL, NULL),
(10, 'Meeting Koordinasi Tim ACF', 'Koordinasi strategi marketing semester 2', 1, 7, 'penting_genting', 'stuck', '2025-02-07', 'none', NULL, NULL, NULL, NULL, NULL, 30, 1, 0, '2026-02-02 04:56:07', '2026-02-02 07:10:43', NULL, NULL, NULL),
(11, 'Audit Aset Triwulan 1', 'Melakukan audit fisik aset untuk Q1 2025', 1, 8, 'penting', 'pending', '2025-03-01', 'none', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, '2026-02-02 04:56:07', '2026-02-02 07:10:43', NULL, NULL, NULL),
(12, 'dashboard operational', 'manager (asset, kebersihan dan sapras)', 1, 14, 'penting', 'done', '2026-03-19', 'approved', NULL, NULL, '2026-02-02 13:36:16', NULL, NULL, 80, 1, 0, '2026-02-02 06:36:16', '2026-02-04 04:08:50', '2026-02-02 13:53:02', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja_history`
--

CREATE TABLE `rencana_kerja_history` (
  `id` int NOT NULL,
  `task_id` int NOT NULL,
  `user_id` int NOT NULL,
  `action_type` enum('create','edit','delete','status_change','assign','comment','approve','reject') NOT NULL,
  `field_changed` varchar(100) DEFAULT NULL,
  `old_value` text,
  `new_value` text,
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `rencana_kerja_history`
--

INSERT INTO `rencana_kerja_history` (`id`, `task_id`, `user_id`, `action_type`, `field_changed`, `old_value`, `new_value`, `notes`, `created_at`) VALUES
(1, 12, 1, 'create', NULL, NULL, NULL, 'Task created: dashboard operational', '2026-02-02 06:36:16'),
(2, 12, 1, 'edit', NULL, NULL, NULL, 'Task updated: dashboard operational', '2026-02-02 06:53:02');

-- --------------------------------------------------------

--
-- Table structure for table `rencana_kerja_komentar`
--

CREATE TABLE `rencana_kerja_komentar` (
  `id` int NOT NULL,
  `task_id` int NOT NULL,
  `user_id` int NOT NULL,
  `komentar` text NOT NULL,
  `is_edited` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sdm`
--

CREATE TABLE `sdm` (
  `id` int NOT NULL,
  `nip` varchar(50) DEFAULT NULL,
  `nama` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `jenis_kelamin` enum('Laki-laki','Perempuan') DEFAULT NULL,
  `jabatan` varchar(50) DEFAULT NULL,
  `kantor` varchar(100) DEFAULT NULL,
  `no_hp` varchar(20) DEFAULT NULL,
  `status` enum('Aktif','Non-Aktif') DEFAULT 'Aktif',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `sdm`
--

INSERT INTO `sdm` (`id`, `nip`, `nama`, `email`, `jenis_kelamin`, `jabatan`, `kantor`, `no_hp`, `status`, `created_at`) VALUES
(1, 'NIP001', 'Ahmad Fauzi', 'ahmad.fauzi@acfedu.com', 'Laki-laki', 'Manager', 'Kantor Pusat', '081234567890', 'Aktif', '2026-01-28 01:44:06'),
(2, 'NIP002', 'Siti Nurhaliza', 'siti.nurhaliza@acfedu.com', 'Perempuan', 'Staff', 'Kantor Cabang A', '081234567891', 'Aktif', '2026-01-28 01:44:06'),
(3, 'NIP003', 'Budi Santoso', 'budi.santoso@acfedu.com', 'Laki-laki', 'Supervisor', 'Kantor Pusat', '081234567892', 'Aktif', '2026-01-28 01:44:06'),
(4, NULL, 'Rina Wijaya', 'rina@acfedu.com', 'Perempuan', 'Admin', 'Kantor Cabang B', '081234567893', 'Aktif', '2026-01-28 01:44:06');

-- --------------------------------------------------------

--
-- Table structure for table `sekolah`
--

CREATE TABLE `sekolah` (
  `id` int NOT NULL,
  `kode_sekolah` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_sekolah` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kota` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provinsi` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('AKTIF','NONAKTIF') COLLATE utf8mb4_unicode_ci DEFAULT 'AKTIF',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sekolah`
--

INSERT INTO `sekolah` (`id`, `kode_sekolah`, `nama_sekolah`, `kota`, `provinsi`, `status`, `created_at`, `updated_at`) VALUES
(1, 'BATAM', 'SDJ BATAM', 'Batam', 'Kepulauan Riau', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(2, 'CILEGON', 'SDJ CILEGON', 'Cilegon', 'Banten', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(3, 'JAKBAR', 'SDJ JAKBAR', 'Jakarta Barat', 'DKI Jakarta', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(4, 'JAKSEL', 'SDJ JAKSEL', 'Jakarta Selatan', 'DKI Jakarta', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(5, 'JAKTIM', 'SDJ JAKTIM', 'Jakarta Timur', 'DKI Jakarta', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(6, 'JAKUT', 'SDJ JAKUT', 'Jakarta Utara', 'DKI Jakarta', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(7, 'JAYAPURA', 'SDJ JAYAPURA', 'Jayapura', 'Papua', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(8, 'MEDAN', 'SDJ MEDAN', 'Medan', 'Sumatera Utara', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(9, 'SEMARANG', 'SDJ SEMARANG', 'Semarang', 'Jawa Tengah', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(10, 'SURABAYA', 'SDJ SURABAYA', 'Surabaya', 'Jawa Timur', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(11, 'TANGERANG', 'SDJ TANGERANG', 'Tangerang', 'Banten', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(12, 'YOGYAKARTA', 'SDJ YOGYAKARTA', 'Yogyakarta', 'DI Yogyakarta', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(13, 'TKIT-TGR', 'TKIT TANGERANG', 'Tangerang', 'Banten', 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int NOT NULL,
  `setting_key` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `setting_value` text COLLATE utf8mb4_general_ci,
  `setting_type` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'text',
  `description` text COLLATE utf8mb4_general_ci,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `updated_at`) VALUES
(1, 'app_name', 'Sistem Inventory Aset ACF', 'text', 'Nama Aplikasi', '2025-12-17 04:54:08'),
(2, 'app_version', '1.0.0', 'text', 'Versi Aplikasi', '2025-12-17 04:53:09'),
(3, 'company_name', 'Yayasan Pendidikan Anak Ceria', 'text', 'Nama Perusahaan', '2025-12-17 04:53:44'),
(4, 'company_address', 'Jakarta, Indonesia', 'textarea', 'Alamat Perusahaan', '2025-12-17 04:53:09'),
(5, 'company_phone', '021-12345678', 'text', 'Telepon', '2025-12-17 04:53:10'),
(6, 'company_email', 'info@acf.or.id', 'email', 'Email', '2025-12-17 04:53:10'),
(7, 'items_per_page', '15', 'number', 'Jumlah item per halaman', '2025-12-17 04:53:10'),
(8, 'date_format', 'd/m/Y', 'text', 'Format Tanggal (PHP)', '2025-12-17 04:53:10'),
(9, 'currency_format', 'Rp', 'text', 'Format Mata Uang', '2025-12-17 04:53:10'),
(10, 'enable_notifications', '1', 'checkbox', 'Aktifkan Notifikasi', '2025-12-17 04:53:10'),
(11, 'maintenance_mode', '0', 'checkbox', 'Mode Maintenance', '2025-12-17 04:53:10');

-- --------------------------------------------------------

--
-- Table structure for table `sumber_dana`
--

CREATE TABLE `sumber_dana` (
  `id` int NOT NULL,
  `nama_sumber` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `sumber_dana`
--

INSERT INTO `sumber_dana` (`id`, `nama_sumber`, `deskripsi`, `created_at`) VALUES
(1, 'Operasional', 'Dana Operasional', '2025-12-17 02:42:33'),
(2, 'SE', 'Sumber Dana SE', '2025-12-17 02:42:33'),
(3, 'BOS', 'Bantuan Operasional Sekolah', '2025-12-17 02:42:33'),
(4, 'Program', 'Dana Program', '2025-12-17 02:42:33'),
(5, 'Terikat', 'Dana Terikat', '2025-12-17 02:42:33'),
(6, 'DP', 'Dana Program Khusus', '2025-12-17 02:42:33'),
(7, 'Dana Terikat - SE', 'Dana Terikat Sumber SE', '2025-12-17 02:42:33'),
(8, 'Dana Terikat - RZ', 'Dana Terikat RZ', '2025-12-17 02:42:33');

-- --------------------------------------------------------

--
-- Table structure for table `tahun_ajaran`
--

CREATE TABLE `tahun_ajaran` (
  `id` int NOT NULL,
  `tahun_ajaran` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tahun_mulai` year NOT NULL,
  `tahun_selesai` year NOT NULL,
  `bulan_mulai` tinyint DEFAULT '7' COMMENT 'Default: Juli (7)',
  `status` enum('AKTIF','SELESAI','MENDATANG') COLLATE utf8mb4_unicode_ci DEFAULT 'AKTIF',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tahun_ajaran`
--

INSERT INTO `tahun_ajaran` (`id`, `tahun_ajaran`, `tahun_mulai`, `tahun_selesai`, `bulan_mulai`, `status`, `created_at`, `updated_at`) VALUES
(1, '2019-2020', 2019, 2020, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(2, '2020-2021', 2020, 2021, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(3, '2021-2022', 2021, 2022, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(4, '2022-2023', 2022, 2023, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(5, '2023-2024', 2023, 2024, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(6, '2024-2025', 2024, 2025, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(7, '2025-2026', 2025, 2026, 7, 'AKTIF', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(8, '2026-2027', 2026, 2027, 7, 'MENDATANG', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(9, '2027-2028', 2027, 2028, 7, 'MENDATANG', '2026-01-28 03:44:59', '2026-01-28 03:44:59'),
(10, '2019-2025', 2019, 2025, 7, 'SELESAI', '2026-01-28 03:44:59', '2026-01-28 03:44:59');

-- --------------------------------------------------------

--
-- Table structure for table `transaksi`
--

CREATE TABLE `transaksi` (
  `id` int NOT NULL,
  `inventory_id` int NOT NULL,
  `tipe_transaksi` enum('Masuk','Keluar','Pindah','Perbaikan','Penghapusan') COLLATE utf8mb4_general_ci NOT NULL,
  `tanggal_transaksi` date NOT NULL,
  `dari_kantor_id` int DEFAULT NULL,
  `ke_kantor_id` int DEFAULT NULL,
  `jumlah` int DEFAULT '1',
  `keterangan` text COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `transaksi`
--

INSERT INTO `transaksi` (`id`, `inventory_id`, `tipe_transaksi`, `tanggal_transaksi`, `dari_kantor_id`, `ke_kantor_id`, `jumlah`, `keterangan`, `created_by`, `created_at`) VALUES
(3, 52, 'Pindah', '2025-12-18', NULL, 4, 1, 'di alokasikan', 14, '2025-12-18 08:26:41');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password_encrypted` text COLLATE utf8mb4_unicode_ci,
  `encryption_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` enum('admin','director','dept_head','staff','intern') COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `department` enum('Formal Education','Non Formal Education','Operational','Marketing Communication','Finance','Human Resources','IT','Creative Design and Brand') COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `password_encrypted`, `encryption_key`, `full_name`, `role`, `status`, `is_active`, `last_login`, `created_at`, `updated_at`, `department`) VALUES
(1, 'admin', 'admin@acf.com', '$2y$10$7Fo873Q/2W1TLu2wCbon6eGD7NMsqxtO.yjsFvs1q7dC6mvA.T5jO', '27eEGveVB9cvSyKDB5iNlw==', '956b1e07a3d855cadf8ffff56098f4fe', 'Administrator ACF', 'admin', 'active', 1, '2026-02-09 15:11:17', '2025-12-16 02:53:47', '2026-02-09 08:11:17', NULL),
(14, 'kai', 'kylanazwa@gmail.com', '$2y$10$bhJO04zOJhut2Xdlr2ogHuBMkRwF6G3TKcNon5gNDc01cb.xYSRk.', 'Unmofms+jWYP6+zOEKdGfw==', 'd3e1e64fe7642280c1fa6ad3feea30c4', 'kyla nazwa', 'staff', 'active', 1, '2026-02-09 12:25:00', '2025-12-17 05:11:21', '2026-02-09 08:00:31', 'Operational'),
(15, 'ivan', 'ivan@acfeduhub.org', '$2y$10$ypxBa9GNq5SvkGnq4lQw5O4cC0brKq903e4RhQ6d994F0BBcGWoxG', 'zaYisE16OI29xjGmQG5Bng==', '1439f8f5b4635059d8ee6551aed90a25', 'ivan Supangat, S.Pd.I, M.Pd', 'director', 'active', 1, '2026-02-09 12:23:53', '2026-02-04 05:12:11', '2026-02-09 08:04:46', NULL),
(16, 'silka', 'silka@acfeduhub.org', '$2y$10$Oy1I9F.ablluhI/M44I41u6Tyzx7061P.uKEZ1Pd.hI.6VdHbO55C', 'z1+H6m8E4neJvytJW6wJUQ==', 'd43158f63424f71df562d62b6e02956f', 'Silka Shafanisa, S.Psi', 'dept_head', 'active', 1, '2026-02-09 15:09:56', '2026-02-04 06:31:18', '2026-02-09 08:11:34', 'Formal Education'),
(17, 'andri', 'andi@acfeduhub.org', '$2y$10$bm31kLd2ojOcRakXuB9YI.pASdjn2G0EIu4QwPtVKPeecBLwWi2wm', 'S/B0TxZxpzaxvW9c6MkI1w==', 'f74f2b57322ff2d06499d82dde18a8ce', 'Andri Herdiana, S.E', 'staff', 'active', 1, '2026-02-09 15:10:43', '2026-02-04 06:31:18', '2026-02-09 08:11:08', 'Formal Education'),
(18, 'anisa', 'anisa@acfeduhub.org', '$2y$10$VbszqlV7clT871MCBfO79.XwjqQ9OlTwEJncZa0Ui1igN3Z0r9vn2', 'hAIMTud2UUwccT8XcfOLPg==', '777e79608b9d17352e79eab01cd19984', 'Anisa Rahmawati', 'staff', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 08:00:30', 'Formal Education'),
(19, 'helena', 'helena@acfeduhub.org', '$2y$10$5gwn2F3Lxa/J/YcseVhiruHVPb1L/EV4IxqDtU2zAdrBT/9PfYNFO', 'yGwqyDcj0UiSy/I6Bro04w==', 'd1e518852d62794d521b8b29f7df7d6d', 'Helena Anggidesialamia', 'staff', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 08:00:31', 'Formal Education'),
(20, 'mia', 'mia@acfeduhub.org', '$2y$10$bROFwAjwJZoxRcNugVXQQeL3WgyDU2I/FcuRW/Xo6cVCg8tLEkEai', 'ZvvzEeiJRE4t0gyRD7IXJw==', 'd97ed6a791f412ef97929b59c2cef921', 'Mia Nanda Ulpa, S.E', 'dept_head', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:31', 'Operational'),
(21, 'desi', 'desi@acfeduhub.org', '$2y$10$KMq9XzZ.Mo3PMvqlqdDa1eTSr6SBXlDOfElmeNGgzwtiumU7AjR5e', 'MI07MqKP3RSxYxugsrE4gA==', '9ecbfb34cbd832be36d6da51385f428c', 'Desi Eka Mulyati, S.E', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:30', 'Operational'),
(22, 'rinda', 'rinda@acfeduhub.org', '$2y$10$cqWMHzFnkOEsc/5bcuOFFOW49lcj3NYPBb3akQJh.YK3L31rpvbDa', 'fuDslvEKjS2h4BXF+xpQLA==', 'b2d0142e1cc832ca4f2f08f3d9b4c003', 'Rinda Sari', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:31', 'Operational'),
(23, 'freddy', 'freddy@acfeduhub.org', '$2y$10$Iigf/fhDY6ALvr6ZoMfmve/iFMv.LlLNwazP3/QdWQQWNUsR8m3TG', 'f/PyC1VP0zqd4+cw61MmYQ==', '3efe13f12e43998f6fc33e8e30def00f', 'Freddy Yulianto', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:30', 'Operational'),
(24, 'dian', 'dian@acfeduhub.org', '$2y$10$RdM2FHRPjG7ADV/8XMtojeultFwbqT3lx.YVCk9LTlg.rvA3iMNFi', 'cCG7RpDY5A/atWglEkKNuw==', 'ca90623a18a2e5aefee16c9e6cb48a81', 'Dian Rosdian Juhara', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:30', 'Operational'),
(25, 'salamun', 'salamun@acfeduhub.org', '$2y$10$example_hash_here', '/u4vax2qadLQ7Bj+AZm2kg==', '29557e8948f0cf20d5bc76f41104512b', 'Salamun', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 08:00:31', 'Operational'),
(26, 'Gugum', 'gugum@acfeduhub.org', '$2y$10$ylp7rQHfVr.wBDz8/l7F2u/wfIv934.XaTJVj0FdQszqilRIlCRt6', 'sPmqhLXyHkFeT7E9YlyGAw==', '6f7fa14e25ad4ac9f5d12baaae2b689c', 'Gugum Gumantika', 'dept_head', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 08:00:31', 'Non Formal Education'),
(27, 'intan', 'intan@acfeduhub.org', '$2y$10$Cwq4ndqdzY4KIEBWVcAnPuY01vvhexHtT93dJAMLgu6Tdk13rHw5O', '0yb5wYbi1S4itG3M6K/xGw==', 'e78b33c77ab1715b5f2c3dc798c16d1b', 'Intan Lestari, S.E', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 08:00:31', 'Non Formal Education'),
(28, 'febriani', 'ebin@acfeduhub.org', '$2y$10$y/gD4BlrXpEjH0yXnOJ.YeLlLn25KRW8o2p9Gw1YL9N/Nfa9wxLDa', 'T2fiFtxi2RBZgj2DWCiQOQ==', '816090178c0eecef3f60e1fdecbf27ad', 'Febriani Nur Untari, S.Pd', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 08:00:30', 'Non Formal Education'),
(29, 'Ade', 'ade@acfeduhub.org', '$2y$10$QExPvvIuuZ39.wGclXkDDuYRhm.5NiVt2l0FgqOFUYqTWj3FuRRUi', 'wbSm8IgLY03MAZF1sThIjg==', 'a77e036d2d57fbadacfce2572d495494', 'Ade Nurjaman', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 08:06:30', 'Non Formal Education'),
(30, 'iftah', 'iftah@acfeduhub.org', '$2y$10$pA4j6KymyxIRZ5e8c.PQGOPBrEOnV51bv7Rmgiaj4VSJ6a6yny.u2', 'kEySiS+bBEaKp72Y5kdL+A==', 'f593d6cc11a75e70d741a696661afdac', 'Iftah Khaerin, S.Hum, M.M', 'dept_head', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 08:07:15', 'Marketing Communication'),
(31, 'adhitya', 'adhitya@acfeduhub.org', '$2y$10$H9Qqq9D5CQDoZ919wCDh1.geZDnXL4b0fI9v4tvjIrkVXbAmnd1mi', 'vCjMBAAoNeeGwfKrzvWkxQ==', 'e812cc5ffdda84b64bb56314a4a78b0a', 'Adhitya Kamil', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 08:00:30', 'Marketing Communication'),
(32, 'Shaqina', 'shaqina@acfeduhub.org', '$2y$10$3SpXI1oTccCeoka2T/Z5KeCF4Uyu5f7xiX/1T9a4z5Bh5zZttVVjK', 'aR1nUEiU4sLmghybIyGwew==', '94d466d6b5fdb96fb5caf7bd47c28b6a', 'Shaqina', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 08:00:31', 'Marketing Communication'),
(33, 'ichwan', 'ichwan@acfeduhub.org', '$2y$10$fRlhCGZDMLgX323Tyy6WrOARSXe4pc5w6qXNR/NxqeGBHFXgKiO2C', 'lLwebbtFUjvZjQz4P4vB1Q==', '55010f5c11e06e8d943ae5a907e2d41d', 'Ichwan Alfarrizky, S.Ds', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 08:08:03', 'Creative Design and Brand'),
(34, 'dikdik', 'dikdik@acfeduhub.org', '$2y$10$0YSkCAdhQeIE75njcii/EOg52X5JrMe4Fztzip.5eFZg0WQ5DL.z6', 'bhIx8hohUyBWE/wl/xiUKA==', '9fe22a4ca97e9ce161d783887f4510ec', 'Dikdik Awaludin Sidik, S.Ds', 'dept_head', 'active', 1, NULL, '2026-02-09 07:25:44', '2026-02-09 08:00:30', 'Creative Design and Brand');

-- --------------------------------------------------------

--
-- Table structure for table `users_backup`
--

CREATE TABLE `users_backup` (
  `id` int NOT NULL DEFAULT '0',
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` enum('A','M','S') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'S',
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `department` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users_backup`
--

INSERT INTO `users_backup` (`id`, `username`, `email`, `password`, `full_name`, `role`, `status`, `is_active`, `last_login`, `created_at`, `updated_at`, `department`) VALUES
(1, 'admin', 'admin@acf.com', '$2y$10$7Fo873Q/2W1TLu2wCbon6eGD7NMsqxtO.yjsFvs1q7dC6mvA.T5jO', 'Administrator ACF', 'A', 'active', 1, '2025-12-17 13:22:38', '2025-12-16 02:53:47', '2025-12-18 02:29:33', NULL),
(7, 'manager', 'manager@acf.com', '$2y$10$M8BdukpC01J4uICfY5dlaeVU14vDFCBqd7yIBsJ68DqWG2HKOMJzC', 'Manager Inventory', 'M', 'active', 1, NULL, '2025-12-17 02:37:01', '2025-12-18 02:29:33', NULL),
(8, 'staff', 'staff@acf.com', '$2y$10$.SA.QVniOYnEVE.Wm2AykudqoOT4rgvTuD/DKgYSULEJZlmmWb21.', 'Staff Gudang', 'S', 'active', 1, NULL, '2025-12-17 02:37:01', '2025-12-18 02:29:33', NULL),
(14, 'kai', 'kylanazwa@gmail.com', '$2y$10$qQbyZnADHL64izjQ0uYjPeBbwsaUpCBbDpLztoQk32ToWJArupgEq', 'kyla nazwa', 'S', 'active', 1, '2025-12-17 14:58:53', '2025-12-17 05:11:21', '2025-12-17 07:58:53', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_backup_password_20260209`
--

CREATE TABLE `users_backup_password_20260209` (
  `id` int NOT NULL DEFAULT '0',
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` enum('admin','director','dept_head','staff','intern') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `department` enum('Formal Education','Non Formal Education','Operational','Marketing Communication','Finance','Human Resources','IT','Creative Design and Brand') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users_backup_password_20260209`
--

INSERT INTO `users_backup_password_20260209` (`id`, `username`, `email`, `password`, `full_name`, `role`, `status`, `is_active`, `last_login`, `created_at`, `updated_at`, `department`) VALUES
(1, 'admin', 'admin@acf.com', '$2y$10$7Fo873Q/2W1TLu2wCbon6eGD7NMsqxtO.yjsFvs1q7dC6mvA.T5jO', 'Administrator ACF', 'admin', 'active', 1, '2026-02-09 12:28:01', '2025-12-16 02:53:47', '2026-02-09 05:28:01', NULL),
(14, 'kai', 'kylanazwa@gmail.com', '$2y$10$bhJO04zOJhut2Xdlr2ogHuBMkRwF6G3TKcNon5gNDc01cb.xYSRk.', 'kyla nazwa', 'staff', 'active', 1, '2026-02-09 12:25:00', '2025-12-17 05:11:21', '2026-02-09 07:19:49', 'Operational'),
(15, 'ivan', 'iyad@acfeduhub.org', '$2y$10$ypxBa9GNq5SvkGnq4lQw5O4cC0brKq903e4RhQ6d994F0BBcGWoxG', 'ivan Supangat, S.Pd.I, M.Pd', 'director', 'active', 1, '2026-02-09 12:23:53', '2026-02-04 05:12:11', '2026-02-09 05:24:41', NULL),
(16, 'silka', 'sika@acfeduhub.org', '$2y$10$Oy1I9F.ablluhI/M44I41u6Tyzx7061P.uKEZ1Pd.hI.6VdHbO55C', 'Silka Shafanisa, S.Psi', 'dept_head', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 06:49:30', 'Formal Education'),
(17, 'andri', 'andi@acfeduhub.org', '$2y$10$bm31kLd2ojOcRakXuB9YI.pASdjn2G0EIu4QwPtVKPeecBLwWi2wm', 'Andri Herdiana, S.E', 'staff', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 06:50:11', 'Formal Education'),
(18, 'anisa', 'anisa@acfeduhub.org', '$2y$10$VbszqlV7clT871MCBfO79.XwjqQ9OlTwEJncZa0Ui1igN3Z0r9vn2', 'Anisa Rahmawati', 'staff', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 06:51:00', 'Formal Education'),
(19, 'helena', 'helena@acfeduhub.org', '$2y$10$5gwn2F3Lxa/J/YcseVhiruHVPb1L/EV4IxqDtU2zAdrBT/9PfYNFO', 'Helena Anggidesialamia', 'staff', 'active', 1, NULL, '2026-02-04 06:31:18', '2026-02-09 06:51:45', 'Formal Education'),
(20, 'mia', 'mia@acfeduhub.org', '$2y$10$bROFwAjwJZoxRcNugVXQQeL3WgyDU2I/FcuRW/Xo6cVCg8tLEkEai', 'Mia Nanda Ulpa, S.E', 'dept_head', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:16:51', 'Operational'),
(21, 'desi', 'desi@acfeduhub.org', '$2y$10$KMq9XzZ.Mo3PMvqlqdDa1eTSr6SBXlDOfElmeNGgzwtiumU7AjR5e', 'Desi Eka Mulyati, S.E', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:17:26', 'Operational'),
(22, 'rinda', 'rinda@acfeduhub.org', '$2y$10$cqWMHzFnkOEsc/5bcuOFFOW49lcj3NYPBb3akQJh.YK3L31rpvbDa', 'Rinda Sari', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:18:10', 'Operational'),
(23, 'freddy', 'freddy@acfeduhub.org', '$2y$10$Iigf/fhDY6ALvr6ZoMfmve/iFMv.LlLNwazP3/QdWQQWNUsR8m3TG', 'Freddy Yulianto', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:18:35', 'Operational'),
(24, 'dian', 'dian@acfeduhub.org', '$2y$10$RdM2FHRPjG7ADV/8XMtojeultFwbqT3lx.YVCk9LTlg.rvA3iMNFi', 'Dian Rosdian Juhara', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:19:27', 'Operational'),
(25, 'salamun', 'salamun@acfeduhub.org', '$2y$10$example_hash_here', 'Salamun', 'staff', 'active', 1, NULL, '2026-02-04 06:33:52', '2026-02-09 07:19:12', 'Operational'),
(26, 'Gugum', 'gugum@acfeduhub.org', '$2y$10$ylp7rQHfVr.wBDz8/l7F2u/wfIv934.XaTJVj0FdQszqilRIlCRt6', 'Gugum Gumantika', 'dept_head', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 07:13:51', 'Non Formal Education'),
(27, 'intan', 'intan@acfeduhub.org', '$2y$10$Cwq4ndqdzY4KIEBWVcAnPuY01vvhexHtT93dJAMLgu6Tdk13rHw5O', 'Intan Lestari, S.E', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 07:14:32', 'Non Formal Education'),
(28, 'febriani', 'ebin@acfeduhub.org', '$2y$10$y/gD4BlrXpEjH0yXnOJ.YeLlLn25KRW8o2p9Gw1YL9N/Nfa9wxLDa', 'Febriani Nur Untari, S.Pd', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 07:15:13', 'Non Formal Education'),
(29, 'Adi', 'adi@acfeduhub.org', '$2y$10$QExPvvIuuZ39.wGclXkDDuYRhm.5NiVt2l0FgqOFUYqTWj3FuRRUi', 'Adi', 'staff', 'active', 1, NULL, '2026-02-04 06:35:19', '2026-02-09 07:16:06', 'Non Formal Education'),
(30, 'iftah', 'ilosh@acfeduhub.org', '$2y$10$pA4j6KymyxIRZ5e8c.PQGOPBrEOnV51bv7Rmgiaj4VSJ6a6yny.u2', 'Iftah Khairsth, S.Hum, M.M', 'dept_head', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 07:24:01', 'Marketing Communication'),
(31, 'adhitya', 'adhitya@acfeduhub.org', '$2y$10$H9Qqq9D5CQDoZ919wCDh1.geZDnXL4b0fI9v4tvjIrkVXbAmnd1mi', 'Adhitya Kamil', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 07:24:13', 'Marketing Communication'),
(32, 'Shaqina', 'shaqina@acfeduhub.org', '$2y$10$3SpXI1oTccCeoka2T/Z5KeCF4Uyu5f7xiX/1T9a4z5Bh5zZttVVjK', 'Shaqina', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 07:24:34', 'Marketing Communication'),
(33, 'ichwani', 'ichwani@acfeduhub.org', '$2y$10$fRlhCGZDMLgX323Tyy6WrOARSXe4pc5w6qXNR/NxqeGBHFXgKiO2C', 'Ichwani Almoridz, S.Ds', 'staff', 'active', 1, NULL, '2026-02-04 06:36:54', '2026-02-09 07:24:46', 'Creative Design and Brand'),
(34, 'dikdik', 'dikdik@acfeduhub.org', '$2y$10$0YSkCAdhQeIE75njcii/EOg52X5JrMe4Fztzip.5eFZg0WQ5DL.z6', 'Dikdik Awaludin Sidik, S.Ds', 'dept_head', 'active', 1, NULL, '2026-02-09 07:25:44', '2026-02-09 07:25:44', 'Creative Design and Brand');

-- --------------------------------------------------------

--
-- Stand-in structure for view `vw_inventory_detail`
-- (See below for the actual view)
--
CREATE TABLE `vw_inventory_detail` (
`id` int
,`no` int
,`kode_aset` varchar(50)
,`kode_aset_auto` varchar(25)
,`tanggal_perolehan` date
,`jenis_barang` varchar(100)
,`jenis_inventory` text
,`status` enum('aktif','lelang','rusak','hilang','dihapus')
,`harga_perolehan` decimal(15,2)
,`kode_kantor` varchar(10)
,`nama_kantor` varchar(100)
,`kode_kategori` varchar(5)
,`nama_kategori` varchar(50)
,`kode_jenis` varchar(5)
,`nama_jenis` varchar(100)
,`prefix_huruf` char(1)
,`kode_sumber` varchar(5)
,`nama_sumber` varchar(50)
,`nomor_urut` int
,`created_at` timestamp
,`updated_at` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_inventory_by_category`
-- (See below for the actual view)
--
CREATE TABLE `v_inventory_by_category` (
`kategori` varchar(50)
,`total_barang` bigint
,`total_nilai` decimal(37,2)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_inventory_by_office`
-- (See below for the actual view)
--
CREATE TABLE `v_inventory_by_office` (
`kantor` varchar(100)
,`total_barang` bigint
,`total_nilai` decimal(37,2)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_inventory_by_year`
-- (See below for the actual view)
--
CREATE TABLE `v_inventory_by_year` (
`tahun` int
,`jumlah_item` bigint
,`total_nilai` decimal(37,2)
,`rata_rata_harga` decimal(19,6)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_inventory_statistics`
-- (See below for the actual view)
--
CREATE TABLE `v_inventory_statistics` (
`total_item` bigint
,`total_nilai_aset` decimal(37,2)
,`tanggal_terlama` date
,`tanggal_terbaru` date
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_kepatuhan_per_sekolah`
-- (See below for the actual view)
--
CREATE TABLE `v_kepatuhan_per_sekolah` (
`sekolah_id` int
,`kode_sekolah` varchar(20)
,`nama_sekolah` varchar(100)
,`kota` varchar(50)
,`tahun_ajaran_id` int
,`tahun_ajaran` varchar(20)
,`jenis_pembayaran_id` int
,`kode_pembayaran` varchar(20)
,`nama_pembayaran` varchar(100)
,`kategori_siswa_id` int
,`kode_kategori` varchar(20)
,`nama_kategori` varchar(50)
,`target_tahunan` decimal(15,2)
,`capaian_tahunan` decimal(15,2)
,`piutang_tahunan` decimal(15,2)
,`persentase_capaian` decimal(5,2)
,`kategori_kepatuhan` varchar(20)
,`bulan_data` varchar(50)
,`created_at` timestamp
,`updated_at` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_pembayaran_bulanan`
-- (See below for the actual view)
--
CREATE TABLE `v_pembayaran_bulanan` (
`sekolah_id` int
,`kode_sekolah` varchar(20)
,`nama_sekolah` varchar(100)
,`tahun_ajaran` varchar(20)
,`kode_pembayaran` varchar(20)
,`nama_pembayaran` varchar(100)
,`kode_kategori` varchar(20)
,`nama_kategori` varchar(50)
,`bulan` tinyint
,`nama_bulan` varchar(20)
,`target_bulanan` decimal(15,2)
,`capaian_bulanan` decimal(15,2)
,`piutang_bulanan` decimal(15,2)
,`persentase_capaian` decimal(5,2)
,`kategori_kepatuhan` varchar(20)
,`created_at` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_rencana_kerja_list`
-- (See below for the actual view)
--
CREATE TABLE `v_rencana_kerja_list` (
`id` int
,`judul_tugas` varchar(255)
,`prioritas` enum('penting_genting','penting','penting_tidak_genting')
,`status` enum('pending','progress','stuck','done')
,`approval_status` enum('none','pending_approval','approved','rejected')
,`tenggat_waktu` date
,`progress_percentage` int
,`creator_name` varchar(100)
,`assigned_name` varchar(100)
,`due_status` varchar(7)
,`created_at` timestamp
,`updated_at` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_summary_kepatuhan_ta`
-- (See below for the actual view)
--
CREATE TABLE `v_summary_kepatuhan_ta` (
`tahun_ajaran` varchar(20)
,`kode_pembayaran` varchar(20)
,`nama_pembayaran` varchar(100)
,`kode_kategori` varchar(20)
,`total_sekolah` bigint
,`total_target` decimal(37,2)
,`total_capaian` decimal(37,2)
,`total_piutang` decimal(37,2)
,`rata_rata_persentase` decimal(6,2)
,`jumlah_excellent` decimal(23,0)
,`jumlah_good` decimal(23,0)
,`jumlah_average` decimal(23,0)
,`jumlah_poor` decimal(23,0)
);

-- --------------------------------------------------------

--
-- Structure for view `vw_inventory_detail`
--
DROP TABLE IF EXISTS `vw_inventory_detail`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vw_inventory_detail`  AS SELECT `i`.`id` AS `id`, `i`.`no` AS `no`, `i`.`kode_aset` AS `kode_aset`, `i`.`kode_aset_auto` AS `kode_aset_auto`, `i`.`tanggal_perolehan` AS `tanggal_perolehan`, `i`.`jenis_barang` AS `jenis_barang`, `i`.`jenis_inventory` AS `jenis_inventory`, `i`.`status` AS `status`, `i`.`harga_perolehan` AS `harga_perolehan`, `rk`.`kode_kantor` AS `kode_kantor`, `rk`.`nama_kantor` AS `nama_kantor`, `rkat`.`kode_kategori` AS `kode_kategori`, `rkat`.`nama_kategori` AS `nama_kategori`, `rja`.`kode_jenis` AS `kode_jenis`, `rja`.`nama_jenis` AS `nama_jenis`, `rja`.`prefix_huruf` AS `prefix_huruf`, `rsd`.`kode_sumber` AS `kode_sumber`, `rsd`.`nama_sumber` AS `nama_sumber`, `i`.`nomor_urut` AS `nomor_urut`, `i`.`created_at` AS `created_at`, `i`.`updated_at` AS `updated_at` FROM ((((`inventory` `i` left join `ref_kantor` `rk` on((`i`.`id_kantor` = `rk`.`id`))) left join `ref_kategori` `rkat` on((`i`.`id_kategori` = `rkat`.`id`))) left join `ref_jenis_asset` `rja` on((`i`.`id_jenis_asset` = `rja`.`id`))) left join `ref_sumber_dana` `rsd` on((`i`.`id_sumber_dana` = `rsd`.`id`))) ORDER BY `i`.`created_at` AS `DESCdesc` ASC  ;

-- --------------------------------------------------------

--
-- Structure for view `v_inventory_by_category`
--
DROP TABLE IF EXISTS `v_inventory_by_category`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_inventory_by_category`  AS SELECT `inventory`.`kategori` AS `kategori`, count(`inventory`.`id`) AS `total_barang`, sum(`inventory`.`harga_perolehan`) AS `total_nilai` FROM `inventory` GROUP BY `inventory`.`kategori``kategori`  ;

-- --------------------------------------------------------

--
-- Structure for view `v_inventory_by_office`
--
DROP TABLE IF EXISTS `v_inventory_by_office`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_inventory_by_office`  AS SELECT `inventory`.`kantor` AS `kantor`, count(`inventory`.`id`) AS `total_barang`, sum(`inventory`.`harga_perolehan`) AS `total_nilai` FROM `inventory` GROUP BY `inventory`.`kantor``kantor`  ;

-- --------------------------------------------------------

--
-- Structure for view `v_inventory_by_year`
--
DROP TABLE IF EXISTS `v_inventory_by_year`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_inventory_by_year`  AS SELECT year(`inventory`.`tanggal_perolehan`) AS `tahun`, count(0) AS `jumlah_item`, sum(`inventory`.`harga_perolehan`) AS `total_nilai`, avg(`inventory`.`harga_perolehan`) AS `rata_rata_harga` FROM `inventory` GROUP BY year(`inventory`.`tanggal_perolehan`) ORDER BY year(`inventory`.`tanggal_perolehan`) AS `DESCdesc` ASC  ;

-- --------------------------------------------------------

--
-- Structure for view `v_inventory_statistics`
--
DROP TABLE IF EXISTS `v_inventory_statistics`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_inventory_statistics`  AS SELECT count(0) AS `total_item`, sum(`inventory`.`harga_perolehan`) AS `total_nilai_aset`, min(`inventory`.`tanggal_perolehan`) AS `tanggal_terlama`, max(`inventory`.`tanggal_perolehan`) AS `tanggal_terbaru` FROM `inventory``inventory`  ;

-- --------------------------------------------------------

--
-- Structure for view `v_kepatuhan_per_sekolah`
--
DROP TABLE IF EXISTS `v_kepatuhan_per_sekolah`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_kepatuhan_per_sekolah`  AS SELECT `s`.`id` AS `sekolah_id`, `s`.`kode_sekolah` AS `kode_sekolah`, `s`.`nama_sekolah` AS `nama_sekolah`, `s`.`kota` AS `kota`, `ta`.`id` AS `tahun_ajaran_id`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `jp`.`id` AS `jenis_pembayaran_id`, `jp`.`kode_pembayaran` AS `kode_pembayaran`, `jp`.`nama_pembayaran` AS `nama_pembayaran`, `ks`.`id` AS `kategori_siswa_id`, `ks`.`kode_kategori` AS `kode_kategori`, `ks`.`nama_kategori` AS `nama_kategori`, `pt`.`target_tahunan` AS `target_tahunan`, `pt`.`capaian_tahunan` AS `capaian_tahunan`, `pt`.`piutang_tahunan` AS `piutang_tahunan`, `pt`.`persentase_capaian` AS `persentase_capaian`, `pt`.`kategori_kepatuhan` AS `kategori_kepatuhan`, `pt`.`bulan_data` AS `bulan_data`, `pt`.`created_at` AS `created_at`, `pt`.`updated_at` AS `updated_at` FROM ((((`pembayaran_tahunan` `pt` join `sekolah` `s` on((`pt`.`sekolah_id` = `s`.`id`))) join `tahun_ajaran` `ta` on((`pt`.`tahun_ajaran_id` = `ta`.`id`))) join `jenis_pembayaran` `jp` on((`pt`.`jenis_pembayaran_id` = `jp`.`id`))) join `kategori_siswa` `ks` on((`pt`.`kategori_siswa_id` = `ks`.`id`))) WHERE (`s`.`status` = 'AKTIF')  ;

-- --------------------------------------------------------

--
-- Structure for view `v_pembayaran_bulanan`
--
DROP TABLE IF EXISTS `v_pembayaran_bulanan`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_pembayaran_bulanan`  AS SELECT `s`.`id` AS `sekolah_id`, `s`.`kode_sekolah` AS `kode_sekolah`, `s`.`nama_sekolah` AS `nama_sekolah`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `jp`.`kode_pembayaran` AS `kode_pembayaran`, `jp`.`nama_pembayaran` AS `nama_pembayaran`, `ks`.`kode_kategori` AS `kode_kategori`, `ks`.`nama_kategori` AS `nama_kategori`, `pb`.`bulan` AS `bulan`, `pb`.`nama_bulan` AS `nama_bulan`, `pb`.`target_bulanan` AS `target_bulanan`, `pb`.`capaian_bulanan` AS `capaian_bulanan`, `pb`.`piutang_bulanan` AS `piutang_bulanan`, `pb`.`persentase_capaian` AS `persentase_capaian`, `pb`.`kategori_kepatuhan` AS `kategori_kepatuhan`, `pb`.`created_at` AS `created_at` FROM (((((`pembayaran_bulanan` `pb` join `pembayaran_tahunan` `pt` on((`pb`.`pembayaran_tahunan_id` = `pt`.`id`))) join `sekolah` `s` on((`pt`.`sekolah_id` = `s`.`id`))) join `tahun_ajaran` `ta` on((`pt`.`tahun_ajaran_id` = `ta`.`id`))) join `jenis_pembayaran` `jp` on((`pt`.`jenis_pembayaran_id` = `jp`.`id`))) join `kategori_siswa` `ks` on((`pt`.`kategori_siswa_id` = `ks`.`id`))) WHERE (`s`.`status` = 'AKTIF') ORDER BY `ta`.`tahun_ajaran` ASC, `s`.`nama_sekolah` ASC, `jp`.`kode_pembayaran` ASC, `pb`.`bulan` ASC  ;

-- --------------------------------------------------------

--
-- Structure for view `v_rencana_kerja_list`
--
DROP TABLE IF EXISTS `v_rencana_kerja_list`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_rencana_kerja_list`  AS SELECT `rk`.`id` AS `id`, `rk`.`judul_tugas` AS `judul_tugas`, `rk`.`prioritas` AS `prioritas`, `rk`.`status` AS `status`, `rk`.`approval_status` AS `approval_status`, `rk`.`tenggat_waktu` AS `tenggat_waktu`, `rk`.`progress_percentage` AS `progress_percentage`, `u1`.`full_name` AS `creator_name`, `u2`.`full_name` AS `assigned_name`, (case when ((`rk`.`tenggat_waktu` < curdate()) and (`rk`.`status` <> 'done')) then 'overdue' when ((`rk`.`tenggat_waktu` = curdate()) and (`rk`.`status` <> 'done')) then 'today' else 'normal' end) AS `due_status`, `rk`.`created_at` AS `created_at`, `rk`.`updated_at` AS `updated_at` FROM ((`rencana_kerja` `rk` left join `users` `u1` on((`rk`.`created_by` = `u1`.`id`))) left join `users` `u2` on((`rk`.`assigned_to` = `u2`.`id`))) WHERE (`rk`.`is_deleted` = 0)  ;

-- --------------------------------------------------------

--
-- Structure for view `v_summary_kepatuhan_ta`
--
DROP TABLE IF EXISTS `v_summary_kepatuhan_ta`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_summary_kepatuhan_ta`  AS SELECT `ta`.`tahun_ajaran` AS `tahun_ajaran`, `jp`.`kode_pembayaran` AS `kode_pembayaran`, `jp`.`nama_pembayaran` AS `nama_pembayaran`, `ks`.`kode_kategori` AS `kode_kategori`, count(0) AS `total_sekolah`, sum(`pt`.`target_tahunan`) AS `total_target`, sum(`pt`.`capaian_tahunan`) AS `total_capaian`, sum(`pt`.`piutang_tahunan`) AS `total_piutang`, round(avg(`pt`.`persentase_capaian`),2) AS `rata_rata_persentase`, sum((case when (`pt`.`kategori_kepatuhan` = 'EXCELLENT') then 1 else 0 end)) AS `jumlah_excellent`, sum((case when (`pt`.`kategori_kepatuhan` = 'GOOD') then 1 else 0 end)) AS `jumlah_good`, sum((case when (`pt`.`kategori_kepatuhan` = 'AVERAGE') then 1 else 0 end)) AS `jumlah_average`, sum((case when (`pt`.`kategori_kepatuhan` = 'POOR') then 1 else 0 end)) AS `jumlah_poor` FROM ((((`pembayaran_tahunan` `pt` join `tahun_ajaran` `ta` on((`pt`.`tahun_ajaran_id` = `ta`.`id`))) join `jenis_pembayaran` `jp` on((`pt`.`jenis_pembayaran_id` = `jp`.`id`))) join `kategori_siswa` `ks` on((`pt`.`kategori_siswa_id` = `ks`.`id`))) join `sekolah` `s` on((`pt`.`sekolah_id` = `s`.`id`))) WHERE (`s`.`status` = 'AKTIF') GROUP BY `ta`.`tahun_ajaran`, `jp`.`kode_pembayaran`, `jp`.`nama_pembayaran`, `ks`.`kode_kategori` ORDER BY `ta`.`tahun_ajaran` ASC, `jp`.`kode_pembayaran` ASC  ;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `activity_log`
--
ALTER TABLE `activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `inventory`
--
ALTER TABLE `inventory`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_kategori` (`kategori`),
  ADD KEY `idx_kantor` (`kantor`),
  ADD KEY `idx_sumber_dana` (`sumber_dana`),
  ADD KEY `idx_jenis_barang` (`jenis_barang`),
  ADD KEY `idx_tanggal` (`tanggal_perolehan`),
  ADD KEY `idx_harga` (`harga_perolehan`),
  ADD KEY `idx_inventory_kode_auto` (`kode_aset_auto`),
  ADD KEY `idx_inventory_kantor` (`id_kantor`),
  ADD KEY `idx_inventory_kategori` (`id_kategori`),
  ADD KEY `idx_inventory_jenis` (`id_jenis_asset`),
  ADD KEY `fk_inventory_sumber` (`id_sumber_dana`),
  ADD KEY `idx_kode_aset_auto` (`kode_aset_auto`);

--
-- Indexes for table `jenis_asset`
--
ALTER TABLE `jenis_asset`
  ADD PRIMARY KEY (`id_jenis`);

--
-- Indexes for table `jenis_barang`
--
ALTER TABLE `jenis_barang`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_jenis_kategori` (`kategori_id`);

--
-- Indexes for table `jenis_pembayaran`
--
ALTER TABLE `jenis_pembayaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_pembayaran` (`kode_pembayaran`),
  ADD KEY `idx_kode` (`kode_pembayaran`);

--
-- Indexes for table `kantor`
--
ALTER TABLE `kantor`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `kategori`
--
ALTER TABLE `kategori`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `kategori_pembayaran`
--
ALTER TABLE `kategori_pembayaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode` (`kode`);

--
-- Indexes for table `kategori_siswa`
--
ALTER TABLE `kategori_siswa`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_kategori` (`kode_kategori`),
  ADD KEY `idx_kode` (`kode_kategori`);

--
-- Indexes for table `kepatuhan_pembayaran`
--
ALTER TABLE `kepatuhan_pembayaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_dashboard` (`ta`,`period`,`category`,`month`),
  ADD KEY `idx_period` (`period`),
  ADD KEY `idx_category` (`category`),
  ADD KEY `idx_month` (`month`);

--
-- Indexes for table `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_log_user` (`user_id`);

--
-- Indexes for table `lokasi`
--
ALTER TABLE `lokasi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `pembayaran_bulanan`
--
ALTER TABLE `pembayaran_bulanan`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_monthly` (`pembayaran_tahunan_id`,`bulan`),
  ADD KEY `idx_bulan` (`bulan`),
  ADD KEY `idx_tahunan` (`pembayaran_tahunan_id`),
  ADD KEY `idx_pb_composite` (`pembayaran_tahunan_id`,`bulan`);

--
-- Indexes for table `pembayaran_tahunan`
--
ALTER TABLE `pembayaran_tahunan`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_payment` (`sekolah_id`,`tahun_ajaran_id`,`jenis_pembayaran_id`,`kategori_siswa_id`),
  ADD KEY `idx_sekolah` (`sekolah_id`),
  ADD KEY `idx_ta` (`tahun_ajaran_id`),
  ADD KEY `idx_jenis` (`jenis_pembayaran_id`),
  ADD KEY `idx_kategori_siswa` (`kategori_siswa_id`),
  ADD KEY `idx_kategori_kepatuhan` (`kategori_kepatuhan`),
  ADD KEY `idx_pt_composite` (`tahun_ajaran_id`,`jenis_pembayaran_id`,`kategori_siswa_id`);

--
-- Indexes for table `periode`
--
ALTER TABLE `periode`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ref_jenis_asset`
--
ALTER TABLE `ref_jenis_asset`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_jenis` (`kode_jenis`),
  ADD KEY `idx_kode` (`kode_jenis`),
  ADD KEY `idx_kategori` (`id_kategori`);

--
-- Indexes for table `ref_kantor`
--
ALTER TABLE `ref_kantor`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_kantor` (`kode_kantor`),
  ADD KEY `idx_kode` (`kode_kantor`);

--
-- Indexes for table `ref_kategori`
--
ALTER TABLE `ref_kategori`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_kategori` (`kode_kategori`),
  ADD KEY `idx_kode` (`kode_kategori`),
  ADD KEY `idx_nomor` (`nomor_kategori`);

--
-- Indexes for table `ref_sumber_dana`
--
ALTER TABLE `ref_sumber_dana`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_sumber` (`kode_sumber`),
  ADD KEY `idx_kode` (`kode_sumber`),
  ADD KEY `idx_nomor` (`nomor_sumber`);

--
-- Indexes for table `rencana_kerja`
--
ALTER TABLE `rencana_kerja`
  ADD PRIMARY KEY (`id`),
  ADD KEY `approval_by` (`approval_by`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_assigned` (`assigned_to`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `idx_approval` (`approval_status`),
  ADD KEY `idx_tenggat` (`tenggat_waktu`),
  ADD KEY `idx_department` (`department`),
  ADD KEY `fk_deleted_by_user` (`deleted_by`);

--
-- Indexes for table `rencana_kerja_anggota`
--
ALTER TABLE `rencana_kerja_anggota`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_task_member` (`task_id`,`user_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `rencana_kerja_attachment`
--
ALTER TABLE `rencana_kerja_attachment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uploaded_by` (`uploaded_by`),
  ADD KEY `idx_task_attachment` (`task_id`);

--
-- Indexes for table `rencana_kerja_history`
--
ALTER TABLE `rencana_kerja_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_task_history` (`task_id`),
  ADD KEY `idx_action` (`action_type`);

--
-- Indexes for table `rencana_kerja_komentar`
--
ALTER TABLE `rencana_kerja_komentar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_task` (`task_id`);

--
-- Indexes for table `sdm`
--
ALTER TABLE `sdm`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sekolah`
--
ALTER TABLE `sekolah`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_sekolah` (`kode_sekolah`),
  ADD KEY `idx_kode` (`kode_sekolah`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `sumber_dana`
--
ALTER TABLE `sumber_dana`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `tahun_ajaran` (`tahun_ajaran`),
  ADD KEY `idx_tahun` (`tahun_ajaran`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `transaksi`
--
ALTER TABLE `transaksi`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_trx_inventory` (`inventory_id`),
  ADD KEY `fk_trx_dari_kantor` (`dari_kantor_id`),
  ADD KEY `fk_trx_ke_kantor` (`ke_kantor_id`),
  ADD KEY `fk_trx_user` (`created_by`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `activity_log`
--
ALTER TABLE `activity_log`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=110;

--
-- AUTO_INCREMENT for table `inventory`
--
ALTER TABLE `inventory`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=56;

--
-- AUTO_INCREMENT for table `jenis_asset`
--
ALTER TABLE `jenis_asset`
  MODIFY `id_jenis` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `jenis_barang`
--
ALTER TABLE `jenis_barang`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `jenis_pembayaran`
--
ALTER TABLE `jenis_pembayaran`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `kantor`
--
ALTER TABLE `kantor`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `kategori`
--
ALTER TABLE `kategori`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `kategori_pembayaran`
--
ALTER TABLE `kategori_pembayaran`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `kategori_siswa`
--
ALTER TABLE `kategori_siswa`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `kepatuhan_pembayaran`
--
ALTER TABLE `kepatuhan_pembayaran`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=186;

--
-- AUTO_INCREMENT for table `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=325;

--
-- AUTO_INCREMENT for table `lokasi`
--
ALTER TABLE `lokasi`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `pembayaran_bulanan`
--
ALTER TABLE `pembayaran_bulanan`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `pembayaran_tahunan`
--
ALTER TABLE `pembayaran_tahunan`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `periode`
--
ALTER TABLE `periode`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ref_jenis_asset`
--
ALTER TABLE `ref_jenis_asset`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;

--
-- AUTO_INCREMENT for table `ref_kantor`
--
ALTER TABLE `ref_kantor`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `ref_kategori`
--
ALTER TABLE `ref_kategori`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `ref_sumber_dana`
--
ALTER TABLE `ref_sumber_dana`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `rencana_kerja`
--
ALTER TABLE `rencana_kerja`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=50;

--
-- AUTO_INCREMENT for table `rencana_kerja_anggota`
--
ALTER TABLE `rencana_kerja_anggota`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rencana_kerja_attachment`
--
ALTER TABLE `rencana_kerja_attachment`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rencana_kerja_history`
--
ALTER TABLE `rencana_kerja_history`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `rencana_kerja_komentar`
--
ALTER TABLE `rencana_kerja_komentar`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sdm`
--
ALTER TABLE `sdm`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `sekolah`
--
ALTER TABLE `sekolah`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `sumber_dana`
--
ALTER TABLE `sumber_dana`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `transaksi`
--
ALTER TABLE `transaksi`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=35;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `activity_log`
--
ALTER TABLE `activity_log`
  ADD CONSTRAINT `activity_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `inventory`
--
ALTER TABLE `inventory`
  ADD CONSTRAINT `fk_inventory_jenis` FOREIGN KEY (`id_jenis_asset`) REFERENCES `ref_jenis_asset` (`id`),
  ADD CONSTRAINT `fk_inventory_kantor` FOREIGN KEY (`id_kantor`) REFERENCES `ref_kantor` (`id`),
  ADD CONSTRAINT `fk_inventory_kategori` FOREIGN KEY (`id_kategori`) REFERENCES `ref_kategori` (`id`),
  ADD CONSTRAINT `fk_inventory_sumber` FOREIGN KEY (`id_sumber_dana`) REFERENCES `ref_sumber_dana` (`id`);

--
-- Constraints for table `jenis_barang`
--
ALTER TABLE `jenis_barang`
  ADD CONSTRAINT `fk_jenis_kategori` FOREIGN KEY (`kategori_id`) REFERENCES `kategori` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD CONSTRAINT `fk_log_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `pembayaran_bulanan`
--
ALTER TABLE `pembayaran_bulanan`
  ADD CONSTRAINT `pembayaran_bulanan_ibfk_1` FOREIGN KEY (`pembayaran_tahunan_id`) REFERENCES `pembayaran_tahunan` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `pembayaran_tahunan`
--
ALTER TABLE `pembayaran_tahunan`
  ADD CONSTRAINT `pembayaran_tahunan_ibfk_1` FOREIGN KEY (`sekolah_id`) REFERENCES `sekolah` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `pembayaran_tahunan_ibfk_2` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `pembayaran_tahunan_ibfk_3` FOREIGN KEY (`jenis_pembayaran_id`) REFERENCES `jenis_pembayaran` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `pembayaran_tahunan_ibfk_4` FOREIGN KEY (`kategori_siswa_id`) REFERENCES `kategori_siswa` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ref_jenis_asset`
--
ALTER TABLE `ref_jenis_asset`
  ADD CONSTRAINT `ref_jenis_asset_ibfk_1` FOREIGN KEY (`id_kategori`) REFERENCES `ref_kategori` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rencana_kerja`
--
ALTER TABLE `rencana_kerja`
  ADD CONSTRAINT `fk_deleted_by_user` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `rencana_kerja_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_ibfk_3` FOREIGN KEY (`approval_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `rencana_kerja_anggota`
--
ALTER TABLE `rencana_kerja_anggota`
  ADD CONSTRAINT `rencana_kerja_anggota_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `rencana_kerja` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_anggota_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rencana_kerja_attachment`
--
ALTER TABLE `rencana_kerja_attachment`
  ADD CONSTRAINT `rencana_kerja_attachment_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `rencana_kerja` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_attachment_ibfk_2` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rencana_kerja_history`
--
ALTER TABLE `rencana_kerja_history`
  ADD CONSTRAINT `rencana_kerja_history_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `rencana_kerja` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_history_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rencana_kerja_komentar`
--
ALTER TABLE `rencana_kerja_komentar`
  ADD CONSTRAINT `rencana_kerja_komentar_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `rencana_kerja` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rencana_kerja_komentar_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transaksi`
--
ALTER TABLE `transaksi`
  ADD CONSTRAINT `fk_trx_dari_kantor` FOREIGN KEY (`dari_kantor_id`) REFERENCES `kantor` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_trx_inventory` FOREIGN KEY (`inventory_id`) REFERENCES `inventory` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_trx_ke_kantor` FOREIGN KEY (`ke_kantor_id`) REFERENCES `kantor` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_trx_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
