<?php
/* ========================
   AUTH ADMIN/MANAGER
   Path: /auth/auth_admin.php
======================== */

// Start session jika belum
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* ========================
   CEK LOGIN
======================== */
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../index.html?error=session");
    exit;
}

/* ========================
   NORMALISASI ROLE
======================== */
$role = strtoupper(trim($_SESSION['role'] ?? $_SESSION['user_type'] ?? ''));

/* ========================
   VALIDASI ADMIN/MANAGER
======================== */
if (!in_array($role, ['A', 'M'], true)) {
    // Redirect staff ke halaman staff
    if ($role === 'S') {
        header("Location: ../pages/staff/home_staff.php");
    } else {
        header("Location: ../index.html?error=forbidden");
    }
    exit;
}

// Optional: Set timezone
date_default_timezone_set('Asia/Jakarta');