<?php
// Set session configuration SEBELUM session_start()
ini_set('session.cookie_path', '/');
ini_set('session.cookie_httponly', 1);

// Baru kemudian start session
session_start();

/* ===============================
   1. VALIDASI SESSION
================================ */
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: index.html?error=session");
    exit;
}

if (!isset($_SESSION['role'])) {
    session_destroy();
    header("Location: index.html?error=no_role");
    exit;
}

/* ===============================
   2. NORMALISASI ROLE & USER
================================ */
// Simpan role asli dari database
$originalRole = trim($_SESSION['role']);

// Map role untuk keperluan dashboard
$roleMapping = [
    'A' => 'admin',
    'admin' => 'admin',
    'D' => 'director',
    'director' => 'director',
    'DH' => 'dept_head',
    'dept_head' => 'dept_head',
    'M' => 'dept_head', // Manager = Department Head
    'S' => 'staff',
    'staff' => 'staff'
];

$userRole = strtolower($roleMapping[$originalRole] ?? $originalRole);
$userName = $_SESSION['full_name'] ?? $_SESSION['nama'] ?? $_SESSION['username'] ?? 'User';

$allowedRoles = ['admin', 'director', 'dept_head', 'staff'];
if (!in_array($userRole, $allowedRoles, true)) {
    session_destroy();
    header("Location: index.html?error=invalid_role");
    exit;
}

/* ===============================
   3. TEMA & ROLE
================================ */
$roleNames = [
    'admin' => 'Administrator',
    'director' => 'Direktur',
    'dept_head' => 'Kepala Departemen',
    'staff' => 'Staff'
];

$roleColors = [
    'admin' => '#4D869C',
    'director' => '#8B5CF6',
    'dept_head' => '#3B82F6',
    'staff' => '#64748b'
];

$roleName  = $roleNames[$userRole];
$roleColor = $roleColors[$userRole];

/* ===============================
   4. HALAMAN DEFAULT
================================ */
$defaultPages = [
    'admin' => 'pages/admin/home_admin.php',
    'director' => 'pages/director/home_director.php',
    'dept_head' => 'pages/manager/home_manager.php',
    'staff' => 'pages/staff/home_staff.php'
];

$defaultPage = $defaultPages[$userRole];

/* ===============================
   5. TANGGAL INDONESIA
================================ */
function formatTanggalIndonesia($timestamp = null) {
    $timestamp ??= time();

    $hari = [
        'Sunday'=>'Minggu','Monday'=>'Senin','Tuesday'=>'Selasa',
        'Wednesday'=>'Rabu','Thursday'=>'Kamis','Friday'=>'Jumat','Saturday'=>'Sabtu'
    ];

    $bulan = [
        'January'=>'Januari','February'=>'Februari','March'=>'Maret',
        'April'=>'April','May'=>'Mei','June'=>'Juni',
        'July'=>'Juli','August'=>'Agustus','September'=>'September',
        'October'=>'Oktober','November'=>'November','December'=>'Desember'
    ];

    return $hari[date('l',$timestamp)].', '.date('d',$timestamp).' '.$bulan[date('F',$timestamp)].' '.date('Y',$timestamp);
}

$currentDate = formatTanggalIndonesia();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Modern Color Palette */
            --bg-primary: #ffffff;
            --bg-secondary: #f7f7f5;
            --bg-hover: #f1f1ef;
            --border-color: #e3e2e0;
            --text-primary: #37352f;
            --text-secondary: #787774;
            --text-tertiary: #9b9a97;
            
            /* ACF Theme Colors */
            --acf-teal: #7AB2B2;
            --acf-dark-teal: #4D869C;
            --acf-mint: #CDE8E5;
            --acf-light-blue: #EEF7FF;
            
            /* Dynamic Role Colors */
            --role-color: <?= $roleColor; ?>;
            --role-color-light: <?= $roleColor; ?>20;
            
            --sidebar-width: 260px;
            --header-height: 70px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IBM Plex Sans', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            overflow: hidden;
            height: 100vh;
        }

        /* ===== MODERN SIDEBAR ===== */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--bg-primary);
            border-right: 1px solid var(--border-color);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }

        .sidebar.collapsed {
            width: 72px;
        }

        /* ✅ Workspace Header - Simplified (No Dropdown) */
        .workspace-header {
            padding: 16px;
            border-bottom: 1px solid var(--border-color);
        }

        .workspace-select {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 12px;
            background: var(--bg-hover);
            border-radius: 6px;
            transition: all 0.15s;
        }

        .workspace-select img {
            width: 24px;
            height: 24px;
            object-fit: contain;
            flex-shrink: 0;
        }

        .workspace-name {
            flex: 1;
            text-align: left;
            font-size: 14px;
            font-weight: 600;
            color: var(--text-primary);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .sidebar.collapsed .workspace-name {
            display: none;
        }

        .sidebar.collapsed .workspace-select {
            justify-content: center;
            padding: 10px;
        }

        /* User Card */
        .user-card {
            margin: 12px;
            padding: 12px;
            background: var(--role-color-light);
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 10px;
            border-left: 3px solid var(--role-color);
            transition: all 0.2s;
        }

        .user-card:hover {
            background: var(--bg-hover);
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            background: var(--role-color);
            color: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 14px;
            flex-shrink: 0;
        }

        .user-info {
            flex: 1;
            min-width: 0;
        }

        .user-name {
            font-weight: 700;
            font-size: 13px;
            color: var(--text-primary);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .user-role {
            font-size: 11px;
            color: var(--role-color);
            font-weight: 600;
            margin-top: 2px;
        }

        .sidebar.collapsed .user-card {
            padding: 10px;
            justify-content: center;
            border-left: none;
        }

        .sidebar.collapsed .user-info {
            display: none;
        }

        /* Navigation Menu */
        .sidebar-menu {
            flex: 1;
            overflow-y: auto;
            padding: 8px 0;
        }

        .sidebar-menu::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar-menu::-webkit-scrollbar-thumb {
            background: var(--border-color);
            border-radius: 10px;
        }

        .menu-section-title {
            padding: 12px 16px 6px;
            font-size: 11px;
            font-weight: 700;
            color: var(--text-tertiary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .sidebar.collapsed .menu-section-title {
            display: none;
        }

        .menu-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 16px;
            margin: 2px 8px;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 6px;
            transition: all 0.15s;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
        }

        .menu-item i {
            width: 20px;
            text-align: center;
            font-size: 16px;
            color: var(--text-tertiary);
            transition: 0.15s;
            flex-shrink: 0;
        }

        .menu-item:hover {
            background: var(--bg-hover);
            color: var(--text-primary);
        }

        .menu-item:hover i {
            color: var(--acf-teal);
        }

        .menu-item.active {
            background: var(--acf-teal);
            color: white;
            font-weight: 600;
        }

        .menu-item.active i {
            color: white;
        }

        .sidebar.collapsed .menu-item {
            justify-content: center;
            padding: 10px;
        }

        .sidebar.collapsed .menu-item span {
            display: none;
        }

        /* Dropdown Menu */
        .menu-item-parent {
            cursor: pointer;
        }

        .menu-item-parent .menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .menu-badge {
            background: var(--border-color);
            color: var(--text-secondary);
            font-size: 10px;
            font-weight: 700;
            padding: 2px 6px;
            border-radius: 4px;
            margin-left: auto;
            margin-right: 4px;
        }

        .chevron {
            color: var(--text-tertiary);
            font-size: 10px;
            transition: transform 0.2s;
            flex-shrink: 0;
        }

        .menu-item-parent.open .chevron {
            transform: rotate(90deg);
        }

        .submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            padding-left: 12px;
        }

        .submenu.open {
            max-height: 600px;
        }

        .submenu .menu-item {
            font-size: 13px;
            padding: 7px 16px;
            position: relative;
        }

        .submenu .menu-item::before {
            content: '';
            position: absolute;
            left: 6px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 4px;
            background: var(--border-color);
            border-radius: 50%;
            opacity: 0;
            transition: all 0.2s;
        }

        .submenu .menu-item:hover::before,
        .submenu .menu-item.active::before {
            opacity: 1;
            background: var(--acf-teal);
        }

        .sidebar.collapsed .submenu {
            display: none;
        }

        .sidebar.collapsed .chevron,
        .sidebar.collapsed .menu-badge {
            display: none;
        }

        /* Toggle Button */
        .toggle-btn {
            position: absolute;
            right: -12px;
            top: 24px;
            width: 24px;
            height: 24px;
            background: var(--acf-teal);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 1001;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border: 2px solid white;
            transition: all 0.2s;
        }

        .toggle-btn:hover {
            background: var(--acf-dark-teal);
            transform: scale(1.1);
        }

        .toggle-btn i {
            font-size: 11px;
        }

        /* ===== MAIN CONTENT ===== */
        .main-content {
            margin-left: var(--sidebar-width);
            transition: margin-left 0.3s;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .sidebar.collapsed + .main-content {
            margin-left: 72px;
        }

        /* Top Bar */
        .topbar {
            background: var(--bg-primary);
            padding: 0 32px;
            height: var(--header-height);
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .topbar-left h2 {
            font-size: 20px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 4px;
        }

        .topbar-date {
            font-size: 12px;
            color: var(--text-secondary);
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .topbar-date i {
            color: var(--text-tertiary);
        }

        .topbar-right {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .logout-btn {
            background: #fef2f2;
            color: #dc2626;
            padding: 8px 16px;
            border-radius: 6px;
            font-weight: 600;
            text-decoration: none;
            font-size: 13px;
            border: 1px solid #fee2e2;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            border-color: #dc2626;
        }

        /* Content Area */
        .iframe-container {
            flex: 1;
            padding: 20px;
            background: var(--bg-secondary);
            overflow: hidden;
        }

        iframe {
            width: 100%;
            height: 100%;
            border: none;
            background: white;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
            border: 1px solid var(--border-color);
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.mobile-show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0 !important;
            }

            .topbar {
                padding: 0 16px;
                height: 60px;
            }

            .topbar-left h2 {
                font-size: 16px;
            }

            .iframe-container {
                padding: 12px;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="toggle-btn" onclick="toggleSidebar()">
            <i class="fas fa-chevron-left" id="toggleIcon"></i>
        </div>

        <!-- ✅ Workspace Header - Simplified -->
        <div class="workspace-header">
            <div class="workspace-select">
                <img src="gambar/logo.jpeg" alt="ACF Logo" onerror="this.src='https://via.placeholder.com/24?text=ACF'">
                <span class="workspace-name">ACF EDU HUB</span>
            </div>
        </div>

        <!-- User Card -->
        <div class="user-card">
            <div class="user-avatar"><?= strtoupper(substr($userName, 0, 1)) ?></div>
            <div class="user-info">
                <div class="user-name" title="<?= htmlspecialchars($userName) ?>">
                    <?= htmlspecialchars($userName) ?>
                </div>
                <div class="user-role"><?= $roleName ?></div>
            </div>
        </div>

        <!-- Navigation Menu -->
        <nav class="sidebar-menu">
            <?php if ($userRole === 'staff'): // Staff ?>
                <div class="menu-section-title">Menu Utama</div>
                <a href="pages/staff/home_staff.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-th-large"></i>
                    <span>Dashboard</span>
                </a>
                
                <div class="menu-section-title">Produktivitas</div>
                <a href="pages/staff/rencana_kerja.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-tasks"></i>
                    <span>Rencana Kerja</span>
                </a>
                
                <div class="menu-section-title">Manajemen Aset</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-boxes"></i>
                        <span>Inventory Aset</span>
                        <span class="menu-badge">2</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/inventory/inventory_list.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-clipboard-list"></i>
                        <span>Data Inventory</span>
                    </a>
                    <a href="pages/inventory/cetak_label_panel.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-qrcode"></i>
                        <span>Cetak Label Aset</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Transaksi</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-exchange-alt"></i>
                        <span>Transaksi Barang</span>
                        <span class="menu-badge">2</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/staff/barang_masuk.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-arrow-down"></i>
                        <span>Barang Masuk</span>
                    </a>
                    <a href="pages/staff/barang_keluar.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-arrow-up"></i>
                        <span>Barang Keluar</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Laporan</div>
                <a href="pages/staff/laporan_staff.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-alt"></i>
                    <span>Laporan Aset</span>
                </a>

            <?php elseif ($userRole === 'dept_head'): // Department Head ?>
                <div class="menu-section-title">Dashboard</div>
                <a href="pages/manager/home_manager.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-chart-line"></i>
                    <span>Overview Dashboard</span>
                </a>
                
                <div class="menu-section-title">Produktivitas</div>
                <a href="pages/manager/rencana_kerja.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-tasks"></i>
                    <span>Rencana Kerja</span>
                </a>
                
                <div class="menu-section-title">Dashboard Operasional</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-cogs"></i>
                        <span>Monitoring Operasional</span>
                        <span class="menu-badge">3</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/inventory/inventory_list.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-box"></i>
                        <span>Data Aset</span>
                    </a>
                    <a href="pages/manager/operasional_kebersihan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-broom"></i>
                        <span>Kebersihan</span>
                    </a>
                    <a href="pages/manager/operasional_sapras.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-building"></i>
                        <span>Sarana Prasarana</span>
                    </a>
                </div>

                <div class="menu-section-title">Dashboard ACF</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>Marketing Analytics</span>
                        <span class="menu-badge">6</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/manager/acf_ppdb.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-users"></i>
                        <span>Update PPDB</span>
                    </a>
                    <a href="pages/manager/acf_pencapaian_se.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-trophy"></i>
                        <span>Pencapaian SE</span>
                    </a>
                    <a href="pages/manager/acf_saldo_dp.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-wallet"></i>
                        <span>Saldo DP</span>
                    </a>
                    <a href="pages/dashboard_piutang_system/index.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Kepatuhan Bayar</span>
                    </a>
                    <a href="pages/manager/acf_likuiditas.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Likuiditas</span>
                    </a>
                    <a href="pages/SDM/index.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-user-tie"></i>
                        <span>Total SDM</span>
                    </a>
                </div>

                <div class="menu-section-title">Reporting</div>
                <a href="pages/manager/laporan_manager.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-contract"></i>
                    <span>Laporan & Export</span>
                </a>

            <?php elseif ($userRole === 'director'): // Director ?>
                <div class="menu-section-title">Executive Dashboard</div>
                <a href="pages/director/home_director.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-chart-pie"></i>
                    <span>Dashboard Eksekutif</span>
                </a>
                
                <div class="menu-section-title">Produktivitas</div>
                <a href="pages/director/rencana_kerja.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-tasks"></i>
                    <span>Rencana Kerja</span>
                </a>
                
                <div class="menu-section-title">Dashboard Operasional</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-cogs"></i>
                        <span>Monitoring Operasional</span>
                        <span class="menu-badge">3</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/inventory/inventory_list.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-box"></i>
                        <span>Data Aset</span>
                    </a>
                    <a href="pages/director/operasional_kebersihan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-broom"></i>
                        <span>Kebersihan</span>
                    </a>
                    <a href="pages/director/operasional_sapras.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-building"></i>
                        <span>Sarana Prasarana</span>
                    </a>
                </div>

                <div class="menu-section-title">Dashboard ACF</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-chart-line"></i>
                        <span>Marketing Analytics</span>
                        <span class="menu-badge">6</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/director/acf_ppdb.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-users"></i>
                        <span>Update PPDB</span>
                    </a>
                    <a href="pages/director/acf_pencapaian_se.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-trophy"></i>
                        <span>Pencapaian SE</span>
                    </a>
                    <a href="pages/director/acf_saldo_dp.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-wallet"></i>
                        <span>Saldo DP</span>
                    </a>
                    <a href="pages/dashboard_piutang_system/index_director.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Kepatuhan Bayar</span>
                    </a>
                    <a href="pages/director/acf_likuiditas.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Likuiditas</span>
                    </a>
                    <a href="pages/SDM/index.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-user-tie"></i>
                        <span>Total SDM</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Laporan</div>
                <a href="pages/director/laporan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-contract"></i>
                    <span>Laporan Eksekutif</span>
                </a>

            <?php else: // ADMIN ?>
                <div class="menu-section-title">Control Panel</div>
                <a href="pages/admin/home_admin.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard Admin</span>
                </a>
                
                <div class="menu-section-title">Produktivitas</div>
                <a href="pages/admin/rencana_kerja.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-tasks"></i>
                    <span>Rencana Kerja</span>
                </a>
                
                <div class="menu-section-title">Manajemen Aset</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-boxes"></i>
                        <span>Inventory Aset</span>
                        <span class="menu-badge">3</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/inventory/inventory_list.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-clipboard-list"></i>
                        <span>Data Inventory</span>
                    </a>
                    <a href="pages/inventory/generate_kode_asset.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-cog"></i>
                        <span>Generate Kode</span>
                    </a>
                    <a href="pages/inventory/cetak_label_panel.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-qrcode"></i>
                        <span>Cetak Label</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Transaksi</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-exchange-alt"></i>
                        <span>Transaksi Barang</span>
                        <span class="menu-badge">2</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/staff/barang_masuk.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-arrow-down"></i>
                        <span>Barang Masuk</span>
                    </a>
                    <a href="pages/staff/barang_keluar.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-arrow-up"></i>
                        <span>Barang Keluar</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Dashboard Operasional</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-cogs"></i>
                        <span>Monitoring Operasional</span>
                        <span class="menu-badge">3</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/inventory/inventory_list.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-box"></i>
                        <span>Data Aset</span>
                    </a>
                    <a href="pages/admin/operasional_kebersihan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-broom"></i>
                        <span>Kebersihan</span>
                    </a>
                    <a href="pages/admin/operasional_sapras.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-building"></i>
                        <span>Sarana Prasarana</span>
                    </a>
                </div>

                <div class="menu-section-title">Dashboard ACF</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>Marketing Analytics</span>
                        <span class="menu-badge">6</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/admin/acf_ppdb.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-users"></i>
                        <span>Update PPDB</span>
                    </a>
                    <a href="pages/admin/acf_pencapaian_se.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-trophy"></i>
                        <span>Pencapaian SE</span>
                    </a>
                    <a href="pages/admin/acf_saldo_dp.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-wallet"></i>
                        <span>Saldo DP</span>
                    </a>
                    <a href="pages/dashboard_piutang_system/index_admin.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Kepatuhan Bayar</span>
                    </a>
                    <a href="pages/admin/acf_likuiditas.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Likuiditas</span>
                    </a>
                    <a href="pages/SDM/index.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-user-tie"></i>
                        <span>Total SDM</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Konfigurasi</div>
                <div class="menu-item-parent" onclick="toggleSubmenu(this)">
                    <div class="menu-item">
                        <i class="fas fa-sliders-h"></i>
                        <span>Konfigurasi Sistem</span>
                        <span class="menu-badge">5</span>
                        <i class="fas fa-chevron-right chevron"></i>
                    </div>
                </div>
                <div class="submenu">
                    <a href="pages/admin/users.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-user-cog"></i>
                        <span>Kelola User</span>
                    </a>
                    <a href="pages/admin/kelola_kantor.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-building"></i>
                        <span>Kelola Kantor</span>
                    </a>
                    <a href="pages/admin/kelola_jenis_asset.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-tags"></i>
                        <span>Kelola Jenis Aset</span>
                    </a>
                    <a href="pages/admin/kelola_kategori.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-folder-open"></i>
                        <span>Kelola Kategori</span>
                    </a>
                    <a href="pages/admin/kelola_sumber_dana.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Kelola Sumber Dana</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Laporan</div>
                <a href="pages/admin/laporan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-contract"></i>
                    <span>Laporan Lengkap</span>
                </a>
            <?php endif; ?>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Bar -->
        <header class="topbar">
            <div class="topbar-left">
                <h2 id="pageTitle">Dashboard</h2>
                <div class="topbar-date">
                    <i class="far fa-calendar-alt"></i>
                    <span><?= htmlspecialchars($currentDate) ?></span>
                </div>
            </div>
            <div class="topbar-right">
                <a href="auth/logout.php" class="logout-btn" onclick="return confirm('Apakah Anda yakin ingin keluar?')">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Keluar</span>
                </a>
            </div>
        </header>

        <!-- Content Area -->
        <div class="iframe-container">
            <iframe name="contentFrame" id="contentFrame" src="<?= htmlspecialchars($defaultPage) ?>"></iframe>
        </div>
    </main>

    <script>
        // Toggle Sidebar
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const icon = document.getElementById('toggleIcon');
            
            if (window.innerWidth <= 768) {
                sidebar.classList.toggle('mobile-show');
            } else {
                sidebar.classList.toggle('collapsed');
                icon.className = sidebar.classList.contains('collapsed') 
                    ? 'fas fa-chevron-right' 
                    : 'fas fa-chevron-left';
            }
        }

        // Set Active Menu Item
        function setActive(el) {
            document.querySelectorAll('.menu-item').forEach(item => {
                item.classList.remove('active');
            });
            
            el.classList.add('active');
            
            const titleEl = document.getElementById('pageTitle');
            titleEl.style.opacity = '0';
            
            setTimeout(() => {
                const spanText = el.querySelector('span');
                titleEl.innerText = spanText ? spanText.innerText : 'Dashboard';
                titleEl.style.opacity = '1';
            }, 150);

            if (window.innerWidth <= 768) {
                document.getElementById('sidebar').classList.remove('mobile-show');
            }
        }

        // Toggle Submenu
        function toggleSubmenu(element) {
            const submenu = element.nextElementSibling;
            const isOpen = element.classList.contains('open');
            
            document.querySelectorAll('.menu-item-parent').forEach(parent => {
                if (parent !== element) {
                    parent.classList.remove('open');
                    const otherSubmenu = parent.nextElementSibling;
                    if (otherSubmenu && otherSubmenu.classList.contains('submenu')) {
                        otherSubmenu.classList.remove('open');
                    }
                }
            });
            
            if (submenu && submenu.classList.contains('submenu')) {
                element.classList.toggle('open');
                submenu.classList.toggle('open');
            }
        }

        // Close mobile sidebar when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggleBtn = document.querySelector('.toggle-btn');
            
            if (window.innerWidth <= 768 && 
                sidebar.classList.contains('mobile-show') &&
                !sidebar.contains(event.target) && 
                !toggleBtn.contains(event.target)) {
                sidebar.classList.remove('mobile-show');
            }
        });

        // Smooth scrolling for sidebar menu
        const sidebarMenu = document.querySelector('.sidebar-menu');
        if (sidebarMenu) {
            sidebarMenu.style.scrollBehavior = 'smooth';
        }
    </script>
</body>
</html>