<?php
session_start();

// 1. VALIDASI SESSION
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: index.html?error=session");
    exit;
}

if (!isset($_SESSION['role'])) {
    session_destroy();
    header("Location: index.html?error=no_role");
    exit;
}

// 2. NORMALISASI ROLE & INFO USER
$userRole = strtoupper(trim($_SESSION['role']));
$userName = $_SESSION['full_name'] ?? $_SESSION['nama'] ?? $_SESSION['username'] ?? 'User';

// Validasi role yang diperbolehkan
$allowedRoles = ['A', 'M', 'S'];
if (!in_array($userRole, $allowedRoles, true)) {
    session_destroy();
    header("Location: index.html?error=invalid_role");
    exit;
}

// 3. KONFIGURASI TEMA (ACF EDU HUB)
$roleNames  = ['A' => 'Administrator', 'M' => 'Manager', 'S' => 'Staff'];
$roleColors = ['A' => '#8B4789', 'M' => '#F4B840', 'S' => '#10b981'];

$roleName  = $roleNames[$userRole];
$roleColor = $roleColors[$userRole];

// 4. PENENTUAN HALAMAN AWAL BERDASARKAN ROLE
$defaultPages = [
    'A' => 'pages/admin/home_admin.php',
    'M' => 'pages/manager/home_manager.php',  // ← Manager punya halaman sendiri
    'S' => 'pages/staff/home_staff.php'
];

$defaultPage = $defaultPages[$userRole];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-purple: #8B4789;
            --primary-yellow: #F4B840;
            --role-color: <?= $roleColor; ?>;
            --role-color-light: <?= $roleColor; ?>15;
            --role-color-border: <?= $roleColor; ?>30;
            --bg-light: #f8fafc;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; background: var(--bg-light); overflow: hidden; height: 100vh; }

        /* ===== SIDEBAR ===== */
        .sidebar {
            position: fixed; left: 0; top: 0; height: 100vh; width: 260px;
            background: #fff; border-right: 1px solid #e2e8f0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); z-index: 1000;
            display: flex; flex-direction: column;
        }

        .sidebar.collapsed { width: 85px; }

        .sidebar-header {
            padding: 20px; display: flex; align-items: center;
            gap: 12px; border-bottom: 1px solid #f1f5f9; height: 80px;
        }

        .logo-box {
            width: 42px; height: 42px; background: white; border-radius: 10px;
            display: flex; align-items: center; justify-content: center;
            flex-shrink: 0; box-shadow: 0 2px 10px rgba(139, 71, 137, 0.15);
            border: 1px solid var(--role-color-border); overflow: hidden;
        }

        .logo-box img { width: 100%; height: 100%; object-fit: cover; }

        .logo-text {
            font-weight: 800; font-size: 16px; color: var(--primary-purple);
            letter-spacing: -0.5px; white-space: nowrap; opacity: 1; transition: 0.2s;
        }

        .sidebar.collapsed .logo-text { opacity: 0; pointer-events: none; width: 0; }

        /* User Card */
        .user-card {
            margin: 15px; padding: 12px; background: var(--role-color-light);
            border: 1px solid var(--role-color-border); border-radius: 12px;
            display: flex; align-items: center; gap: 12px; position: relative;
        }
        
        .user-card::before {
            content: ''; position: absolute; left: 0; top: 20%; 
            width: 4px; height: 60%; background: var(--role-color); border-radius: 0 4px 4px 0;
        }

        .avatar {
            width: 38px; height: 38px; background: var(--role-color);
            color: white; border-radius: 8px; display: flex;
            align-items: center; justify-content: center; font-weight: 700; flex-shrink: 0;
        }

        .sidebar.collapsed .user-card { margin: 15px 10px; padding: 10px; justify-content: center; }
        .sidebar.collapsed .user-meta { display: none; }

        /* Menu */
        .sidebar-menu { flex: 1; overflow-y: auto; padding: 10px; scrollbar-width: thin; }
        .menu-label {
            font-size: 10px; font-weight: 800; color: #94a3b8;
            text-transform: uppercase; padding: 20px 15px 8px; letter-spacing: 1px;
        }
        .sidebar.collapsed .menu-label { display: none; }

        .menu-item {
            display: flex; align-items: center; padding: 12px 15px;
            margin: 4px 0; color: #64748b; text-decoration: none;
            border-radius: 10px; transition: all 0.2s; font-size: 14px; font-weight: 500;
        }

        .menu-item i { width: 25px; font-size: 18px; }
        .menu-item span { margin-left: 5px; }

        .sidebar.collapsed .menu-item { justify-content: center; padding: 12px; }
        .sidebar.collapsed .menu-item span { display: none; }

        .menu-item:hover, .menu-item.active {
            background: var(--role-color); color: white;
            box-shadow: 0 4px 12px var(--role-color-border);
        }

        /* ===== MAIN CONTENT ===== */
        .main-content {
            margin-left: 260px; transition: 0.3s; height: 100vh;
            display: flex; flex-direction: column;
        }
        .sidebar.collapsed + .main-content { margin-left: 85px; }

        .topbar {
            background: #fff; padding: 0 25px; height: 80px;
            border-bottom: 1px solid #e2e8f0;
            display: flex; justify-content: space-between; align-items: center;
        }

        .logout-btn {
            background: #fff1f2; color: #e11d48; padding: 10px 20px;
            border-radius: 10px; font-weight: 700; text-decoration: none;
            font-size: 13px; border: 1px solid #ffe4e6; transition: 0.2s;
            display: flex; align-items: center; gap: 8px;
        }
        .logout-btn:hover { background: #e11d48; color: #fff; transform: translateY(-2px); }

        .iframe-container { flex: 1; padding: 20px; background: #f1f5f9; position: relative; }
        iframe { 
            width: 100%; height: 100%; border: none; 
            background: white; border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.05);
        }

        /* Toggle Button */
        .toggle-btn {
            position: absolute; right: -12px; top: 28px;
            width: 26px; height: 26px; background: var(--role-color);
            color: white; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            cursor: pointer; z-index: 1001; box-shadow: 0 2px 5px rgba(0,0,0,0.2);
            border: 2px solid white;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.mobile-show { transform: translateX(0); }
            .main-content { margin-left: 0 !important; }
            .mobile-toggle {
                position: fixed; bottom: 20px; right: 20px; z-index: 999;
                width: 50px; height: 50px; background: var(--role-color);
                color: white; border: none; border-radius: 50%;
                box-shadow: 0 4px 12px rgba(0,0,0,0.2); cursor: pointer;
            }
        }
    </style>
</head>
<body>

    <div class="sidebar" id="sidebar">
        <div class="toggle-btn" onclick="toggleSidebar()">
            <i class="fas fa-chevron-left" id="toggleIcon"></i>
        </div>

        <div class="sidebar-header">
            <div class="logo-box">
                <img src="gambar/logo.jpeg" alt="Logo" onerror="this.src='https://via.placeholder.com/42?text=ACF'">
            </div>
            <div class="logo-text">ACF EDU HUB</div>
        </div>

        <div class="user-card">
            <div class="avatar"><?= strtoupper(substr($userName, 0, 1)) ?></div>
            <div class="user-meta">
                <div style="font-weight: 700; font-size: 13px; color: #1e293b;"><?= htmlspecialchars($userName) ?></div>
                <div style="font-size: 11px; color: var(--role-color); font-weight: 700;"><?= $roleName ?></div>
            </div>
        </div>

        <div class="sidebar-menu">
            <!-- ===== MENU STAFF ===== -->
            <?php if ($userRole === 'S'): ?>
                <div class="menu-label">Main Menu</div>
                <a href="pages/staff/home_staff.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-house"></i> <span>Dashboard</span>
                </a>
                <a href="pages/staff/inventory_list_staff.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-boxes-stacked"></i> <span>Data Inventory</span>
                </a>
                <a href="pages/cetak_label_panel.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-qrcode"></i> <span>Cetak Label QR</span>
                </a>

                <div class="menu-label">Laporan</div>
                <a href="pages/staff/laporan_staff.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-invoice"></i> <span>Laporan Aset</span>
                </a>

            <!-- ===== MENU MANAGER ===== -->
            <?php elseif ($userRole === 'M'): ?>
                <div class="menu-label">Main Menu</div>
                <a href="pages/manager/home_manager.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-chart-line"></i> <span>Dashboard Manager</span>
                </a>
                <a href="pages/inventory/inventory_list.php">" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-box-open"></i> <span>Manajemen Aset</span>
                </a>
                <a href="pages/cetak_label_panel.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-qrcode"></i> <span>Cetak Label QR</span>
                </a>

                <div class="menu-label">Laporan & Monitoring</div>
                <a href="pages/manager/laporan_manager.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-invoice"></i> <span>Laporan Aset</span>
                </a>
                <a href="pages/manager/monitoring.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-chart-bar"></i> <span>Monitoring Aset</span>
                </a>
                <a href="pages/manager/approval.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-check-circle"></i> <span>Approval</span>
                </a>

            <!-- ===== MENU ADMIN ===== -->
            <?php else: ?>
                <div class="menu-label">Main Menu</div>
                <a href="pages/admin/home_admin.php" target="contentFrame" class="menu-item active" onclick="setActive(this)">
                    <i class="fas fa-chart-pie"></i> <span>Dashboard Admin</span>
                </a>
                <a href="pages/inventory/inventory_list.php">" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-box-open"></i> <span>Manajemen Aset</span>
                </a>
                <a href="pages/cetak_label_panel.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-qrcode"></i> <span>Cetak Label QR</span>
                </a>

                <div class="menu-label">Laporan</div>
                <a href="pages/admin/laporan.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-file-invoice"></i> <span>Laporan Aset</span>
                </a>

                <div class="menu-label">Konfigurasi</div>
                <a href="pages/admin/kelola_kategori.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-shapes"></i> <span>Kategori</span>
                </a>
                <a href="pages/admin/kelola_kantor.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-map-location-dot"></i> <span>Lokasi Kantor</span>
                </a>
                <a href="pages/admin/kelola_jenis_asset.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-tag"></i> <span>Jenis Asset</span>
                </a>
                <a href="pages/admin/kelola_sumber_dana.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-wallet"></i> <span>Sumber Dana</span>
                </a>
                <a href="pages/admin/users.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                    <i class="fas fa-users-gear"></i> <span>User Management</span>
                </a>
            <?php endif; ?>

            <!-- Menu Profile untuk semua role -->
            <div class="menu-label">Account</div>
            <a href="pages/profil.php" target="contentFrame" class="menu-item" onclick="setActive(this)">
                <i class="fas fa-user-circle"></i> <span>Profile Saya</span>
            </a>
        </div>
    </div>

    <div class="main-content">
        <div class="topbar">
            <div>
                <h2 id="pageTitle" style="font-size: 20px; color: #1e293b; font-weight: 700;">Dashboard</h2>
                <span style="font-size: 12px; color: #94a3b8; font-weight: 600;">
                    <i class="fas fa-calendar-day"></i> <?= date('l, d F Y') ?>
                </span>
            </div>
            <a href="auth/logout.php" class="logout-btn" onclick="return confirm('Apakah Anda yakin ingin keluar?')">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>

        <div class="iframe-container">
            <iframe name="contentFrame" id="contentFrame" src="<?= $defaultPage ?>"></iframe>
        </div>
    </div>

    <!-- Mobile Toggle -->
    <button class="mobile-toggle" onclick="toggleMobileSidebar()" style="display: none;">
        <i class="fas fa-bars"></i>
    </button>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const icon = document.getElementById('toggleIcon');
            sidebar.classList.toggle('collapsed');
            icon.className = sidebar.classList.contains('collapsed') 
                ? 'fas fa-chevron-right' : 'fas fa-chevron-left';
        }

        function toggleMobileSidebar() {
            document.getElementById('sidebar').classList.toggle('mobile-show');
        }

        function setActive(el) {
            document.querySelectorAll('.menu-item').forEach(item => item.classList.remove('active'));
            el.classList.add('active');
            
            // Animasi transisi judul
            const titleEl = document.getElementById('pageTitle');
            titleEl.style.opacity = 0;
            setTimeout(() => {
                titleEl.innerText = el.querySelector('span').innerText;
                titleEl.style.opacity = 1;
            }, 150);
        }

        // Handle mobile responsive
        function checkMobile() {
            const mobileToggle = document.querySelector('.mobile-toggle');
            if (window.innerWidth < 768) {
                document.getElementById('sidebar').classList.add('collapsed');
                mobileToggle.style.display = 'block';
            } else {
                mobileToggle.style.display = 'none';
            }
        }

        checkMobile();
        window.addEventListener('resize', checkMobile);

        // Close sidebar on mobile when clicking outside
        document.addEventListener('click', function(e) {
            const sidebar = document.getElementById('sidebar');
            const mobileToggle = document.querySelector('.mobile-toggle');
            
            if (window.innerWidth < 768 && 
                !sidebar.contains(e.target) && 
                !mobileToggle.contains(e.target)) {
                sidebar.classList.remove('mobile-show');
            }
        });
    </script>
</body>
</html>