<?php
session_start();

/* ========================
   INCLUDE KONEKSI
======================== */
require_once __DIR__ . '/../DataBase/koneksi.php';

/* ========================
   CEK ROLE (Admin/Manager)
======================== */
checkRole(['A', 'M']);

/* ========================
   QUERY STATISTIK
======================== */
$totalBarang = $conn->query("SELECT COUNT(*) as total FROM inventory")->fetch_assoc()['total'];
$totalUser = $conn->query("SELECT COUNT(*) as total FROM users WHERE status='active'")->fetch_assoc()['total'];
$totalNilai = $conn->query("SELECT SUM(harga_perolehan) as total FROM inventory")->fetch_assoc()['total'] ?? 0;

// Barang per kategori
$queryKategori = "SELECT kategori, COUNT(id) as jumlah 
                  FROM inventory 
                  WHERE kategori IS NOT NULL AND kategori != ''
                  GROUP BY kategori
                  ORDER BY jumlah DESC";
$resultKategori = $conn->query($queryKategori);

// Barang per kantor
$queryKantor = "SELECT kantor, COUNT(id) as jumlah 
                FROM inventory 
                WHERE kantor IS NOT NULL AND kantor != ''
                GROUP BY kantor 
                ORDER BY jumlah DESC 
                LIMIT 5";
$resultKantor = $conn->query($queryKantor);

$totalKantor = $conn->query("SELECT COUNT(DISTINCT kantor) as total FROM inventory WHERE kantor IS NOT NULL")->fetch_assoc()['total'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Dashboard Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Inter', 'Segoe UI', sans-serif;
            padding: 30px;
            background: #f8fafc;
            margin: 0;
        }
        .welcome {
            background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .welcome h1 {
            margin-bottom: 10px;
            font-size: 28px;
        }
        .welcome p {
            opacity: 0.9;
            font-size: 14px;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border-left: 4px solid #3b82f6;
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        .stat-card h3 {
            color: #64748b;
            font-size: 14px;
            margin-bottom: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .stat-card .number {
            font-size: 32px;
            font-weight: bold;
            color: #1e3a8a;
        }
        .charts-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .chart-card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .chart-card h2 {
            color: #1e3a8a;
            margin-bottom: 20px;
            font-size: 18px;
            font-weight: 700;
        }
        .bar {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        .bar-label {
            width: 150px;
            font-size: 14px;
            color: #334155;
            font-weight: 500;
        }
        .bar-container {
            flex: 1;
            background: #e2e8f0;
            border-radius: 5px;
            height: 30px;
            position: relative;
            overflow: hidden;
        }
        .bar-fill {
            background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding-right: 10px;
            color: white;
            font-size: 12px;
            font-weight: bold;
            transition: width 0.5s ease;
        }
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #9ca3af;
        }
        .empty-state i {
            font-size: 48px;
            margin-bottom: 12px;
            display: block;
        }
        @media (max-width: 768px) {
            body {
                padding: 16px;
            }
            .charts-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="welcome">
        <h1><i class="fas fa-home"></i> Selamat Datang, <?php echo htmlspecialchars($_SESSION['full_name'] ?? $_SESSION['nama'] ?? $_SESSION['username']); ?>! 👋</h1>
        <p>Anda login sebagai <?php echo ($_SESSION['role'] === 'A') ? 'Administrator' : 'Manager'; ?></p>
    </div>

    <div class="stats">
        <div class="stat-card">
            <h3><i class="fas fa-boxes"></i> Total Barang</h3>
            <div class="number"><?php echo number_format($totalBarang); ?></div>
        </div>
        <div class="stat-card">
            <h3><i class="fas fa-users"></i> Total User</h3>
            <div class="number"><?php echo $totalUser; ?></div>
        </div>
        <div class="stat-card">
            <h3><i class="fas fa-money-bill-wave"></i> Total Nilai Aset</h3>
            <div class="number" style="font-size: 20px;"><?php echo formatRupiah($totalNilai); ?></div>
        </div>
        <div class="stat-card">
            <h3><i class="fas fa-building"></i> Total Kantor</h3>
            <div class="number"><?php echo $totalKantor; ?></div>
        </div>
    </div>

    <div class="charts-row">
        <div class="chart-card">
            <h2><i class="fas fa-chart-bar"></i> Barang per Kategori</h2>
            <?php 
            if ($resultKategori->num_rows > 0):
                $maxKategori = $conn->query("SELECT COUNT(id) as jumlah FROM inventory GROUP BY kategori ORDER BY jumlah DESC LIMIT 1")->fetch_assoc()['jumlah'] ?? 1;
                while ($row = $resultKategori->fetch_assoc()): 
                    $percent = ($row['jumlah'] / $maxKategori) * 100;
            ?>
            <div class="bar">
                <div class="bar-label"><?php echo htmlspecialchars($row['kategori']); ?></div>
                <div class="bar-container">
                    <div class="bar-fill" style="width: <?php echo $percent; ?>%">
                        <?php echo $row['jumlah']; ?>
                    </div>
                </div>
            </div>
            <?php 
                endwhile;
            else:
            ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>Belum ada data kategori</p>
                </div>
            <?php endif; ?>
        </div>

        <div class="chart-card">
            <h2><i class="fas fa-building"></i> Top 5 Kantor</h2>
            <?php 
            if ($resultKantor->num_rows > 0):
                $maxKantor = $resultKantor->fetch_assoc();
                $resultKantor->data_seek(0);
                $maxValue = $maxKantor['jumlah'] ?? 1;
                
                while ($row = $resultKantor->fetch_assoc()): 
                    $percent = ($row['jumlah'] / $maxValue) * 100;
            ?>
            <div class="bar">
                <div class="bar-label"><?php echo htmlspecialchars($row['kantor']); ?></div>
                <div class="bar-container">
                    <div class="bar-fill" style="width: <?php echo $percent; ?>%">
                        <?php echo $row['jumlah']; ?>
                    </div>
                </div>
            </div>
            <?php 
                endwhile;
            else:
            ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>Belum ada data kantor</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>