# Dashboard Piutang Multi-Period

Dashboard piutang dengan fitur multi-period, export, dan import data untuk unit sekolah.

## 📋 Fitur Utama

✅ **Dashboard Interaktif**
- Tampilan statistik real-time (Total Target, Capaian, Piutang, Efektivitas)
- Grafik visualisasi data per unit sekolah
- Tabel detail dengan expand/collapse untuk jenis pembayaran
- Multi-period selection (5 tahun ajaran)

✅ **Export Data**
- Export ke format Excel (.xlsx)
- Export ke format CSV (fallback)
- Data lengkap dengan formatting profesional

✅ **Import Data**
- Import dari Excel (.xlsx, .xls)
- Import dari CSV
- Template Excel tersedia untuk download
- Validasi data otomatis

## 🚀 Instalasi

### Persyaratan Sistem
- PHP 7.4 atau lebih tinggi
- Web server (Apache/Nginx)
- Python 3.8+ (untuk generate template)
- Library: pandas, openpyxl (untuk Python)

### Langkah Instalasi

1. **Extract file** ke direktori web server Anda (misalnya: `htdocs/piutang-dashboard/`)

2. **Struktur File:**
   ```
   piutang-dashboard/
   ├── index.php              # Dashboard utama
   ├── data_config.php        # Konfigurasi data
   ├── api.php                # API endpoint
   ├── export.php             # Export handler
   ├── import.php             # Import handler
   ├── download_template.php  # Download template
   ├── Template_Import_Piutang.xlsx  # Template Excel
   └── README.md              # Dokumentasi
   ```

3. **Buat folder data** (optional, untuk menyimpan data import):
   ```bash
   mkdir data
   chmod 755 data
   ```

4. **Akses dashboard** melalui browser:
   ```
   http://localhost/piutang-dashboard/
   ```

## 📊 Cara Penggunaan

### 1. Melihat Dashboard
- Buka `index.php` di browser
- Pilih periode tahun ajaran dari dropdown
- Data akan dimuat otomatis via AJAX

### 2. Export Data
- Pilih periode yang ingin di-export
- Klik tombol **"Export"** di header
- File Excel/CSV akan otomatis terdownload

### 3. Import Data
- Klik tombol **"Import"** di header
- Pilih periode tahun ajaran
- Upload file Excel/CSV
- Data akan divalidasi dan disimpan

### 4. Download Template
- Buka halaman Import
- Klik link **"Download Template Excel"**
- Gunakan template untuk mengisi data

## 📝 Format Data Import

### Struktur Excel/CSV:
```
No | Unit Sekolah    | Target       | Capaian      | Piutang | Persentase | Kategori
1  | SDJ BATAM       | 2850000000   | 2750000000   | ...     | ...        | ...
   | → SPP           | 2400000000   | 2350000000   | ...     | ...        |
   | → UANG PANGKAL  | 450000000    | 400000000    | ...     | ...        |
2  | SDJ CILEGON     | 1950000000   | 1850000000   | ...     | ...        | ...
```

### Aturan Penting:
- Kolom **No** diisi angka untuk sekolah utama, kosong untuk detail jenis
- Detail jenis pembayaran ditandai dengan **"→"** atau **"->"** di awal nama
- Target dan Capaian dalam format angka tanpa pemisah (contoh: 2850000000)
- Piutang, Persentase, dan Kategori akan dihitung otomatis

## 🎨 Kategori Penilaian

| Kategori   | Persentase        | Badge Color |
|------------|-------------------|-------------|
| EXCELLENT  | >= 100%           | Blue        |
| GOOD       | >= 95% - < 100%   | Green       |
| AVERAGE    | >= 85% - < 95%    | Yellow      |
| POOR       | < 85%             | Orange      |

## 🔧 Kustomisasi

### Menambah Periode Baru

Edit `data_config.php`, tambahkan di array `$periods`:
```php
$periods = [
    ['id' => '2025-2026', 'label' => 'Tahun Ajaran 2025-2026'],
    // ... periode lainnya
];
```

### Menambah Data Sekolah

Edit `data_config.php`, tambahkan di array `$dataByPeriod`:
```php
'2024-2025' => [
    [
        'sekolah' => 'SEKOLAH BARU',
        'target' => 3000000000,
        'capaian' => 2900000000,
        'jenis' => [
            ['jenis' => 'SPP', 'target' => 2500000000, 'capaian' => 2400000000],
            ['jenis' => 'UANG PANGKAL', 'target' => 500000000, 'capaian' => 500000000],
        ]
    ],
    // ... sekolah lainnya
]
```

## 🛠️ Troubleshooting

### Export tidak berfungsi
- Pastikan PHP memiliki akses write
- Periksa library PhpSpreadsheet (jika menggunakan Excel)
- Gunakan export CSV sebagai fallback

### Import gagal
- Periksa format file Excel/CSV
- Pastikan kolom sesuai template
- Periksa format angka (tanpa pemisah)

### Data tidak muncul
- Clear browser cache
- Periksa console browser untuk error JavaScript
- Pastikan file `api.php` dapat diakses

## 📞 Support

Untuk pertanyaan atau bantuan, silakan hubungi:
- Email: support@example.com
- Website: https://example.com

## 📄 License

Copyright © 2025. All rights reserved.

---

**Version:** 5.0  
**Last Updated:** January 2025  
**Author:** Dashboard Development Team
