<?php
session_start();
require_once __DIR__ . '/../../DataBase/koneksi.php';

// Cek Login & Role
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id == 0) {
    header("Location: inventory_list.php");
    exit;
}

// Format Tanggal Indonesia
function formatTanggalIndo($tanggal) {
    if (!$tanggal) return '-';
    
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    if (count($split) == 3) {
        return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
    }
    return $tanggal;
}

// Format Rupiah
function formatRupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Get data barang
$sql = "SELECT * FROM inventory WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$barang = $result->fetch_assoc();

if (!$barang) {
    header("Location: inventory_list.php");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
$backPage = ($userRole === 'A') ? '../admin/home_admin.php' : (($userRole === 'M') ? '../manager/home_manager.php' : '../staff/home_staff.php');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Aset - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-teal: #7AB2B2;
            --secondary-teal: #4D869C;
            --light-mint: #CDE8E5;
            --lightest-mint: #EEF7FF;
            --bg-light: #f8fafc;
            --text-dark: #1e293b;
            --text-medium: #475569;
            --text-light: #64748b;
            --border-color: #e2e8f0;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, var(--lightest-mint) 0%, var(--light-mint) 100%);
            padding: 25px;
            color: var(--text-dark);
            min-height: 100vh;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: white;
            padding: 24px 28px;
            border-radius: 16px;
            border-left: 5px solid var(--primary-teal);
            margin-bottom: 24px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.06);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }

        .header h1 {
            font-size: 26px;
            font-weight: 800;
            color: var(--text-dark);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .btn {
            padding: 11px 20px;
            border-radius: 12px;
            text-decoration: none;
            font-weight: 700;
            font-size: 13px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-secondary {
            background: white;
            border: 2px solid var(--border-color);
            color: var(--text-dark);
        }

        .btn-secondary:hover {
            background: var(--bg-light);
            border-color: var(--primary-teal);
        }

        .card {
            background: white;
            border-radius: 16px;
            padding: 30px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.04);
            margin-bottom: 24px;
            border: 1px solid var(--border-color);
        }

        .card h2 {
            color: var(--secondary-teal);
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 2px solid var(--light-mint);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .detail-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 24px;
        }

        .detail-item {
            padding: 16px;
            background: var(--bg-light);
            border-radius: 12px;
            border-left: 3px solid var(--primary-teal);
        }

        .detail-item.full {
            grid-column: 1 / -1;
        }

        .detail-label {
            font-size: 12px;
            color: var(--text-medium);
            margin-bottom: 8px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .detail-label i {
            color: var(--primary-teal);
        }

        .detail-value {
            font-size: 16px;
            color: var(--text-dark);
            font-weight: 600;
        }

        .badge {
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 700;
            display: inline-block;
            letter-spacing: 0.5px;
        }

        .badge-success {
            background: #d1fae5;
            color: #065f46;
        }

        .badge-warning {
            background: #fef3c7;
            color: #92400e;
        }

        .badge-danger {
            background: #fee2e2;
            color: #991b1b;
        }

        .badge-info {
            background: #dbeafe;
            color: #1e40af;
        }

        .kode-badge {
            background: linear-gradient(135deg, var(--secondary-teal), var(--primary-teal));
            color: white;
            padding: 10px 16px;
            border-radius: 10px;
            font-family: 'Courier New', monospace;
            font-weight: 700;
            font-size: 16px;
            display: inline-block;
            box-shadow: 0 4px 8px rgba(77, 134, 156, 0.3);
            letter-spacing: 1px;
        }

        .info-banner {
            background: linear-gradient(135deg, var(--primary-teal), var(--secondary-teal));
            color: white;
            padding: 24px;
            border-radius: 16px;
            margin-bottom: 24px;
            box-shadow: 0 4px 12px rgba(122, 178, 178, 0.3);
        }

        .info-banner h3 {
            font-size: 22px;
            font-weight: 800;
            margin-bottom: 8px;
        }

        .info-banner p {
            font-size: 14px;
            opacity: 0.9;
        }

        .price-highlight {
            font-size: 28px;
            font-weight: 800;
            color: var(--primary-teal);
            background: white;
            padding: 16px 24px;
            border-radius: 12px;
            display: inline-block;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        /* Photo Gallery Styles */
        .photo-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .photo-item {
            position: relative;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            cursor: pointer;
            background: var(--bg-light);
        }

        .photo-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        }

        .photo-item img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            display: block;
        }

        .no-photo {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 60px 20px;
            background: var(--bg-light);
            border-radius: 12px;
            border: 2px dashed var(--border-color);
            text-align: center;
        }

        .no-photo i {
            font-size: 64px;
            color: var(--border-color);
            margin-bottom: 16px;
        }

        .no-photo p {
            color: var(--text-light);
            font-size: 14px;
            font-weight: 500;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 9999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.9);
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .modal-content {
            position: relative;
            margin: auto;
            padding: 20px;
            width: 90%;
            max-width: 900px;
            top: 50%;
            transform: translateY(-50%);
        }

        .modal-content img {
            width: 100%;
            height: auto;
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.3);
        }

        .modal-close {
            position: absolute;
            top: 20px;
            right: 35px;
            color: white;
            font-size: 40px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.3s ease;
            z-index: 10000;
        }

        .modal-close:hover {
            color: var(--primary-teal);
        }

        .photo-caption {
            text-align: center;
            color: white;
            margin-top: 15px;
            font-size: 16px;
            font-weight: 600;
        }

        @media (max-width: 768px) {
            body {
                padding: 16px;
            }

            .detail-grid {
                grid-template-columns: 1fr;
            }

            .header {
                padding: 20px;
            }

            .header h1 {
                font-size: 20px;
            }

            .card {
                padding: 20px;
            }

            .photo-container {
                grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
                gap: 12px;
            }

            .photo-item img {
                height: 180px;
            }

            .modal-content {
                width: 95%;
                padding: 10px;
            }

            .modal-close {
                top: 10px;
                right: 20px;
                font-size: 32px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>
                <i class="fas fa-info-circle" style="color: var(--primary-teal);"></i> 
                Detail Aset
            </h1>
            <a href="inventory_list.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <!-- Info Banner -->
        <div class="info-banner">
            <h3><?php echo htmlspecialchars(isset($barang['jenis_barang']) ? $barang['jenis_barang'] : 'Detail Aset'); ?></h3>
            <p>
                <i class="fas fa-barcode"></i> 
                Kode: <strong><?php 
                    $kode = '';
                    if (isset($barang['kode_aset_auto']) && !empty($barang['kode_aset_auto'])) {
                        $kode = $barang['kode_aset_auto'];
                    } elseif (isset($barang['kode_aset']) && !empty($barang['kode_aset'])) {
                        $kode = $barang['kode_aset'];
                    } else {
                        $kode = 'NO-CODE';
                    }
                    echo htmlspecialchars($kode);
                ?></strong>
                <?php if (isset($barang['created_at']) && !empty($barang['created_at'])): ?>
                    &nbsp;|&nbsp; 
                    <i class="fas fa-calendar-plus"></i> 
                    Ditambahkan: <?php echo formatTanggalIndo(date('Y-m-d', strtotime($barang['created_at']))); ?>
                <?php endif; ?>
            </p>
        </div>

        <!-- Foto Barang -->
        <div class="card">
            <h2><i class="fas fa-camera"></i> Foto Barang</h2>
            <div class="photo-container">
                <?php
                $photoPath = isset($barang['foto']) ? $barang['foto'] : '';
                
                if (!empty($photoPath) && file_exists('../../' . $photoPath)) {
                    // Jika foto ada, tampilkan
                    echo '<div class="photo-item" onclick="openModal(\'' . htmlspecialchars($photoPath) . '\')">';
                    echo '<img src="../../' . htmlspecialchars($photoPath) . '" alt="Foto Barang">';
                    echo '</div>';
                } else {
                    // Jika foto tidak ada
                    echo '<div class="no-photo">';
                    echo '<i class="fas fa-image"></i>';
                    echo '<p>Tidak ada foto tersedia untuk barang ini</p>';
                    echo '</div>';
                }
                ?>
            </div>
        </div>

        <!-- Detail Barang -->
        <div class="card">
            <h2><i class="fas fa-clipboard-list"></i> Informasi Barang</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-barcode"></i> Kode Aset
                    </div>
                    <div class="detail-value">
                        <span class="kode-badge">
                            <?php 
                            $kode = '';
                            if (isset($barang['kode_aset_auto']) && !empty($barang['kode_aset_auto'])) {
                                $kode = $barang['kode_aset_auto'];
                            } elseif (isset($barang['kode_aset']) && !empty($barang['kode_aset'])) {
                                $kode = $barang['kode_aset'];
                            } else {
                                $kode = 'NO-CODE';
                            }
                            echo htmlspecialchars($kode);
                            ?>
                        </span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-calendar"></i> Tanggal Perolehan
                    </div>
                    <div class="detail-value">
                        <?php echo formatTanggalIndo($barang['tanggal_perolehan']); ?>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-tags"></i> Kategori
                    </div>
                    <div class="detail-value">
                        <?php echo htmlspecialchars(isset($barang['kategori']) ? $barang['kategori'] : '-'); ?>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-box"></i> Jenis Barang
                    </div>
                    <div class="detail-value">
                        <?php echo htmlspecialchars(isset($barang['jenis_barang']) ? $barang['jenis_barang'] : '-'); ?>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-building"></i> Lokasi Kantor
                    </div>
                    <div class="detail-value">
                        <?php echo htmlspecialchars(isset($barang['kantor']) ? $barang['kantor'] : '-'); ?>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-wallet"></i> Sumber Dana
                    </div>
                    <div class="detail-value">
                        <?php echo htmlspecialchars(isset($barang['sumber_dana']) ? $barang['sumber_dana'] : '-'); ?>
                    </div>
                </div>

                <div class="detail-item full">
                    <div class="detail-label">
                        <i class="fas fa-dollar-sign"></i> Harga Perolehan
                    </div>
                    <div class="detail-value">
                        <span class="price-highlight">
                            <?php echo formatRupiah($barang['harga_perolehan']); ?>
                        </span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-check-circle"></i> Kondisi
                    </div>
                    <div class="detail-value">
                        <?php
                        $kondisi = isset($barang['kondisi']) && !empty($barang['kondisi']) ? $barang['kondisi'] : 'Baik';
                        $badgeClass = 'badge-success';
                        
                        if (in_array($kondisi, ['Rusak Ringan', 'Perlu Perbaikan'])) {
                            $badgeClass = 'badge-warning';
                        } elseif (in_array($kondisi, ['Rusak Berat', 'Tidak Berfungsi'])) {
                            $badgeClass = 'badge-danger';
                        }
                        ?>
                        <span class="badge <?php echo $badgeClass; ?>">
                            <?php echo htmlspecialchars($kondisi); ?>
                        </span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-info-circle"></i> Status
                    </div>
                    <div class="detail-value">
                        <?php
                        $status = isset($barang['status']) && !empty($barang['status']) ? $barang['status'] : 'Aktif';
                        $statusClass = $status == 'Aktif' ? 'badge-success' : 'badge-danger';
                        ?>
                        <span class="badge <?php echo $statusClass; ?>">
                            <?php echo htmlspecialchars($status); ?>
                        </span>
                    </div>
                </div>

                <?php if (!empty($barang['spesifikasi'])): ?>
                <div class="detail-item full">
                    <div class="detail-label">
                        <i class="fas fa-list-ul"></i> Spesifikasi
                    </div>
                    <div class="detail-value" style="line-height: 1.6;">
                        <?php echo nl2br(htmlspecialchars($barang['spesifikasi'])); ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (!empty($barang['keterangan'])): ?>
                <div class="detail-item full">
                    <div class="detail-label">
                        <i class="fas fa-sticky-note"></i> Keterangan
                    </div>
                    <div class="detail-value" style="line-height: 1.6;">
                        <?php echo nl2br(htmlspecialchars($barang['keterangan'])); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Informasi Tambahan -->
        <div class="card">
            <h2><i class="fas fa-database"></i> Informasi Sistem</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-hashtag"></i> ID Barang
                    </div>
                    <div class="detail-value">
                        #<?php echo $barang['id']; ?>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-sort-numeric-up"></i> No. Urut
                    </div>
                    <div class="detail-value">
                        <?php echo htmlspecialchars(isset($barang['no_urut']) ? $barang['no_urut'] : '-'); ?>
                    </div>
                </div>

                <?php if (!empty($barang['created_at'])): ?>
                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-calendar-plus"></i> Dibuat Pada
                    </div>
                    <div class="detail-value">
                        <?php echo date('d/m/Y H:i', strtotime($barang['created_at'])); ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (!empty($barang['updated_at'])): ?>
                <div class="detail-item">
                    <div class="detail-label">
                        <i class="fas fa-calendar-check"></i> Update Terakhir
                    </div>
                    <div class="detail-value">
                        <?php echo date('d/m/Y H:i', strtotime($barang['updated_at'])); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Modal untuk melihat foto -->
    <div id="photoModal" class="modal" onclick="closeModal()">
        <span class="modal-close">&times;</span>
        <div class="modal-content" onclick="event.stopPropagation()">
            <img id="modalImage" src="" alt="Foto Barang">
            <div class="photo-caption">Klik di luar gambar untuk menutup</div>
        </div>
    </div>

    <script>
        function openModal(imagePath) {
            const modal = document.getElementById('photoModal');
            const modalImg = document.getElementById('modalImage');
            
            modal.style.display = 'block';
            modalImg.src = '../../' + imagePath;
            
            // Prevent body scroll when modal is open
            document.body.style.overflow = 'hidden';
        }

        function closeModal() {
            const modal = document.getElementById('photoModal');
            modal.style.display = 'none';
            
            // Restore body scroll
            document.body.style.overflow = 'auto';
        }

        // Close modal with ESC key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeModal();
            }
        });
    </script>
</body>
</html>
<?php
$stmt->close();
$conn->close();
?>