<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../database/koneksi.php';

$sql = "SELECT * FROM inventory ORDER BY tanggal_perolehan DESC, no DESC";
$result = $koneksi->query($sql);

if (!$result) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $koneksi->error]);
    exit;
}

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode([
    'success' => true,
    'data' => $data,
    'count' => count($data)
]);

$koneksi->close();
?>