<?php
// Menu berdasarkan role user
$userRole = $_SESSION['user_type'] ?? 'S';
?>
<style>
.menu-section {
    padding: 10px 0;
}

.menu-title {
    padding: 10px 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    opacity: 0.7;
    color: white;
}

.menu-item {
    display: block;
    padding: 12px 20px;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
    border-left: 3px solid transparent;
}

.menu-item:hover {
    background: rgba(255,255,255,0.1);
    border-left-color: white;
    padding-left: 25px;
}

.menu-item.active {
    background: rgba(255,255,255,0.15);
    border-left-color: white;
}

.menu-item i {
    width: 20px;
    margin-right: 10px;
    text-align: center;
}
</style>

<div class="menu-section">
    <div class="menu-title">Menu Utama</div>
    <a href="pages/dashboard_home.php" target="content" class="menu-item">
        <i class="fas fa-home"></i> Dashboard
    </a>
    <a href="pages/inventory_list.php" target="content" class="menu-item">
        <i class="fas fa-list"></i> Daftar Inventory
    </a>
    
    <?php if ($userRole === 'A' || strtolower($userRole) === 'admin'): ?>
    <a href="pages/Admin/tambah_barang.php" target="content" class="menu-item">
        <i class="fas fa-plus-circle"></i> Tambah Inventory
    </a>
    <?php endif; ?>
</div>

<div class="menu-section">
    <div class="menu-title">Laporan</div>
    <a href="pages/laporan/ringkasan.php" target="content" class="menu-item">
        <i class="fas fa-chart-bar"></i> Ringkasan
    </a>
    <a href="pages/laporan/per_kantor.php" target="content" class="menu-item">
        <i class="fas fa-building"></i> Per Kantor
    </a>
</div>

<?php if ($userRole === 'A' || strtolower($userRole) === 'admin'): ?>
<div class="menu-section">
    <div class="menu-title">Pengaturan</div>
    <a href="pages/Admin/kelola_kategori.php" target="content" class="menu-item">
        <i class="fas fa-tags"></i> Kategori
    </a>
    <a href="pages/Admin/kelola_kantor.php" target="content" class="menu-item">
        <i class="fas fa-building"></i> Kantor
    </a>
    <a href="pages/Admin/kelola_users.php" target="content" class="menu-item">
        <i class="fas fa-users"></i> Pengguna
    </a>
</div>
<?php endif; ?>

<div class="menu-section">
    <div class="menu-title">Lainnya</div>
    <a href="pages/profil.php" target="content" class="menu-item">
        <i class="fas fa-user"></i> Profil
    </a>
</div>

<script>
// Highlight active menu
document.addEventListener('DOMContentLoaded', function() {
    const menuItems = document.querySelectorAll('.menu-item');
    const iframe = window.parent.document.getElementById('contentFrame');
    
    menuItems.forEach(item => {
        item.addEventListener('click', function() {
            menuItems.forEach(i => i.classList.remove('active'));
            this.classList.add('active');
        });
    });
    
    // Set active based on current iframe src
    if (iframe) {
        const currentSrc = iframe.src;
        menuItems.forEach(item => {
            if (currentSrc.includes(item.getAttribute('href'))) {
                item.classList.add('active');
            }
        });
    }
});
</script>