<?php
session_start();

// Cek login
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

// Koneksi database
require_once __DIR__ . '/../../DataBase/koneksi.php';

// Query untuk data inventory lengkap
$queryInventory = "SELECT * FROM inventory ORDER BY tanggal_perolehan ASC, no ASC";
$resultInventory = $conn->query($queryInventory);

// Hitung total
$dataInventory = [];
$totalItems = 0;
$totalNilai = 0;

while ($row = $resultInventory->fetch_assoc()) {
    $dataInventory[] = $row;
    $totalItems++;
    $totalNilai += $row['harga_perolehan'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Daftar Inventory ACF</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 10mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body { 
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; 
            font-size: 9pt;
            line-height: 1.4;
            color: #1a1a1a;
            background: white;
        }
        
        /* Header */
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding: 18px;
            background: linear-gradient(135deg, #4472C4 0%, #5B82D6 100%);
            color: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            font-size: 20pt;
            margin-bottom: 5px;
            font-weight: 700;
            letter-spacing: 0.5px;
        }

        .header p {
            font-size: 9pt;
            opacity: 0.9;
        }
        
        /* Print Buttons */
        .no-print {
            position: fixed;
            top: 15px;
            right: 15px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }
        
        .btn {
            padding: 10px 18px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 11pt;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
            transition: all 0.2s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #4472C4 0%, #5B82D6 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
        
        /* Table */
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            border-radius: 8px;
            overflow: hidden;
        }
        
        thead {
            background: linear-gradient(135deg, #4472C4 0%, #5B82D6 100%);
        }
        
        th {
            padding: 12px 10px;
            text-align: left;
            font-weight: 600;
            font-size: 9pt;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: white;
            border-right: 1px solid rgba(255,255,255,0.2);
        }

        th:last-child {
            border-right: none;
        }
        
        td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 8pt;
            color: #1a1a1a;
            vertical-align: top;
            border-right: 1px solid #f1f3f5;
        }

        td:last-child {
            border-right: none;
        }
        
        tbody tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        tbody tr:hover {
            background: #e9ecef;
        }

        tbody tr:last-child td {
            border-bottom: 2px solid #4472C4;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-right {
            text-align: right;
        }
        
        td:first-child {
            text-align: center;
            font-weight: 600;
            color: #6c757d;
        }
        
        td:nth-child(2) {
            text-align: center;
            white-space: nowrap;
            font-weight: 500;
        }
        
        td:nth-child(7) {
            font-size: 7pt;
            line-height: 1.4;
        }
        
        td:nth-child(8) {
            text-align: right;
            font-weight: 700;
            font-family: 'Courier New', monospace;
            color: #1a1a1a;
        }

        /* Total Summary */
        .total-summary {
            margin-top: 20px;
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .total-item {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 15px 20px;
            border-radius: 8px;
            border-left: 5px solid #4472C4;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .total-item strong {
            color: #6c757d;
            font-size: 10pt;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .total-item .value {
            color: #1a1a1a;
            font-size: 14pt;
            font-weight: 700;
            font-family: 'Courier New', monospace;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none !important;
            }
            
            .header {
                background: linear-gradient(135deg, #4472C4 0%, #5B82D6 100%) !important;
            }
            
            thead {
                display: table-header-group;
                background: linear-gradient(135deg, #4472C4 0%, #5B82D6 100%) !important;
            }
            
            th {
                background: #4472C4 !important;
                color: white !important;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            tbody tr:nth-child(even) {
                background: #f8f9fa !important;
            }

            .total-summary {
                page-break-inside: avoid;
            }

            .total-item {
                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
                border-left: 5px solid #4472C4 !important;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="btn btn-primary">
            <span>🖨️</span> Print / Save PDF
        </button>
        <button onclick="window.close()" class="btn btn-secondary">
            <span>✖</span> Close
        </button>
    </div>

    <div class="header">
        <h1>DAFTAR INVENTORY ACF</h1>
        <p>Tanggal Export: <?php echo date('d F Y, H:i:s'); ?> WIB</p>
    </div>
    
    <table>
        <thead>
            <tr>
                <th style="width: 3%;">No</th>
                <th style="width: 8%;">Tanggal Perolehan</th>
                <th style="width: 8%;">Kategori</th>
                <th style="width: 10%;">Sumber Dana</th>
                <th style="width: 12%;">Kantor</th>
                <th style="width: 10%;">Jenis Barang</th>
                <th style="width: 38%;">Jenis Inventory</th>
                <th style="width: 11%;">Harga Perolehan</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            foreach ($dataInventory as $row): 
            ?>
            <tr>
                <td><?php echo $no++; ?></td>
                <td><?php echo date('d-M-y', strtotime($row['tanggal_perolehan'])); ?></td>
                <td><?php echo htmlspecialchars($row['kategori'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($row['sumber_dana'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($row['kantor'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($row['jenis_barang'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($row['jenis_inventory'] ?? '-'); ?></td>
                <td><?php echo number_format($row['harga_perolehan'], 0, ',', ','); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="total-summary">
        <div class="total-item">
            <strong>Total Item:</strong>
            <span class="value"><?php echo number_format($totalItems); ?> Item</span>
        </div>
        <div class="total-item">
            <strong>Total Keseluruhan:</strong>
            <span class="value">Rp <?php echo number_format($totalNilai, 0, ',', '.'); ?></span>
        </div>
    </div>
</body>
</html>