<?php
session_start();

require_once __DIR__ . '/../../DataBase/koneksi.php';

// Cek login dan role
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'S') {
    header("Location: ../../index.html?error=unauthorized");
    exit;
}

// Get filter parameters
$tipe = isset($_GET['tipe']) ? $_GET['tipe'] : 'all';
$tanggal_dari = isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : date('Y-m-01');
$tanggal_sampai = isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : date('Y-m-d');
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build query for barang masuk
$queryMasuk = "SELECT 'masuk' as tipe, bm.id_masuk as id, bm.tanggal_masuk as tanggal, bm.jumlah, 
               b.nama_barang, b.kode_barang, bm.supplier as detail, bm.keterangan 
               FROM barang_masuk bm 
               JOIN barang b ON bm.id_barang = b.id_barang 
               WHERE DATE(bm.tanggal_masuk) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";

if (!empty($search)) {
    $queryMasuk .= " AND (b.nama_barang LIKE '%$search%' OR b.kode_barang LIKE '%$search%')";
}

// Build query for barang keluar
$queryKeluar = "SELECT 'keluar' as tipe, bk.id_keluar as id, bk.tanggal_keluar as tanggal, bk.jumlah, 
                b.nama_barang, b.kode_barang, bk.tujuan as detail, bk.keterangan 
                FROM barang_keluar bk 
                JOIN barang b ON bk.id_barang = b.id_barang 
                WHERE DATE(bk.tanggal_keluar) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";

if (!empty($search)) {
    $queryKeluar .= " AND (b.nama_barang LIKE '%$search%' OR b.kode_barang LIKE '%$search%')";
}

// Combine queries based on filter
if ($tipe === 'all') {
    $query = "($queryMasuk) UNION ($queryKeluar) ORDER BY tanggal DESC";
} elseif ($tipe === 'masuk') {
    $query = $queryMasuk . " ORDER BY bm.tanggal_masuk DESC";
} else {
    $query = $queryKeluar . " ORDER BY bk.tanggal_keluar DESC";
}

$result = $conn->query($query);

// Get statistics
$statsMasuk = $conn->query("SELECT COUNT(*) as total, SUM(jumlah) as total_qty FROM barang_masuk WHERE DATE(tanggal_masuk) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'")->fetch_assoc();
$statsKeluar = $conn->query("SELECT COUNT(*) as total, SUM(jumlah) as total_qty FROM barang_keluar WHERE DATE(tanggal_keluar) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Transaksi - Staff Aset</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Header */
        .page-header {
            background: white;
            border-radius: 20px;
            padding: 30px 40px;
            margin-bottom: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }

        .page-header h1 {
            font-size: 32px;
            color: #1a202c;
            margin-bottom: 8px;
            font-weight: 800;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .page-header p {
            color: #64748b;
            font-size: 16px;
        }

        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 20px;
            padding: 25px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            flex-shrink: 0;
        }

        .stat-icon.masuk {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
        }

        .stat-icon.keluar {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
        }

        .stat-icon.total {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
        }

        .stat-content h3 {
            font-size: 13px;
            color: #64748b;
            margin-bottom: 5px;
            text-transform: uppercase;
            font-weight: 600;
        }

        .stat-content .value {
            font-size: 28px;
            font-weight: 800;
            color: #1a202c;
        }

        .stat-content .sub {
            font-size: 12px;
            color: #94a3b8;
            margin-top: 3px;
        }

        /* Filter Card */
        .filter-card {
            background: white;
            border-radius: 20px;
            padding: 25px 30px;
            margin-bottom: 25px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }

        .filter-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            align-items: end;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-group label {
            font-size: 13px;
            font-weight: 600;
            color: #334155;
            margin-bottom: 8px;
        }

        .form-control {
            padding: 10px 14px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Plus Jakarta Sans', sans-serif;
            transition: all 0.3s;
        }

        .form-control:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
            font-family: 'Plus Jakarta Sans', sans-serif;
            justify-content: center;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f1f5f9;
            color: #475569;
        }

        .btn-secondary:hover {
            background: #e2e8f0;
        }

        /* Tab Filter */
        .tab-filter {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        .tab-btn {
            padding: 10px 20px;
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            color: #64748b;
            transition: all 0.3s;
            text-decoration: none;
        }

        .tab-btn.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-color: transparent;
        }

        /* Transactions Table */
        .transactions-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        thead {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        th {
            color: white;
            padding: 15px;
            text-align: left;
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        tbody tr {
            border-bottom: 1px solid #e2e8f0;
            transition: background 0.2s;
        }

        tbody tr:hover {
            background: #f8fafc;
        }

        td {
            padding: 15px;
            font-size: 14px;
            color: #4a5568;
        }

        .badge {
            padding: 5px 12px;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 700;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .badge.masuk {
            background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
            color: #065f46;
        }

        .badge.keluar {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            color: #991b1b;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
        }

        .empty-state i {
            font-size: 64px;
            color: #cbd5e1;
            margin-bottom: 20px;
        }

        .empty-state h3 {
            font-size: 20px;
            color: #475569;
            margin-bottom: 10px;
        }

        .empty-state p {
            color: #64748b;
        }

        @media (max-width: 768px) {
            body {
                padding: 10px;
            }

            .page-header {
                padding: 20px;
            }

            .page-header h1 {
                font-size: 24px;
            }

            .filter-grid {
                grid-template-columns: 1fr;
            }

            .tab-filter {
                flex-wrap: wrap;
            }

            table {
                font-size: 12px;
            }

            th, td {
                padding: 10px 8px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Page Header -->
        <div class="page-header">
            <h1>
                <i class="fas fa-history"></i>
                Riwayat Transaksi
            </h1>
            <p>Daftar transaksi barang masuk dan keluar</p>
        </div>

        <!-- Stats Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon masuk">
                    <i class="fas fa-arrow-down"></i>
                </div>
                <div class="stat-content">
                    <h3>Barang Masuk</h3>
                    <div class="value"><?php echo $statsMasuk['total'] ?? 0; ?></div>
                    <div class="sub"><?php echo number_format($statsMasuk['total_qty'] ?? 0); ?> unit</div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon keluar">
                    <i class="fas fa-arrow-up"></i>
                </div>
                <div class="stat-content">
                    <h3>Barang Keluar</h3>
                    <div class="value"><?php echo $statsKeluar['total'] ?? 0; ?></div>
                    <div class="sub"><?php echo number_format($statsKeluar['total_qty'] ?? 0); ?> unit</div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon total">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <div class="stat-content">
                    <h3>Total Transaksi</h3>
                    <div class="value"><?php echo ($statsMasuk['total'] ?? 0) + ($statsKeluar['total'] ?? 0); ?></div>
                    <div class="sub">Periode dipilih</div>
                </div>
            </div>
        </div>

        <!-- Filter Card -->
        <div class="filter-card">
            <form method="GET" action="">
                <div class="filter-grid">
                    <div class="filter-group">
                        <label>Tanggal Dari</label>
                        <input type="date" name="tanggal_dari" class="form-control" value="<?php echo $tanggal_dari; ?>">
                    </div>

                    <div class="filter-group">
                        <label>Tanggal Sampai</label>
                        <input type="date" name="tanggal_sampai" class="form-control" value="<?php echo $tanggal_sampai; ?>">
                    </div>

                    <div class="filter-group">
                        <label>Cari Barang</label>
                        <input type="text" name="search" class="form-control" placeholder="Nama atau kode barang" value="<?php echo htmlspecialchars($search); ?>">
                    </div>

                    <div class="filter-group">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Filter
                        </button>
                    </div>

                    <?php if (!empty($search) || $tanggal_dari !== date('Y-m-01') || $tanggal_sampai !== date('Y-m-d')): ?>
                    <div class="filter-group">
                        <a href="riwayat_transaksi.php" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Reset
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </form>
        </div>

        <!-- Tab Filter -->
        <div class="tab-filter">
            <a href="?tipe=all&tanggal_dari=<?php echo $tanggal_dari; ?>&tanggal_sampai=<?php echo $tanggal_sampai; ?>&search=<?php echo urlencode($search); ?>" 
               class="tab-btn <?php echo $tipe === 'all' ? 'active' : ''; ?>">
                <i class="fas fa-th-list"></i> Semua
            </a>
            <a href="?tipe=masuk&tanggal_dari=<?php echo $tanggal_dari; ?>&tanggal_sampai=<?php echo $tanggal_sampai; ?>&search=<?php echo urlencode($search); ?>" 
               class="tab-btn <?php echo $tipe === 'masuk' ? 'active' : ''; ?>">
                <i class="fas fa-arrow-down"></i> Barang Masuk
            </a>
            <a href="?tipe=keluar&tanggal_dari=<?php echo $tanggal_dari; ?>&tanggal_sampai=<?php echo $tanggal_sampai; ?>&search=<?php echo urlencode($search); ?>" 
               class="tab-btn <?php echo $tipe === 'keluar' ? 'active' : ''; ?>">
                <i class="fas fa-arrow-up"></i> Barang Keluar
            </a>
        </div>

        <!-- Transactions Table -->
        <div class="transactions-card">
            <div class="table-container">
                <?php if ($result->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>NO</th>
                            <th>TIPE</th>
                            <th>TANGGAL</th>
                            <th>KODE BARANG</th>
                            <th>NAMA BARANG</th>
                            <th>JUMLAH</th>
                            <th>SUPPLIER/TUJUAN</th>
                            <th>KETERANGAN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($trans = $result->fetch_assoc()): 
                        ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td>
                                <span class="badge <?php echo $trans['tipe']; ?>">
                                    <i class="fas fa-arrow-<?php echo $trans['tipe'] === 'masuk' ? 'down' : 'up'; ?>"></i>
                                    <?php echo ucfirst($trans['tipe']); ?>
                                </span>
                            </td>
                            <td><?php echo date('d/m/Y H:i', strtotime($trans['tanggal'])); ?></td>
                            <td><strong><?php echo htmlspecialchars($trans['kode_barang']); ?></strong></td>
                            <td><?php echo htmlspecialchars($trans['nama_barang']); ?></td>
                            <td>
                                <strong style="color: <?php echo $trans['tipe'] === 'masuk' ? '#10b981' : '#ef4444'; ?>">
                                    <?php echo $trans['tipe'] === 'masuk' ? '+' : '-'; ?><?php echo $trans['jumlah']; ?>
                                </strong>
                            </td>
                            <td><?php echo htmlspecialchars($trans['detail'] ?? '-'); ?></td>
                            <td><?php echo htmlspecialchars($trans['keterangan'] ?? '-'); ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
                <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <h3>Tidak Ada Data</h3>
                    <p>Tidak ada transaksi dalam periode yang dipilih</p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Action Buttons -->
        <div style="display: flex; gap: 15px; justify-content: center; margin-top: 25px;">
            <a href="dashboard_staff.php" class="btn btn-primary">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a href="barang_masuk.php" class="btn btn-secondary">
                <i class="fas fa-arrow-down"></i> Barang Masuk
            </a>
            <a href="barang_keluar.php" class="btn btn-secondary">
                <i class="fas fa-arrow-up"></i> Barang Keluar
            </a>
        </div>
    </div>
</body>
</html>